/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.github.davidmoten.guavamini.Sets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieTTLConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.action.ttl.strategy.PartitionTTLStrategyType;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.testutils.HoodieMergeOnReadTestUtils;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPartitionTTLManagement
extends HoodieClientTestBase {
    protected HoodieWriteConfig.Builder getConfigBuilder(Boolean autoCommit) {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withAutoCommit(autoCommit.booleanValue()).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x40000000L).withInlineCompaction(Boolean.valueOf(false)).withMaxNumDeltaCommitsBeforeCompaction(1).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x40000000L).parquetMaxFileSize(0x40000000L).orcMaxFileSize(0x40000000L).build()).forTable("test-trip-table").withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withEmbeddedTimelineServerEnabled(true).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.EMBEDDED_KV_STORE).build());
    }

    @Test
    public void testKeepByCreationTime() {
        HoodieWriteConfig cfg = this.getConfigBuilder(true).withPath(this.metaClient.getBasePath()).withTTLConfig(HoodieTTLConfig.newBuilder().withTTLDaysRetain(Integer.valueOf(10)).withTTLStrategyType(PartitionTTLStrategyType.KEEP_BY_CREATION_TIME).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).build();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String partitionPath0 = dataGen.getPartitionPaths()[0];
            String instant0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            this.writeRecordsForPartition(client, dataGen, partitionPath0, instant0);
            String instant1 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)1000L);
            String partitionPath1 = dataGen.getPartitionPaths()[1];
            this.writeRecordsForPartition(client, dataGen, partitionPath1, instant1);
            String currentInstant = client.createNewInstantTime();
            String partitionPath2 = dataGen.getPartitionPaths()[2];
            this.writeRecordsForPartition(client, dataGen, partitionPath2, currentInstant);
            HoodieWriteResult result = client.managePartitionTTL(client.createNewInstantTime());
            Assertions.assertEquals((Object)Sets.newHashSet((Object[])new String[]{partitionPath0, partitionPath1}), result.getPartitionToReplaceFileIds().keySet());
            Assertions.assertEquals((int)10, (int)this.readRecords(new String[]{partitionPath0, partitionPath1, partitionPath2}).size());
        }
    }

    @Test
    public void testKeepByTime() {
        HoodieWriteConfig cfg = this.getConfigBuilder(true).withPath(this.metaClient.getBasePath()).withTTLConfig(HoodieTTLConfig.newBuilder().withTTLDaysRetain(Integer.valueOf(10)).withTTLStrategyType(PartitionTTLStrategyType.KEEP_BY_TIME).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).build();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String partitionPath0 = dataGen.getPartitionPaths()[0];
            String instant0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            this.writeRecordsForPartition(client, dataGen, partitionPath0, instant0);
            String instant1 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)1000L);
            String partitionPath1 = dataGen.getPartitionPaths()[1];
            this.writeRecordsForPartition(client, dataGen, partitionPath1, instant1);
            String currentInstant = client.createNewInstantTime();
            String partitionPath2 = dataGen.getPartitionPaths()[2];
            this.writeRecordsForPartition(client, dataGen, partitionPath2, currentInstant);
            HoodieWriteResult result = client.managePartitionTTL(client.createNewInstantTime());
            Assertions.assertEquals((Object)Sets.newHashSet((Object[])new String[]{partitionPath0, partitionPath1}), result.getPartitionToReplaceFileIds().keySet());
            Assertions.assertEquals((int)10, (int)this.readRecords(new String[]{partitionPath0, partitionPath1, partitionPath2}).size());
        }
    }

    @Test
    public void testInlinePartitionTTL() {
        HoodieWriteConfig cfg = this.getConfigBuilder(true).withPath(this.metaClient.getBasePath()).withTTLConfig(HoodieTTLConfig.newBuilder().withTTLDaysRetain(Integer.valueOf(10)).withTTLStrategyType(PartitionTTLStrategyType.KEEP_BY_TIME).enableInlinePartitionTTL(Boolean.valueOf(true)).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().build()).build();
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(cfg);){
            String partitionPath0 = dataGen.getPartitionPaths()[0];
            String instant0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
            this.writeRecordsForPartition(client, dataGen, partitionPath0, instant0);
            Assertions.assertEquals((int)0, (int)this.readRecords(new String[]{partitionPath0}).size());
            String instant1 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)1000L);
            String partitionPath1 = dataGen.getPartitionPaths()[1];
            this.writeRecordsForPartition(client, dataGen, partitionPath1, instant1);
            Assertions.assertEquals((int)0, (int)this.readRecords(new String[]{partitionPath1}).size());
            String currentInstant = client.createNewInstantTime();
            String partitionPath2 = dataGen.getPartitionPaths()[2];
            this.writeRecordsForPartition(client, dataGen, partitionPath2, currentInstant);
            Assertions.assertEquals((int)10, (int)this.readRecords(new String[]{partitionPath2}).size());
        }
    }

    private void writeRecordsForPartition(SparkRDDWriteClient client, HoodieTestDataGenerator dataGen, String partition, String instantTime) {
        List records = dataGen.generateInsertsForPartition(instantTime, Integer.valueOf(10), partition);
        client.startCommitWithTime(instantTime);
        JavaRDD writeStatuses = client.insert(this.jsc.parallelize(records, 1), instantTime);
        client.commit(instantTime, (Object)writeStatuses);
    }

    private List<GenericRecord> readRecords(String[] partitions) {
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat((StorageConfiguration)this.storageConf, Arrays.stream(partitions).map(p -> Paths.get(this.basePath, p).toString()).collect(Collectors.toList()), (String)this.basePath, (JobConf)new JobConf((Configuration)this.storageConf.unwrap()), (boolean)true, (boolean)true);
    }
}

