/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ExternalFilePathUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.spark.api.java.JavaRDD;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestExternalPathHandling
extends HoodieClientTestBase {
    private static final String FIELD_1 = "field1";
    private static final String FIELD_2 = "field2";
    private HoodieWriteConfig writeConfig;

    @ParameterizedTest
    @MethodSource(value={"getArgs"})
    public void testFlow(FileIdAndNameGenerator fileIdAndNameGenerator, List<String> partitions) throws Exception {
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        Properties properties = new Properties();
        properties.setProperty(HoodieMetadataConfig.AUTO_INITIALIZE.key(), "false");
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field(FIELD_1, Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        fields.add(new Schema.Field(FIELD_2, Schema.create((Schema.Type)Schema.Type.STRING), null, null));
        Schema simpleSchema = Schema.createRecord((String)"simpleSchema", null, null, (boolean)false, fields);
        this.writeConfig = HoodieWriteConfig.newBuilder().withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withPath(this.metaClient.getBasePath()).withEmbeddedTimelineServerEnabled(false).withMetadataConfig(HoodieMetadataConfig.newBuilder().withMaxNumDeltaCommitsBeforeCompaction(2).enable(true).withMetadataIndexColumnStats(true).withColumnStatsIndexForColumns("field1,field2").withProperties(properties).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(1, 2).build()).withTableServicesEnabled(true).withSchema(simpleSchema.toString()).build();
        this.writeClient = this.getHoodieWriteClient(this.writeConfig);
        this.writeClient.setOperationType(WriteOperationType.INSERT_OVERWRITE);
        String instantTime1 = this.writeClient.startCommit("replacecommit", this.metaClient);
        String partitionPath1 = partitions.get(0);
        Pair<String, String> fileIdAndName1 = fileIdAndNameGenerator.generate(1, instantTime1);
        String fileId1 = (String)fileIdAndName1.getLeft();
        String fileName1 = (String)fileIdAndName1.getRight();
        String filePath1 = this.getPath(partitionPath1, fileName1);
        WriteStatus writeStatus1 = this.createWriteStatus(instantTime1, partitionPath1, filePath1, fileId1);
        JavaRDD<WriteStatus> rdd1 = this.createRdd(Collections.singletonList(writeStatus1));
        this.metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", instantTime1), Option.empty());
        this.writeClient.commit(instantTime1, rdd1, Option.empty(), "replacecommit", Collections.emptyMap());
        this.assertFileGroupCorrectness(instantTime1, partitionPath1, filePath1, fileId1, 1);
        String instantTime2 = this.writeClient.startCommit("replacecommit", this.metaClient);
        Pair<String, String> fileIdAndName2 = fileIdAndNameGenerator.generate(2, instantTime2);
        String fileId2 = (String)fileIdAndName2.getLeft();
        String fileName2 = (String)fileIdAndName2.getRight();
        String filePath2 = this.getPath(partitionPath1, fileName2);
        WriteStatus newWriteStatus = this.createWriteStatus(instantTime2, partitionPath1, filePath2, fileId2);
        JavaRDD<WriteStatus> rdd2 = this.createRdd(Collections.singletonList(newWriteStatus));
        HashMap<String, List<String>> partitionToReplacedFileIds = new HashMap<String, List<String>>();
        partitionToReplacedFileIds.put(partitionPath1, Collections.singletonList(fileId1));
        this.metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", instantTime2), Option.empty());
        this.writeClient.commit(instantTime2, rdd2, Option.empty(), "replacecommit", partitionToReplacedFileIds);
        this.assertFileGroupCorrectness(instantTime2, partitionPath1, filePath2, fileId2, 1);
        String partitionPath2 = partitions.get(1);
        String instantTime3 = this.writeClient.startCommit("replacecommit", this.metaClient);
        Pair<String, String> fileIdAndName3 = fileIdAndNameGenerator.generate(3, instantTime3);
        String fileId3 = (String)fileIdAndName3.getLeft();
        String fileName3 = (String)fileIdAndName3.getRight();
        String filePath3 = this.getPath(partitionPath2, fileName3);
        WriteStatus writeStatus3 = this.createWriteStatus(instantTime3, partitionPath2, filePath3, fileId3);
        JavaRDD<WriteStatus> rdd3 = this.createRdd(Collections.singletonList(writeStatus3));
        this.metaClient.getActiveTimeline().transitionReplaceRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "replacecommit", instantTime3), Option.empty());
        this.writeClient.commit(instantTime3, rdd3, Option.empty(), "replacecommit", Collections.emptyMap());
        this.assertFileGroupCorrectness(instantTime3, partitionPath2, filePath3, fileId3, partitionPath2.isEmpty() ? 2 : 1);
        String cleanTime = this.writeClient.createNewInstantTime();
        HoodieCleanerPlan cleanerPlan = this.cleanerPlan(new HoodieActionInstant(instantTime2, "replacecommit", HoodieInstant.State.COMPLETED.name()), instantTime3, Collections.singletonMap(partitionPath1, Collections.singletonList(new HoodieCleanFileInfo(filePath1, Boolean.valueOf(false)))));
        this.metaClient.getActiveTimeline().saveToCleanRequested(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanTime), Option.of((Object)cleanerPlan));
        HoodieInstant inflightClean = this.metaClient.getActiveTimeline().transitionCleanRequestedToInflight(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", cleanTime), Option.empty());
        List<HoodieCleanStat> cleanStats = Collections.singletonList(this.createCleanStat(partitionPath1, Arrays.asList(filePath1), instantTime2, instantTime3));
        HoodieCleanMetadata cleanMetadata = CleanerUtils.convertCleanMetadata((String)cleanTime, (Option)Option.empty(), cleanStats, (Map)Collections.EMPTY_MAP);
        try (HoodieTableMetadataWriter hoodieTableMetadataWriter = (HoodieTableMetadataWriter)this.writeClient.initTable(WriteOperationType.UPSERT, Option.of((Object)cleanTime)).getMetadataWriter(cleanTime).get();){
            hoodieTableMetadataWriter.update(cleanMetadata, cleanTime);
            this.metaClient.getActiveTimeline().transitionCleanInflightToComplete(true, inflightClean, Option.of((Object)cleanMetadata));
            this.assertFileGroupCorrectness(instantTime2, partitionPath1, filePath2, fileId2, partitionPath2.isEmpty() ? 2 : 1);
            this.assertFileGroupCorrectness(instantTime3, partitionPath2, filePath3, fileId3, partitionPath2.isEmpty() ? 2 : 1);
            this.writeClient.archive();
            Assertions.assertEquals((int)1, (int)this.metaClient.getArchivedTimeline().reload().filterCompletedInstants().countInstants());
            this.assertFileGroupCorrectness(instantTime2, partitionPath1, filePath2, fileId2, partitionPath2.isEmpty() ? 2 : 1);
            this.assertFileGroupCorrectness(instantTime3, partitionPath2, filePath3, fileId3, partitionPath2.isEmpty() ? 2 : 1);
            HoodieBackedTableMetadata hoodieBackedTableMetadata = new HoodieBackedTableMetadata((HoodieEngineContext)this.context, this.metaClient.getStorage(), this.writeConfig.getMetadataConfig(), this.writeConfig.getBasePath(), true);
            this.assertEmptyColStats(hoodieBackedTableMetadata, partitionPath1, fileName1);
            this.assertColStats(hoodieBackedTableMetadata, partitionPath1, fileName2);
            this.assertColStats(hoodieBackedTableMetadata, partitionPath2, fileName3);
        }
    }

    static Stream<Arguments> getArgs() {
        FileIdAndNameGenerator external = (index, instantTime) -> {
            String fileName;
            String fileId = fileName = String.format("file_%d.parquet", index);
            return Pair.of((Object)fileId, (Object)fileName);
        };
        List<String> partitionedTable = Arrays.asList("americas/brazil", "americas/argentina");
        List<String> unpartitionedTable = Arrays.asList("", "");
        return Stream.of(Arguments.of((Object[])new Object[]{external, partitionedTable}), Arguments.of((Object[])new Object[]{external, unpartitionedTable}));
    }

    private String getPath(String partitionPath, String fileName) {
        if (partitionPath.isEmpty()) {
            return fileName;
        }
        return String.format("%s/%s", partitionPath, fileName);
    }

    private void assertFileGroupCorrectness(String instantTime, String partitionPath, String filePath, String fileId, int expectedSize) {
        HoodieTableMetadata tableMetadata = HoodieTableMetadata.create((HoodieEngineContext)this.context, (HoodieStorage)this.metaClient.getStorage(), (HoodieMetadataConfig)this.writeConfig.getMetadataConfig(), (String)this.metaClient.getBasePath().toString());
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(tableMetadata, this.metaClient, (HoodieTimeline)this.metaClient.reloadActiveTimeline());
        List fileGroups = fsView.getAllFileGroups(partitionPath).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedSize, (int)fileGroups.size());
        Option fileGroupOption = Option.fromJavaOptional(fileGroups.stream().filter(fg -> fg.getFileGroupId().getFileId().equals(fileId)).findFirst());
        Assertions.assertTrue((boolean)fileGroupOption.isPresent());
        HoodieFileGroup fileGroup = (HoodieFileGroup)fileGroupOption.get();
        Assertions.assertEquals((Object)fileId, (Object)fileGroup.getFileGroupId().getFileId());
        Assertions.assertEquals((Object)partitionPath, (Object)fileGroup.getPartitionPath());
        HoodieBaseFile baseFile = (HoodieBaseFile)fileGroup.getAllBaseFiles().findFirst().get();
        Assertions.assertEquals((Object)instantTime, (Object)baseFile.getCommitTime());
        Assertions.assertEquals((Object)(this.metaClient.getBasePath() + "/" + filePath), (Object)baseFile.getPath());
    }

    private void assertEmptyColStats(HoodieBackedTableMetadata hoodieBackedTableMetadata, String partitionPath, String fileName) {
        Assertions.assertTrue((boolean)hoodieBackedTableMetadata.getColumnStats(Collections.singletonList(Pair.of((Object)partitionPath, (Object)fileName)), FIELD_1).isEmpty());
        Assertions.assertTrue((boolean)hoodieBackedTableMetadata.getColumnStats(Collections.singletonList(Pair.of((Object)partitionPath, (Object)fileName)), FIELD_2).isEmpty());
    }

    private void assertColStats(HoodieBackedTableMetadata hoodieBackedTableMetadata, String partitionPath, String fileName) {
        Map field1ColStats = hoodieBackedTableMetadata.getColumnStats(Collections.singletonList(Pair.of((Object)partitionPath, (Object)fileName)), FIELD_1);
        Assertions.assertEquals((int)1, (int)field1ColStats.size());
        HoodieMetadataColumnStats column1stats = (HoodieMetadataColumnStats)field1ColStats.get(Pair.of((Object)partitionPath, (Object)fileName));
        Assertions.assertEquals((Object)FIELD_1, (Object)column1stats.getColumnName());
        Assertions.assertEquals((Object)fileName, (Object)column1stats.getFileName());
        Assertions.assertEquals((Object)new IntWrapper(Integer.valueOf(1)), (Object)column1stats.getMinValue());
        Assertions.assertEquals((Object)new IntWrapper(Integer.valueOf(2)), (Object)column1stats.getMaxValue());
        Assertions.assertEquals((long)2L, (Long)column1stats.getValueCount());
        Assertions.assertEquals((long)0L, (Long)column1stats.getNullCount());
        Assertions.assertEquals((long)5L, (Long)column1stats.getTotalSize());
        Assertions.assertEquals((long)10L, (Long)column1stats.getTotalUncompressedSize());
        Map field2ColStats = hoodieBackedTableMetadata.getColumnStats(Collections.singletonList(Pair.of((Object)partitionPath, (Object)fileName)), FIELD_2);
        Assertions.assertEquals((int)1, (int)field2ColStats.size());
        HoodieMetadataColumnStats column2stats = (HoodieMetadataColumnStats)field2ColStats.get(Pair.of((Object)partitionPath, (Object)fileName));
        Assertions.assertEquals((Object)FIELD_2, (Object)column2stats.getColumnName());
        Assertions.assertEquals((Object)fileName, (Object)column2stats.getFileName());
        Assertions.assertEquals((Object)new StringWrapper("a"), (Object)column2stats.getMinValue());
        Assertions.assertEquals((Object)new StringWrapper("b"), (Object)column2stats.getMaxValue());
        Assertions.assertEquals((long)3L, (Long)column2stats.getValueCount());
        Assertions.assertEquals((long)1L, (Long)column2stats.getNullCount());
        Assertions.assertEquals((long)10L, (Long)column2stats.getTotalSize());
        Assertions.assertEquals((long)20L, (Long)column2stats.getTotalUncompressedSize());
    }

    private JavaRDD<WriteStatus> createRdd(List<WriteStatus> writeStatuses) {
        return this.jsc.parallelize(writeStatuses, 1);
    }

    private WriteStatus createWriteStatus(String commitTime, String partitionPath, String filePath, String fileId) {
        WriteStatus writeStatus = new WriteStatus();
        writeStatus.setFileId(fileId);
        writeStatus.setPartitionPath(partitionPath);
        HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
        writeStat.setFileId(fileId);
        writeStat.setPath(ExternalFilePathUtil.appendCommitTimeAndExternalFileMarker((String)filePath, (String)commitTime));
        writeStat.setPartitionPath(partitionPath);
        writeStat.setNumWrites(3L);
        writeStat.setNumDeletes(0L);
        writeStat.setNumUpdateWrites(0L);
        writeStat.setNumInserts(3L);
        writeStat.setTotalWriteBytes(400L);
        writeStat.setTotalWriteErrors(0L);
        writeStat.setFileSizeInBytes(400L);
        writeStat.setTotalLogBlocks(0L);
        writeStat.setTotalLogRecords(0L);
        writeStat.setTotalLogFilesCompacted(0L);
        writeStat.setTotalLogSizeCompacted(0L);
        writeStat.setTotalUpdatedRecordsCompacted(0L);
        writeStat.setTotalCorruptLogBlock(0L);
        writeStat.setTotalRollbackBlocks(0L);
        HashMap<String, HoodieColumnRangeMetadata> stats = new HashMap<String, HoodieColumnRangeMetadata>();
        stats.put(FIELD_1, HoodieColumnRangeMetadata.create((String)filePath, (String)FIELD_1, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (long)0L, (long)2L, (long)5L, (long)10L));
        stats.put(FIELD_2, HoodieColumnRangeMetadata.create((String)filePath, (String)FIELD_2, (Comparable)((Object)"a"), (Comparable)((Object)"b"), (long)1L, (long)3L, (long)10L, (long)20L));
        writeStat.putRecordsStats(stats);
        writeStatus.setStat((HoodieWriteStat)writeStat);
        return writeStatus;
    }

    private HoodieCleanStat createCleanStat(String partitionPath, List<String> deletePaths, String earliestCommitToRetain, String lastCompletedCommitTimestamp) {
        return new HoodieCleanStat(HoodieCleaningPolicy.KEEP_LATEST_COMMITS, partitionPath, deletePaths, deletePaths, Collections.emptyList(), earliestCommitToRetain, lastCompletedCommitTimestamp);
    }

    private HoodieCleanerPlan cleanerPlan(HoodieActionInstant earliestInstantToRetain, String latestCommit, Map<String, List<HoodieCleanFileInfo>> filePathsToBeDeletedPerPartition) {
        return new HoodieCleanerPlan(earliestInstantToRetain, latestCommit, this.writeConfig.getCleanerPolicy().name(), Collections.emptyMap(), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, filePathsToBeDeletedPerPartition, Collections.emptyList(), Collections.EMPTY_MAP);
    }

    @FunctionalInterface
    private static interface FileIdAndNameGenerator {
        public Pair<String, String> generate(int var1, String var2);
    }
}

