/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.functional;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieLayoutConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.keygen.RawTripTestPayloadKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.SparkBucketIndexPartitioner;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.hudi.testutils.MetadataMergeWriteStatus;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Tuple2;

@Tag(value="functional")
public class TestHoodieIndex
extends TestHoodieMetadataBase {
    private HoodieIndex index;
    private HoodieWriteConfig config;

    private static Stream<Arguments> indexTypeParams() {
        Object[][] data = new Object[][]{{HoodieIndex.IndexType.BLOOM, true, true}, {HoodieIndex.IndexType.BLOOM, true, false}, {HoodieIndex.IndexType.GLOBAL_BLOOM, true, true}, {HoodieIndex.IndexType.GLOBAL_BLOOM, true, false}, {HoodieIndex.IndexType.SIMPLE, true, true}, {HoodieIndex.IndexType.SIMPLE, true, false}, {HoodieIndex.IndexType.GLOBAL_SIMPLE, true, true}, {HoodieIndex.IndexType.GLOBAL_SIMPLE, true, false}, {HoodieIndex.IndexType.BUCKET, true, false}, {HoodieIndex.IndexType.BUCKET, false, false}, {HoodieIndex.IndexType.RECORD_INDEX, true, true}};
        return Stream.of(data).map(Arguments::of);
    }

    private void setUp(HoodieIndex.IndexType indexType, boolean populateMetaFields, boolean enableMetadataIndex) throws Exception {
        this.setUp(indexType, populateMetaFields, enableMetadataIndex, true);
    }

    private void setUp(HoodieIndex.IndexType indexType, boolean populateMetaFields, boolean enableMetadataIndex, boolean rollbackUsingMarkers) throws Exception {
        this.initPath();
        this.initSparkContexts();
        this.initHoodieStorage();
        Properties keyGenProps = this.getPropsForKeyGen(indexType, populateMetaFields);
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)this.storageConf, (String)this.basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)keyGenProps);
        HoodieIndexConfig.Builder indexBuilder = HoodieIndexConfig.newBuilder().withIndexType(indexType).fromProperties(keyGenProps).withIndexType(indexType);
        HoodieMetadataConfig.Builder metadataConfigBuilder = HoodieMetadataConfig.newBuilder().withMetadataIndexBloomFilter(enableMetadataIndex).withMetadataIndexColumnStats(enableMetadataIndex);
        if (indexType == HoodieIndex.IndexType.RECORD_INDEX) {
            metadataConfigBuilder.withEnableRecordIndex(true);
        }
        this.config = this.getConfigBuilder().withProperties(keyGenProps).withSchema("{\"type\":\"record\",\"name\":\"triprec\",\"fields\":[{\"name\":\"number\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"time\",\"type\":\"string\"}]}").withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadClass(RawTripTestPayload.class.getName()).withPayloadOrderingField("number").build()).withRollbackUsingMarkers(rollbackUsingMarkers).withIndexConfig(indexBuilder.build()).withAutoCommit(false).withMetadataConfig(metadataConfigBuilder.build()).withLayoutConfig(HoodieLayoutConfig.newBuilder().fromProperties((Properties)indexBuilder.build().getProps()).withLayoutPartitioner(SparkBucketIndexPartitioner.class.getName()).build()).build();
        this.writeClient = this.getHoodieWriteClient(this.config);
        this.index = this.writeClient.getIndex();
    }

    private Properties getPropsForKeyGen(HoodieIndex.IndexType indexType, boolean populateMetaFields) {
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.POPULATE_META_FIELDS.key(), String.valueOf(populateMetaFields));
        if (indexType == HoodieIndex.IndexType.BUCKET) {
            properties.put("hoodie.datasource.write.recordkey.field", "_row_key");
            properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
        }
        if (!populateMetaFields) {
            properties.put("hoodie.datasource.write.recordkey.field", "_row_key");
            properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
            properties.put("hoodie.datasource.write.keygenerator.class", RawTripTestPayloadKeyGenerator.class.getName());
            properties.put("hoodie.datasource.write.partitionpath.field", "time");
            properties.put("hoodie.datasource.write.precombine.field", "number");
            properties.put(HoodieTableConfig.PARTITION_FIELDS.key(), "time");
            properties.put(HoodieTableConfig.PRECOMBINE_FIELD.key(), "number");
        }
        return properties;
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupResources();
    }

    private static List<HoodieRecord> getInserts() throws IOException {
        String recordStr1 = "{\"_row_key\":\"001\",\"time\":\"2016-01-31T00:00:01.000Z\",\"number\":1}";
        String recordStr2 = "{\"_row_key\":\"002\",\"time\":\"2016-01-31T00:00:02.000Z\",\"number\":2}";
        String recordStr3 = "{\"_row_key\":\"003\",\"time\":\"2016-01-31T00:00:03.000Z\",\"number\":3}";
        String recordStr4 = "{\"_row_key\":\"004\",\"time\":\"2017-01-31T00:00:04.000Z\",\"number\":4}";
        return Arrays.asList(new RawTripTestPayload(recordStr1).toHoodieRecord(), new RawTripTestPayload(recordStr2).toHoodieRecord(), new RawTripTestPayload(recordStr3).toHoodieRecord(), new RawTripTestPayload(recordStr4).toHoodieRecord());
    }

    private static List<HoodieRecord> getInsertsBatch2() throws IOException {
        String recordStr1 = "{\"_row_key\":\"005\",\"time\":\"2016-01-31T00:00:01.000Z\",\"number\":5}";
        String recordStr2 = "{\"_row_key\":\"006\",\"time\":\"2016-01-31T00:00:02.000Z\",\"number\":6}";
        String recordStr3 = "{\"_row_key\":\"007\",\"time\":\"2016-01-31T00:00:03.000Z\",\"number\":7}";
        String recordStr4 = "{\"_row_key\":\"008\",\"time\":\"2017-01-31T00:00:04.000Z\",\"number\":8}";
        return Arrays.asList(new RawTripTestPayload(recordStr1).toHoodieRecord(), new RawTripTestPayload(recordStr2).toHoodieRecord(), new RawTripTestPayload(recordStr3).toHoodieRecord(), new RawTripTestPayload(recordStr4).toHoodieRecord());
    }

    private static List<HoodieRecord> getUpdates() throws IOException {
        String recordStr1 = "{\"_row_key\":\"001\",\"time\":\"2016-01-31T00:00:01.000Z\",\"number\":5}";
        String recordStr2 = "{\"_row_key\":\"002\",\"time\":\"2016-01-31T00:00:02.000Z\",\"number\":6}";
        String recordStr3 = "{\"_row_key\":\"003\",\"time\":\"2016-01-31T00:00:03.000Z\",\"number\":7}";
        String recordStr4 = "{\"_row_key\":\"004\",\"time\":\"2017-01-31T00:00:04.000Z\",\"number\":8}";
        return new ArrayList<HoodieRecord>(Arrays.asList(new RawTripTestPayload(recordStr1).toHoodieRecord(), new RawTripTestPayload(recordStr2).toHoodieRecord(), new RawTripTestPayload(recordStr3).toHoodieRecord(), new RawTripTestPayload(recordStr4).toHoodieRecord()));
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypeParams"})
    public void testSimpleTagLocationAndUpdateWithRollback(HoodieIndex.IndexType indexType, boolean populateMetaFields, boolean enableMetadataIndex) throws Exception {
        this.setUp(indexType, populateMetaFields, enableMetadataIndex);
        int totalRecords = 4;
        List<HoodieRecord> records = TestHoodieIndex.getInserts();
        JavaRDD writtenRecords = this.jsc.parallelize(records, 1);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        JavaRDD<HoodieRecord> javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writtenRecords, (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().isEmpty());
        String newCommitTime = this.writeClient.createNewInstantTime();
        this.writeClient.startCommitWithTime(newCommitTime);
        JavaRDD writeStatusRdd = this.writeClient.upsert(writtenRecords, newCommitTime);
        List writeStatuses = writeStatusRdd.collect();
        Assertions.assertNoWriteErrors((List)writeStatuses);
        Object[] fileIdsFromWriteStatuses = (String[])writeStatuses.stream().map(WriteStatus::getFileId).sorted().toArray(String[]::new);
        javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writtenRecords, (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().isEmpty());
        this.writeClient.commit(newCommitTime, (Object)writeStatusRdd);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writtenRecords, (HoodieTable)hoodieTable);
        HashMap recordKeyToPartitionPathMap = new HashMap();
        List hoodieRecords = writtenRecords.collect();
        hoodieRecords.forEach(entry -> recordKeyToPartitionPathMap.put(entry.getRecordKey(), entry.getPartitionPath()));
        Object[] taggedFileIds = (String[])javaRDD.map((Function & Serializable)record -> record.getCurrentLocation().getFileId()).distinct().collect().stream().sorted().toArray(String[]::new);
        org.junit.jupiter.api.Assertions.assertArrayEquals((Object[])taggedFileIds, (Object[])fileIdsFromWriteStatuses);
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.filter((Function & Serializable)record -> record.getCurrentLocation() != null && record.getCurrentLocation().getInstantTime().equals(newCommitTime)).distinct().count());
        javaRDD.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(entry.getRecordKey()), (Object)entry.getPartitionPath(), (String)"PartitionPath mismatch"));
        JavaRDD keysRdd = writtenRecords.map((Function & Serializable)entry -> entry.getKey());
        JavaPairRDD<HoodieKey, Option<Pair<String, String>>> recordLocations = this.getRecordLocations((JavaRDD<HoodieKey>)keysRdd, (HoodieTable)hoodieTable);
        List keys = keysRdd.collect();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)recordLocations.collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)recordLocations.map((Function & Serializable)record -> (HoodieKey)record._1).distinct().count());
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)keys.contains(entry._1), (String)"Missing HoodieKey"));
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(((HoodieKey)entry._1).getRecordKey()), (Object)((HoodieKey)entry._1).getPartitionPath(), (String)"PartitionPath mismatch"));
        this.writeClient.rollback(newCommitTime);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writtenRecords, (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter(HoodieRecord::isCurrentLocationKnown).collect().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter((Function & Serializable)record -> record.getCurrentLocation() != null).collect().isEmpty());
    }

    @Test
    public void testLookupIndexWithAndWithoutColumnStats() throws Exception {
        this.setUp(HoodieIndex.IndexType.BLOOM, true, true);
        String newCommitTime = "001";
        int totalRecords = 4;
        List<HoodieRecord> records = TestHoodieIndex.getInserts();
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        JavaRDD<HoodieRecord> javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().isEmpty());
        this.writeClient.startCommitWithTime(newCommitTime);
        JavaRDD writeStatues = this.writeClient.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)writeStatues.collect());
        javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().isEmpty());
        this.writeClient.commit(newCommitTime, (Object)writeStatues);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieTableMetadataUtil.metadataPartitionExists((StoragePath)this.metaClient.getBasePath(), (HoodieEngineContext)this.context, (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.metaClient.getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath()));
        HoodieTableMetadataUtil.deleteMetadataPartition((StoragePath)this.metaClient.getBasePath(), (HoodieEngineContext)this.context, (String)MetadataPartitionType.COLUMN_STATS.getPartitionPath());
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        HashMap recordKeyToPartitionPathMap = new HashMap();
        List hoodieRecords = writeRecords.collect();
        hoodieRecords.forEach(entry -> recordKeyToPartitionPathMap.put(entry.getRecordKey(), entry.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)javaRDD.filter((Function & Serializable)record -> record.isCurrentLocationKnown()).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.filter((Function & Serializable)record -> record.getCurrentLocation() != null && record.getCurrentLocation().getInstantTime().equals(newCommitTime)).distinct().count());
        javaRDD.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(entry.getRecordKey()), (Object)entry.getPartitionPath(), (String)"PartitionPath mismatch"));
        JavaRDD hoodieKeyJavaRDD = writeRecords.map((Function & Serializable)entry -> entry.getKey());
        JavaPairRDD<HoodieKey, Option<Pair<String, String>>> recordLocations = this.getRecordLocations((JavaRDD<HoodieKey>)hoodieKeyJavaRDD, (HoodieTable)hoodieTable);
        List hoodieKeys = hoodieKeyJavaRDD.collect();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)recordLocations.collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)recordLocations.map((Function & Serializable)record -> (HoodieKey)record._1).distinct().count());
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)hoodieKeys.contains(entry._1), (String)"Missing HoodieKey"));
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(((HoodieKey)entry._1).getRecordKey()), (Object)((HoodieKey)entry._1).getPartitionPath(), (String)"PartitionPath mismatch"));
    }

    @ParameterizedTest
    @MethodSource(value={"indexTypeParams"})
    public void testTagLocationAndDuplicateUpdate(HoodieIndex.IndexType indexType, boolean populateMetaFields, boolean enableMetadataIndex) throws Exception {
        this.setUp(indexType, populateMetaFields, enableMetadataIndex);
        int totalRecords = 4;
        List<HoodieRecord> records = TestHoodieIndex.getInserts();
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        String newCommitTime = this.writeClient.createNewInstantTime();
        this.writeClient.startCommitWithTime(newCommitTime);
        JavaRDD writeStatues = this.writeClient.upsert(writeRecords, newCommitTime);
        JavaRDD<HoodieRecord> javaRDD1 = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        this.metaClient.getStorage().deleteDirectory(new StoragePath(this.metaClient.getTimelinePath(), newCommitTime + ".inflight"));
        this.writeClient.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)writeStatues.collect());
        this.writeClient.commit(newCommitTime, (Object)writeStatues);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        JavaRDD<HoodieRecord> javaRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        HashMap recordKeyToPartitionPathMap = new HashMap();
        List hoodieRecords = writeRecords.collect();
        hoodieRecords.forEach(entry -> recordKeyToPartitionPathMap.put(entry.getRecordKey(), entry.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)javaRDD.filter(HoodieRecord::isCurrentLocationKnown).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)javaRDD.filter((Function & Serializable)record -> record.getCurrentLocation() != null && record.getCurrentLocation().getInstantTime().equals(newCommitTime)).distinct().count());
        javaRDD.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(entry.getRecordKey()), (Object)entry.getPartitionPath(), (String)"PartitionPath mismatch"));
        JavaRDD hoodieKeyJavaRDD = writeRecords.map((Function & Serializable)entry -> entry.getKey());
        JavaPairRDD<HoodieKey, Option<Pair<String, String>>> recordLocations = this.getRecordLocations((JavaRDD<HoodieKey>)hoodieKeyJavaRDD, (HoodieTable)hoodieTable);
        List hoodieKeys = hoodieKeyJavaRDD.collect();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)recordLocations.collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)recordLocations.map((Function & Serializable)record -> (HoodieKey)record._1).distinct().count());
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)hoodieKeys.contains(entry._1), (String)"Missing HoodieKey"));
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(((HoodieKey)entry._1).getRecordKey()), (Object)((HoodieKey)entry._1).getPartitionPath(), (String)"PartitionPath mismatch"));
    }

    private static Stream<Arguments> regularIndexTypeParams() {
        Object[][] data = new Object[][]{{HoodieIndex.IndexType.BLOOM, true, false}, {HoodieIndex.IndexType.SIMPLE, true, true}, {HoodieIndex.IndexType.SIMPLE, true, false}};
        return Stream.of(data).map(Arguments::of);
    }

    @Disabled(value="HUDI-7353")
    @ParameterizedTest
    @MethodSource(value={"regularIndexTypeParams"})
    public void testTagLocationAndFetchRecordLocations(HoodieIndex.IndexType indexType, boolean populateMetaFields, boolean enableMetadataIndex) throws Exception {
        this.setUp(indexType, populateMetaFields, enableMetadataIndex);
        String p1 = "2016/01/31";
        String p2 = "2015/01/31";
        String rowKey1 = UUID.randomUUID().toString();
        String rowKey2 = UUID.randomUUID().toString();
        String rowKey3 = UUID.randomUUID().toString();
        String recordStr1 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}";
        String recordStr2 = "{\"_row_key\":\"" + rowKey2 + "\",\"time\":\"2016-01-31T03:20:41.415Z\",\"number\":100}";
        String recordStr3 = "{\"_row_key\":\"" + rowKey3 + "\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":15}";
        String recordStr4 = "{\"_row_key\":\"" + rowKey1 + "\",\"time\":\"2015-01-31T03:16:41.415Z\",\"number\":32}";
        HoodieRecord record1 = new RawTripTestPayload(recordStr1).toHoodieRecord();
        HoodieRecord record2 = new RawTripTestPayload(recordStr2).toHoodieRecord();
        HoodieRecord record3 = new RawTripTestPayload(recordStr3).toHoodieRecord();
        HoodieRecord record4 = new RawTripTestPayload(recordStr4).toHoodieRecord();
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2, record3, record4));
        String newCommitTime = this.writeClient.startCommit();
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        this.writeClient.upsert(recordRDD, newCommitTime);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        for (HoodieRecord record : taggedRecordRDD.collect()) {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, HoodieAvroUtils.addMetadataFields((Schema)RawTripTestPayload.JSON_DATA_SCHEMA), this.metadataWriter);
        String fileId1 = "fileID1";
        String fileId2 = "fileID2";
        String fileId3 = "fileID3";
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        StoragePath baseFilePath = testTable.forCommit("0000001").withInserts(p1, "fileID1", Collections.singletonList(record1));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(p1, k -> new ArrayList()).add(Pair.of((Object)"fileID1", (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000001", WriteOperationType.UPSERT, Arrays.asList(p1, p2), partitionToFilesNameLengthMap, false, false);
        partitionToFilesNameLengthMap.clear();
        baseFilePath = testTable.forCommit("0000002").withInserts(p1, "fileID2", Collections.singletonList(record2));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(p1, k -> new ArrayList()).add(Pair.of((Object)"fileID2", (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000002", WriteOperationType.UPSERT, Arrays.asList(p1, p2), partitionToFilesNameLengthMap, false, false);
        partitionToFilesNameLengthMap.clear();
        baseFilePath = testTable.forCommit("0000003").withInserts(p2, "fileID3", Collections.singletonList(record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent(p2, k -> new ArrayList()).add(Pair.of((Object)"fileID3", (Object)((int)baseFileLength)));
        testTable.doWriteOperation("0000003", WriteOperationType.UPSERT, Arrays.asList(p1, p2), partitionToFilesNameLengthMap, false, false);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        taggedRecordRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        List records = taggedRecordRDD.collect();
        for (HoodieRecord record : records) {
            if (record.getRecordKey().equals(rowKey1)) {
                if (record.getPartitionPath().equals(p2)) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)"fileID3");
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)"fileID1");
                continue;
            }
            if (record.getRecordKey().equals(rowKey2)) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)"fileID2");
                continue;
            }
            if (!record.getRecordKey().equals(rowKey3)) continue;
            org.junit.jupiter.api.Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
        }
        JavaPairRDD<HoodieKey, Option<Pair<String, String>>> recordLocations = this.getRecordLocations((JavaRDD<HoodieKey>)recordRDD.map(HoodieRecord::getKey), (HoodieTable)hoodieTable);
        for (Tuple2 entry : recordLocations.collect()) {
            if (((HoodieKey)entry._1).getRecordKey().equals(rowKey1)) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((Option)entry._2).isPresent(), (String)"Row1 should have been present ");
                if (((HoodieKey)entry._1).getPartitionPath().equals(p2)) {
                    org.junit.jupiter.api.Assertions.assertTrue((boolean)((Option)entry._2).isPresent(), (String)"Row1 should have been present ");
                    org.junit.jupiter.api.Assertions.assertEquals((Object)((Pair)((Option)entry._2).get()).getRight(), (Object)"fileID3");
                    continue;
                }
                org.junit.jupiter.api.Assertions.assertEquals((Object)((Pair)((Option)entry._2).get()).getRight(), (Object)"fileID1");
                continue;
            }
            if (((HoodieKey)entry._1).getRecordKey().equals(rowKey2)) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)((Option)entry._2).isPresent(), (String)"Row2 should have been present ");
                org.junit.jupiter.api.Assertions.assertEquals((Object)((Pair)((Option)entry._2).get()).getRight(), (Object)"fileID2");
                continue;
            }
            if (!((HoodieKey)entry._1).getRecordKey().equals(rowKey3)) continue;
            org.junit.jupiter.api.Assertions.assertFalse((boolean)((Option)entry._2).isPresent(), (String)"Row3 should have been absent ");
        }
    }

    @Test
    public void testCheckIfValidCommit() throws Exception {
        this.setUp(HoodieIndex.IndexType.BLOOM, true, false);
        HoodieTimeline timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Collections.EMPTY_LIST.stream(), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)"001"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)this.writeClient.createNewInstantTime()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)"00000000000000"));
        HoodieInstant instant1 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", "010");
        String instantTimestamp = this.writeClient.createNewInstantTime();
        HoodieInstant instant2 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", this.writeClient.createNewInstantTime());
        timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Stream.of(instant1, instant2), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instant1.requestedTime()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instant2.requestedTime()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestamp));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)this.writeClient.createNewInstantTime()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)"001"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)"00000000000000"));
        instantTimestamp = this.writeClient.createNewInstantTime();
        String instantTimestampSec = instantTimestamp.substring(0, instantTimestamp.length() - "999".length());
        HoodieInstant instant3 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTimestampSec);
        timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Stream.of(instant1, instant3), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestampSec));
        instantTimestamp = this.writeClient.createNewInstantTime();
        HoodieInstant instant4 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTimestamp);
        timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Stream.of(instant4), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        instantTimestampSec = instantTimestamp.substring(0, instantTimestamp.length() - "999".length());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestampSec));
        Thread.sleep(2000L);
        instantTimestamp = this.writeClient.createNewInstantTime();
        instantTimestampSec = instantTimestamp.substring(0, instantTimestamp.length() - "999".length());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestamp));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)HoodieIndexUtils.checkIfValidCommit((HoodieTimeline)timeline, (String)instantTimestampSec));
        String checkInstantTimestampSec = instantTimestamp.substring(0, instantTimestamp.length() - "999".length());
        String checkInstantTimestamp = checkInstantTimestampSec + "999";
        Thread.sleep(2000L);
        String newTimestamp = this.writeClient.createNewInstantTime();
        String newTimestampSec = newTimestamp.substring(0, newTimestamp.length() - "999".length());
        HoodieInstant instant5 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", newTimestamp);
        timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Stream.of(instant5), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(checkInstantTimestamp));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(checkInstantTimestampSec));
        HoodieInstant instant6 = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", newTimestampSec + "999");
        timeline = HoodieTestUtils.TIMELINE_FACTORY.createDefaultTimeline(Stream.of(instant6), (HoodieInstantReader)this.metaClient.getActiveTimeline());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.empty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(newTimestamp));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)timeline.containsInstant(checkInstantTimestamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)timeline.containsInstant(instant6.requestedTime()));
    }

    @Test
    public void testDelete() throws Exception {
        this.setUp(HoodieIndex.IndexType.INMEMORY, true, false);
        String newCommitTime = this.writeClient.createNewInstantTime();
        List<HoodieRecord> records = TestHoodieIndex.getInserts();
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        this.writeClient.startCommitWithTime(newCommitTime);
        JavaRDD writeStatues = this.writeClient.upsert(writeRecords, newCommitTime);
        Assertions.assertNoWriteErrors((List)writeStatues.collect());
        this.writeClient.commit(newCommitTime, (Object)writeStatues);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        JavaRDD<HoodieRecord> javaRDD = this.tagLocation(hoodieTable.getIndex(), (JavaRDD<HoodieRecord>)writeRecords, (HoodieTable)hoodieTable);
        HashMap recordKeyToPartitionPathMap = new HashMap();
        List hoodieRecords = writeRecords.collect();
        hoodieRecords.forEach(entry -> recordKeyToPartitionPathMap.put(entry.getRecordKey(), entry.getPartitionPath()));
        org.junit.jupiter.api.Assertions.assertEquals((int)records.size(), (int)javaRDD.filter(HoodieRecord::isCurrentLocationKnown).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)records.size(), (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
        org.junit.jupiter.api.Assertions.assertEquals((long)records.size(), (long)javaRDD.filter((Function & Serializable)record -> record.getCurrentLocation() != null && record.getCurrentLocation().getInstantTime().equals(newCommitTime)).distinct().count());
        javaRDD.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(entry.getRecordKey()), (Object)entry.getPartitionPath(), (String)"PartitionPath mismatch"));
        JavaRDD hoodieKeyJavaRDD = writeRecords.map(HoodieRecord::getKey);
        JavaPairRDD<HoodieKey, Option<Pair<String, String>>> recordLocations = this.getRecordLocations((JavaRDD<HoodieKey>)hoodieKeyJavaRDD, (HoodieTable)hoodieTable);
        List hoodieKeys = hoodieKeyJavaRDD.collect();
        org.junit.jupiter.api.Assertions.assertEquals((int)records.size(), (int)recordLocations.collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)records.size(), (long)recordLocations.map((Function & Serializable)record -> (HoodieKey)record._1).distinct().count());
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertTrue((boolean)hoodieKeys.contains(entry._1), (String)"Missing HoodieKey"));
        recordLocations.foreach((VoidFunction & Serializable)entry -> org.junit.jupiter.api.Assertions.assertEquals(recordKeyToPartitionPathMap.get(((HoodieKey)entry._1).getRecordKey()), (Object)((HoodieKey)entry._1).getPartitionPath(), (String)"PartitionPath mismatch"));
        int numDeletes = records.size() / 2;
        List keysToDelete = records.stream().limit(numDeletes).map(r -> new HoodieKey(r.getRecordKey(), r.getPartitionPath())).collect(Collectors.toList());
        String deleteCommitTime = this.writeClient.createNewInstantTime();
        this.writeClient.startCommitWithTime(deleteCommitTime);
        writeStatues = this.writeClient.delete(this.jsc.parallelize(keysToDelete, 1), deleteCommitTime);
        Assertions.assertNoWriteErrors((List)writeStatues.collect());
        this.writeClient.commit(deleteCommitTime, (Object)writeStatues);
        this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)this.config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        javaRDD = this.tagLocation(hoodieTable.getIndex(), (JavaRDD<HoodieRecord>)this.jsc.parallelize(records.subList(0, numDeletes)), (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)javaRDD.filter(HoodieRecord::isCurrentLocationKnown).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)numDeletes, (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
        javaRDD = this.tagLocation(hoodieTable.getIndex(), (JavaRDD<HoodieRecord>)this.jsc.parallelize(records.subList(numDeletes, records.size())), (HoodieTable)hoodieTable);
        org.junit.jupiter.api.Assertions.assertEquals((int)(records.size() - numDeletes), (int)javaRDD.filter(HoodieRecord::isCurrentLocationKnown).collect().size());
        org.junit.jupiter.api.Assertions.assertEquals((long)(records.size() - numDeletes), (long)javaRDD.map((Function & Serializable)record -> record.getKey().getRecordKey()).distinct().count());
    }

    public HoodieWriteConfig.Builder getConfigBuilder() {
        return HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withParallelism(2, 2).withBulkInsertParallelism(2).withFinalizeWriteParallelism(2).withDeleteParallelism(2).withWriteStatusClass(MetadataMergeWriteStatus.class).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(true).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionSmallFileSize(0x100000L).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x100000L).parquetMaxFileSize(0x100000L).build()).forTable("test-trip-table").withEmbeddedTimelineServerEnabled(true);
    }

    private JavaPairRDD<HoodieKey, Option<Pair<String, String>>> getRecordLocations(JavaRDD<HoodieKey> keyRDD, HoodieTable hoodieTable) {
        JavaRDD<HoodieRecord> recordRDD = this.tagLocation(this.index, (JavaRDD<HoodieRecord>)keyRDD.map((Function & Serializable)k -> new HoodieAvroRecord(k, (HoodieRecordPayload)new EmptyHoodieRecordPayload())), hoodieTable);
        return recordRDD.mapToPair((PairFunction & Serializable)hr -> new Tuple2((Object)hr.getKey(), (Object)(hr.isCurrentLocationKnown() ? Option.of((Object)Pair.of((Object)hr.getPartitionPath(), (Object)hr.getCurrentLocation().getFileId())) : Option.empty())));
    }
}

