/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.functional.TestHoodieMetadataBase;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieSparkWriteableTestTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFunction;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Tuple2;

public class TestHoodieGlobalBloomIndex
extends TestHoodieMetadataBase {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestHoodieGlobalBloomIndex.class, (String)"/exampleSchema.avsc", (boolean)true);

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initHoodieStorage();
        this.initMetaClient();
        HoodieIndexConfig.Builder indexBuilder = HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.GLOBAL_BLOOM);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(indexBuilder.build()).build();
        this.writeClient = this.getHoodieWriteClient(config);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.cleanupResources();
    }

    @Test
    public void testLoadInvolvedFiles() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieGlobalBloomIndex index = new HoodieGlobalBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter);
        String p1 = "2016/01/21";
        String p2 = "2016/04/01";
        String p3 = "2015/03/12";
        RawTripTestPayload rowChange1 = new RawTripTestPayload("{\"_row_key\":\"000\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload("{\"_row_key\":\"001\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload("{\"_row_key\":\"002\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload("{\"_row_key\":\"003\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        List<String> partitions = Arrays.asList("2016/01/21", "2016/04/01");
        List filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)0, (int)filesList.size());
        String fileId1 = "1";
        String fileId2 = "2";
        String fileId3 = "3";
        String fileId4 = "4";
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String c1 = "20160401010101";
        StoragePath baseFilePath = testTable.forCommit("20160401010101").withInserts("2016/04/01", "2", Collections.emptyList());
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/04/01", k -> new ArrayList()).add(Pair.of((Object)"2", (Object)((int)baseFileLength)));
        testTable.doWriteOperation("20160401010101", WriteOperationType.UPSERT, Collections.singletonList("2016/04/01"), partitionToFilesNameLengthMap, false, false);
        String c2 = "20150312101010";
        testTable.forCommit("20150312101010");
        baseFilePath = testTable.withInserts("2015/03/12", "1", Collections.emptyList());
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)"1", (Object)((int)baseFileLength)));
        baseFilePath = testTable.withInserts("2015/03/12", "3", Collections.singletonList(record1));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)"3", (Object)((int)baseFileLength)));
        baseFilePath = testTable.withInserts("2015/03/12", "4", Arrays.asList(record2, record3, record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)"4", (Object)((int)baseFileLength)));
        testTable.doWriteOperation("20150312101010", WriteOperationType.UPSERT, Collections.singletonList("2015/03/12"), partitionToFilesNameLengthMap, false, false);
        filesList = index.loadColumnRangesFromFiles(partitions, (HoodieEngineContext)this.context, (HoodieTable)hoodieTable);
        Assertions.assertEquals((int)4, (int)filesList.size());
        Map<String, BloomIndexFileInfo> filesMap = TestHoodieGlobalBloomIndex.toFileMap(filesList);
        Assertions.assertNull((Object)filesMap.get("2016/04/01/2").getMaxRecordKey());
        Assertions.assertNull((Object)filesMap.get("2016/04/01/2").getMinRecordKey());
        Assertions.assertFalse((boolean)filesMap.get("2015/03/12/1").hasKeyRanges());
        Assertions.assertNotNull((Object)filesMap.get("2015/03/12/3").getMaxRecordKey());
        Assertions.assertNotNull((Object)filesMap.get("2015/03/12/3").getMinRecordKey());
        Assertions.assertTrue((boolean)filesMap.get("2015/03/12/3").hasKeyRanges());
        HashMap<String, BloomIndexFileInfo> expected = new HashMap<String, BloomIndexFileInfo>();
        expected.put("2016/04/01/2", new BloomIndexFileInfo("2"));
        expected.put("2015/03/12/1", new BloomIndexFileInfo("1"));
        expected.put("2015/03/12/3", new BloomIndexFileInfo("3", "000", "000"));
        expected.put("2015/03/12/4", new BloomIndexFileInfo("4", "001", "003"));
        Assertions.assertEquals(expected, filesMap);
    }

    @Test
    public void testExplodeRecordRDDWithFileComparisons() {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieGlobalBloomIndex index = new HoodieGlobalBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        HashMap<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo = new HashMap<String, List<BloomIndexFileInfo>>();
        partitionToFileIndexInfo.put("2017/10/22", Arrays.asList(new BloomIndexFileInfo("f1"), new BloomIndexFileInfo("f2", "000", "000"), new BloomIndexFileInfo("f3", "001", "003")));
        partitionToFileIndexInfo.put("2017/10/23", Arrays.asList(new BloomIndexFileInfo("f4", "002", "007"), new BloomIndexFileInfo("f5", "009", "010")));
        JavaPairRDD partitionRecordKeyPairRDD = this.jsc.parallelize(Arrays.asList(new Tuple2((Object)"2017/10/21", (Object)"003"), new Tuple2((Object)"2017/10/22", (Object)"002"), new Tuple2((Object)"2017/10/22", (Object)"005"), new Tuple2((Object)"2017/10/23", (Object)"004"))).mapToPair((PairFunction & Serializable)t -> t);
        List comparisonKeyList = index.explodeRecordsWithFileComparisons(partitionToFileIndexInfo, (HoodiePairData)HoodieJavaPairRDD.of((JavaPairRDD)partitionRecordKeyPairRDD)).collectAsList();
        Assertions.assertEquals((int)10, (int)comparisonKeyList.size());
        Map recordKeyToFileComps = comparisonKeyList.stream().collect(Collectors.groupingBy(t -> (String)t.getRight(), Collectors.mapping(t -> ((HoodieFileGroupId)t.getLeft()).getFileId(), Collectors.toList())));
        Assertions.assertEquals((int)4, (int)recordKeyToFileComps.size());
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f4", "f1", "f3")), new HashSet(recordKeyToFileComps.get("002")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f4", "f1", "f3")), new HashSet(recordKeyToFileComps.get("003")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f4", "f1")), new HashSet(recordKeyToFileComps.get("004")));
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("f4", "f1")), new HashSet(recordKeyToFileComps.get("005")));
    }

    @Test
    public void testTagLocation() throws Exception {
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.GLOBAL_BLOOM).withGlobalBloomIndexUpdatePartitionPath(false).build()).build();
        HoodieGlobalBloomIndex index = new HoodieGlobalBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        HoodieSparkWriteableTestTable testTable = HoodieSparkWriteableTestTable.of(this.metaClient, SCHEMA, this.metadataWriter);
        String partition2 = "2016/04/01";
        String partition3 = "2015/03/12";
        RawTripTestPayload rowChange1 = new RawTripTestPayload("{\"_row_key\":\"000\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record1 = new HoodieAvroRecord(new HoodieKey(rowChange1.getRowKey(), rowChange1.getPartitionPath()), (HoodieRecordPayload)rowChange1);
        RawTripTestPayload rowChange2 = new RawTripTestPayload("{\"_row_key\":\"001\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record2 = new HoodieAvroRecord(new HoodieKey(rowChange2.getRowKey(), rowChange2.getPartitionPath()), (HoodieRecordPayload)rowChange2);
        RawTripTestPayload rowChange3 = new RawTripTestPayload("{\"_row_key\":\"002\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record3 = new HoodieAvroRecord(new HoodieKey(rowChange3.getRowKey(), rowChange3.getPartitionPath()), (HoodieRecordPayload)rowChange3);
        RawTripTestPayload rowChange4 = new RawTripTestPayload("{\"_row_key\":\"003\",\"time\":\"2016-01-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record4 = new HoodieAvroRecord(new HoodieKey(rowChange4.getRowKey(), rowChange4.getPartitionPath()), (HoodieRecordPayload)rowChange4);
        RawTripTestPayload rowChange5 = new RawTripTestPayload("{\"_row_key\":\"003\",\"time\":\"2016-02-31T03:16:41.415Z\",\"number\":12}");
        HoodieAvroRecord record5 = new HoodieAvroRecord(new HoodieKey(rowChange5.getRowKey(), rowChange5.getPartitionPath()), (HoodieRecordPayload)rowChange5);
        String fileId1 = UUID.randomUUID().toString();
        String fileId2 = UUID.randomUUID().toString();
        String fileId3 = UUID.randomUUID().toString();
        String fileId4 = UUID.randomUUID().toString();
        HashMap<String, List> partitionToFilesNameLengthMap = new HashMap<String, List>();
        String commitTime = "0000001";
        StoragePath baseFilePath = testTable.forCommit(commitTime).withInserts("2016/04/01", fileId1, Collections.singletonList(record1));
        long baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.computeIfAbsent("2016/04/01", k -> new ArrayList()).add(Pair.of((Object)fileId1, (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Collections.singletonList("2016/04/01"), partitionToFilesNameLengthMap, false, false);
        commitTime = "0000002";
        baseFilePath = testTable.forCommit(commitTime).withInserts("2015/03/12", fileId2, Collections.emptyList());
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)fileId2, (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Collections.singletonList("2015/03/12"), partitionToFilesNameLengthMap, false, false);
        commitTime = "0000003";
        baseFilePath = testTable.forCommit(commitTime).withInserts("2015/03/12", fileId3, Collections.singletonList(record2));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)fileId3, (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Collections.singletonList("2015/03/12"), partitionToFilesNameLengthMap, false, false);
        commitTime = "0000004";
        baseFilePath = testTable.forCommit(commitTime).withInserts("2015/03/12", fileId4, Collections.singletonList(record4));
        baseFileLength = this.storage.getPathInfo(baseFilePath).getLength();
        partitionToFilesNameLengthMap.clear();
        partitionToFilesNameLengthMap.computeIfAbsent("2015/03/12", k -> new ArrayList()).add(Pair.of((Object)fileId4, (Object)((int)baseFileLength)));
        testTable.doWriteOperation(commitTime, WriteOperationType.UPSERT, Collections.singletonList("2015/03/12"), partitionToFilesNameLengthMap, false, false);
        JavaRDD recordRDD = this.jsc.parallelize(Arrays.asList(record1, record2, record3, record5));
        JavaRDD<HoodieRecord> taggedRecordRDD = this.tagLocation((HoodieIndex)index, (JavaRDD<HoodieRecord>)recordRDD, (HoodieTable)hoodieTable);
        block14: for (HoodieRecord record : taggedRecordRDD.collect()) {
            switch (record.getRecordKey()) {
                case "000": {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId1);
                    Assertions.assertEquals((Object)((RawTripTestPayload)record.getData()).getJsonData(), (Object)rowChange1.getJsonData());
                    continue block14;
                }
                case "001": {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId3);
                    Assertions.assertEquals((Object)((RawTripTestPayload)record.getData()).getJsonData(), (Object)rowChange2.getJsonData());
                    continue block14;
                }
                case "002": {
                    Assertions.assertFalse((boolean)record.isCurrentLocationKnown());
                    Assertions.assertEquals((Object)((RawTripTestPayload)record.getData()).getJsonData(), (Object)rowChange3.getJsonData());
                    continue block14;
                }
                case "003": {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId4);
                    Assertions.assertEquals((Object)((RawTripTestPayload)record.getData()).getJsonData(), (Object)rowChange5.getJsonData());
                    continue block14;
                }
                case "004": {
                    Assertions.assertEquals((Object)record.getCurrentLocation().getFileId(), (Object)fileId4);
                    Assertions.assertEquals((Object)((RawTripTestPayload)record.getData()).getJsonData(), (Object)rowChange4.getJsonData());
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Unknown Key: " + record.getRecordKey());
        }
    }

    private static Map<String, BloomIndexFileInfo> toFileMap(List<Pair<String, BloomIndexFileInfo>> filesList) {
        HashMap<String, BloomIndexFileInfo> filesMap = new HashMap<String, BloomIndexFileInfo>();
        for (Pair<String, BloomIndexFileInfo> t : filesList) {
            filesMap.put((String)t.getKey() + "/" + ((BloomIndexFileInfo)t.getValue()).getFileId(), (BloomIndexFileInfo)t.getValue());
        }
        return filesMap;
    }
}

