/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.hadoop.HoodieAvroHFileWriter;
import org.apache.hudi.io.hadoop.HoodieAvroOrcWriter;
import org.apache.hudi.io.hadoop.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieAvroFileWriterFactory
extends HoodieClientTestBase {
    @Test
    public void testGetFileWriter() throws IOException {
        String instantTime = "100";
        StoragePath parquetPath = new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000.parquet");
        HoodieWriteConfig cfg = this.getConfig();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)cfg, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        SparkTaskContextSupplier supplier = new SparkTaskContextSupplier();
        HoodieFileWriter parquetWriter = HoodieFileWriterFactory.getFileWriter((String)"100", (StoragePath)parquetPath, (HoodieStorage)table.getStorage(), (HoodieConfig)cfg.getStorageConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA, (TaskContextSupplier)supplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        Assertions.assertTrue((boolean)(parquetWriter instanceof HoodieAvroParquetWriter));
        parquetWriter.close();
        StoragePath hfilePath = new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000.hfile");
        HoodieFileWriter hfileWriter = HoodieFileWriterFactory.getFileWriter((String)"100", (StoragePath)hfilePath, (HoodieStorage)table.getStorage(), (HoodieConfig)cfg.getStorageConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA, (TaskContextSupplier)supplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        Assertions.assertTrue((boolean)(hfileWriter instanceof HoodieAvroHFileWriter));
        hfileWriter.close();
        StoragePath orcPath = new StoragePath(this.basePath + "/partition/path/f1_1-0-1_000.orc");
        HoodieFileWriter orcFileWriter = HoodieFileWriterFactory.getFileWriter((String)"100", (StoragePath)orcPath, (HoodieStorage)table.getStorage(), (HoodieConfig)cfg.getStorageConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA, (TaskContextSupplier)supplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
        Assertions.assertTrue((boolean)(orcFileWriter instanceof HoodieAvroOrcWriter));
        orcFileWriter.close();
        StoragePath logPath = new StoragePath(this.basePath + "/partition/path/f.b51192a8-574b-4a85-b246-bcfec03ac8bf_100.log.2_1-0-1");
        Throwable thrown = Assertions.assertThrows(UnsupportedOperationException.class, () -> TestHoodieAvroFileWriterFactory.lambda$testGetFileWriter$0(logPath, (HoodieTable)table, cfg, supplier), (String)"should fail since log storage writer is not supported yet.");
        Assertions.assertTrue((boolean)thrown.getMessage().contains("format not supported yet."));
    }

    @Test
    public void testEnableBloomFilter() {
        HoodieWriteConfig config = this.getConfig(HoodieIndex.IndexType.BLOOM);
        Assertions.assertTrue((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
        Assertions.assertFalse((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)false, (HoodieConfig)config));
        config = this.getConfig(HoodieIndex.IndexType.SIMPLE);
        Assertions.assertTrue((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
        config = this.getConfig(HoodieIndex.IndexType.SIMPLE);
        Assertions.assertTrue((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
        config = this.getConfigBuilder(HoodieIndex.IndexType.BLOOM).withStorageConfig(HoodieStorageConfig.newBuilder().parquetBloomFilterEnable(false).build()).build();
        Assertions.assertTrue((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
        config = this.getConfigBuilder(HoodieIndex.IndexType.SIMPLE).withStorageConfig(HoodieStorageConfig.newBuilder().parquetBloomFilterEnable(true).build()).build();
        Assertions.assertTrue((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
        config = this.getConfigBuilder(HoodieIndex.IndexType.SIMPLE).withStorageConfig(HoodieStorageConfig.newBuilder().parquetBloomFilterEnable(false).build()).build();
        Assertions.assertFalse((boolean)HoodieFileWriterFactory.enableBloomFilter((boolean)true, (HoodieConfig)config));
    }

    private static /* synthetic */ void lambda$testGetFileWriter$0(StoragePath logPath, HoodieTable table, HoodieWriteConfig cfg, SparkTaskContextSupplier supplier) throws Throwable {
        HoodieFileWriterFactory.getFileWriter((String)"100", (StoragePath)logPath, (HoodieStorage)table.getStorage(), (HoodieConfig)cfg.getStorageConfig(), (Schema)HoodieTestDataGenerator.AVRO_SCHEMA, (TaskContextSupplier)supplier, (HoodieRecord.HoodieRecordType)HoodieRecord.HoodieRecordType.AVRO);
    }
}

