/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.clustering.plan.strategy.SparkSizeBasedClusteringPlanStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.cluster.ClusteringPlanPartitionFilterMode;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

public class TestSparkClusteringPlanPartitionFilter {
    @Mock
    HoodieSparkCopyOnWriteTable table;
    @Mock
    HoodieSparkEngineContext context;
    HoodieWriteConfig.Builder hoodieWriteConfigBuilder;

    @BeforeEach
    public void setUp() {
        this.hoodieWriteConfigBuilder = HoodieWriteConfig.newBuilder().withPath("Fake_Table_Path");
    }

    @Test
    public void testFilterPartitionNoFilter() {
        HoodieWriteConfig config = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.NONE).build()).build();
        SparkSizeBasedClusteringPlanStrategy sg = new SparkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, config);
        ArrayList<String> fakeTimeBasedPartitionsPath = new ArrayList<String>();
        fakeTimeBasedPartitionsPath.add("20210718");
        fakeTimeBasedPartitionsPath.add("20210716");
        fakeTimeBasedPartitionsPath.add("20210719");
        List list = (List)sg.filterPartitionPaths(null, fakeTimeBasedPartitionsPath).getLeft();
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testFilterPartitionRecentDays() {
        HoodieWriteConfig config = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringSkipPartitionsFromLatest(1).withClusteringTargetPartitions(1).withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.RECENT_DAYS).build()).build();
        SparkSizeBasedClusteringPlanStrategy sg = new SparkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, config);
        ArrayList<String> fakeTimeBasedPartitionsPath = new ArrayList<String>();
        fakeTimeBasedPartitionsPath.add("20210718");
        fakeTimeBasedPartitionsPath.add("20210716");
        fakeTimeBasedPartitionsPath.add("20210719");
        List list = (List)sg.filterPartitionPaths(null, fakeTimeBasedPartitionsPath).getLeft();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertSame((Object)"20210718", list.get(0));
    }

    @Test
    public void testFilterPartitionSelectedPartitions() {
        HoodieWriteConfig config = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPartitionFilterBeginPartition("20211222").withClusteringPartitionFilterEndPartition("20211223").withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.SELECTED_PARTITIONS).build()).build();
        SparkSizeBasedClusteringPlanStrategy sg = new SparkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, config);
        ArrayList<String> fakeTimeBasedPartitionsPath = new ArrayList<String>();
        fakeTimeBasedPartitionsPath.add("20211220");
        fakeTimeBasedPartitionsPath.add("20211221");
        fakeTimeBasedPartitionsPath.add("20211222");
        fakeTimeBasedPartitionsPath.add("20211224");
        List list = (List)sg.filterPartitionPaths(config, fakeTimeBasedPartitionsPath).getLeft();
        Assertions.assertEquals((int)1, (int)list.size());
        Assertions.assertSame((Object)"20211222", list.get(0));
    }

    @Test
    public void testDayRollingPartitionFilter() {
        HoodieWriteConfig config = this.hoodieWriteConfigBuilder.withClusteringConfig(HoodieClusteringConfig.newBuilder().withClusteringPlanPartitionFilterMode(ClusteringPlanPartitionFilterMode.DAY_ROLLING).build()).build();
        SparkSizeBasedClusteringPlanStrategy sg = new SparkSizeBasedClusteringPlanStrategy((HoodieTable)this.table, (HoodieEngineContext)this.context, config);
        ArrayList<String> fakeTimeBasedPartitionsPath = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            fakeTimeBasedPartitionsPath.add("20220301" + (i >= 10 ? String.valueOf(i) : "0" + i));
        }
        List filterPartitions = (List)sg.filterPartitionPaths(null, fakeTimeBasedPartitionsPath).getLeft();
        Assertions.assertEquals((int)1, (int)filterPartitions.size());
        Assertions.assertEquals(fakeTimeBasedPartitionsPath.get(DateTime.now().getHourOfDay()), filterPartitions.get(0));
        fakeTimeBasedPartitionsPath = new ArrayList();
        for (int i = 0; i < 24; ++i) {
            fakeTimeBasedPartitionsPath.add("20220301" + (i >= 10 ? String.valueOf(i) : "0" + i));
            fakeTimeBasedPartitionsPath.add("20220302" + (i >= 10 ? String.valueOf(i) : "0" + i));
        }
        filterPartitions = (List)sg.filterPartitionPaths(null, fakeTimeBasedPartitionsPath).getLeft();
        Assertions.assertEquals((int)2, (int)filterPartitions.size());
        int hourOfDay = DateTime.now().getHourOfDay();
        String suffix = hourOfDay >= 10 ? hourOfDay + "" : "0" + hourOfDay;
        Assertions.assertEquals((Object)("20220301" + suffix), filterPartitions.get(0));
        Assertions.assertEquals((Object)("20220302" + suffix), filterPartitions.get(1));
    }
}

