/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;
import org.apache.hudi.table.action.commit.HoodieWriteHelper;
import org.apache.hudi.table.action.commit.TestWriterHelperBase;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

public class TestSparkWriteHelper
extends TestWriterHelperBase<HoodieData<HoodieRecord>> {
    JavaSparkContext jsc;

    public TestSparkWriteHelper() {
        super((BaseWriteHelper)HoodieWriteHelper.newInstance());
    }

    @BeforeEach
    public void setup() throws Exception {
        super.setUp();
        this.jsc = new JavaSparkContext(HoodieClientTestUtils.getSparkConfForTest(TestSparkWriteHelper.class.getName()));
        this.context = new HoodieSparkEngineContext(this.jsc);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withEmbeddedTimelineServerEnabled(false).build();
        this.table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
    }

    public HoodieData<HoodieRecord> getInputRecords(List<HoodieRecord> recordList, int numPartitions) {
        HoodieData inputRecords = this.context.parallelize(recordList, numPartitions);
        Assertions.assertEquals((int)numPartitions, (int)inputRecords.getNumPartitions());
        return inputRecords;
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.jsc != null) {
            this.jsc.stop();
        }
        this.context = null;
    }

    @ParameterizedTest
    @CsvSource(value={"true,0", "true,50", "false,0", "false,50"})
    public void testCombineParallelism(boolean shouldCombine, int configuredShuffleParallelism) {
        int inputParallelism = 5;
        int expectDefaultParallelism = 4;
        this.inputRecords = this.getInputRecords((List<HoodieRecord>)this.dataGen.generateInserts("20230915000000000", Integer.valueOf(10)), inputParallelism);
        HoodieData outputRecords = (HoodieData)this.writeHelper.combineOnCondition(shouldCombine, this.inputRecords, configuredShuffleParallelism, this.table);
        if (shouldCombine) {
            if (configuredShuffleParallelism == 0) {
                Assertions.assertEquals((int)expectDefaultParallelism, (int)outputRecords.getNumPartitions());
            } else {
                Assertions.assertEquals((int)configuredShuffleParallelism, (int)outputRecords.getNumPartitions());
            }
        } else {
            Assertions.assertEquals((int)inputParallelism, (int)outputRecords.getNumPartitions());
        }
    }
}

