/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.functional;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanActionExecutor;
import org.apache.hudi.table.action.clean.CleanPlanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestCleanActionExecutor {
    private static final StorageConfiguration<?> CONF = HoodieTestUtils.getDefaultStorageConf();
    private final HoodieEngineContext context = new HoodieLocalEngineContext(CONF);
    private final HoodieTable<?, ?, ?, ?> mockHoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
    private HoodieTableMetaClient metaClient;
    private HoodieStorage storage;
    private static String PARTITION1 = "partition1";
    String earliestInstant = "20231204194919610";
    String earliestInstantMinusThreeDays = "20231201194919610";

    @BeforeEach
    void setUp() {
        this.metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)this.mockHoodieTable.getMetaClient()).thenReturn((Object)this.metaClient);
        HoodieTableConfig tableConfig = new HoodieTableConfig();
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)tableConfig);
        this.storage = (HoodieStorage)Mockito.spy((Object)HoodieStorageUtils.getStorage(CONF));
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.mockHoodieTable.getStorage()).thenReturn((Object)this.storage);
    }

    @ParameterizedTest
    @EnumSource(value=CleanFailureType.class)
    void testPartialCleanFailure(CleanFailureType failureType) throws IOException {
        HoodieWriteConfig config = TestCleanActionExecutor.getCleanByCommitsConfig();
        String fileGroup = UUID.randomUUID() + "-0";
        HoodieBaseFile baseFile = new HoodieBaseFile(String.format("/tmp/base/%s_1-0-1_%s.parquet", fileGroup, "001"));
        HoodieStorage localStorage = HoodieStorageUtils.getStorage((String)baseFile.getPath(), CONF);
        StoragePath filePath = new StoragePath(baseFile.getPath());
        if (failureType == CleanFailureType.TRUE_ON_DELETE) {
            Mockito.when((Object)this.storage.deleteFile(filePath)).thenReturn((Object)true);
        } else if (failureType == CleanFailureType.FALSE_ON_DELETE_IS_EXISTS_FALSE) {
            Mockito.when((Object)this.storage.deleteFile(filePath)).thenReturn((Object)false);
            Mockito.when((Object)this.storage.exists(filePath)).thenReturn((Object)false);
        } else if (failureType == CleanFailureType.FALSE_ON_DELETE_IS_EXISTS_TRUE) {
            Mockito.when((Object)this.storage.deleteFile(filePath)).thenReturn((Object)false);
            Mockito.when((Object)this.storage.exists(filePath)).thenReturn((Object)true);
        } else if (failureType == CleanFailureType.FILE_NOT_FOUND_EXC_ON_DELETE) {
            Mockito.when((Object)this.storage.deleteFile(filePath)).thenThrow(new Throwable[]{new FileNotFoundException("throwing file not found exception")});
        } else {
            Mockito.when((Object)this.storage.deleteFile(filePath)).thenThrow(new Throwable[]{new RuntimeException("throwing run time exception")});
        }
        localStorage.create(filePath);
        HashMap<String, List<HoodieCleanFileInfo>> partitionCleanFileInfoMap = new HashMap<String, List<HoodieCleanFileInfo>>();
        List<HoodieCleanFileInfo> cleanFileInfos = Collections.singletonList(new HoodieCleanFileInfo(baseFile.getPath(), Boolean.valueOf(false)));
        partitionCleanFileInfoMap.put(PARTITION1, cleanFileInfos);
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant(this.earliestInstant, "commit", HoodieInstant.State.COMPLETED.name()), this.earliestInstantMinusThreeDays, HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name(), Collections.emptyMap(), CleanPlanner.LATEST_CLEAN_PLAN_VERSION, partitionCleanFileInfoMap, Collections.emptyList(), Collections.emptyMap());
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)this.metaClient.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)this.mockHoodieTable.getActiveTimeline()).thenReturn((Object)activeTimeline);
        HoodieInstant cleanInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clean", "002");
        HoodieActiveTimeline cleanTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        Mockito.when((Object)activeTimeline.getCleanerTimeline()).thenReturn((Object)cleanTimeline);
        Mockito.when((Object)cleanTimeline.getInstants()).thenReturn(Collections.singletonList(cleanInstant));
        Mockito.when((Object)activeTimeline.readCleanerPlan(cleanInstant)).thenReturn((Object)cleanerPlan);
        Mockito.when((Object)activeTimeline.readCleanerInfoAsBytes(cleanInstant)).thenReturn((Object)Option.of((Object)HoodieTestUtils.convertMetadataToByteArray((Object)cleanerPlan)));
        Mockito.when((Object)this.mockHoodieTable.getCleanTimeline()).thenReturn((Object)cleanTimeline);
        Mockito.when((Object)this.mockHoodieTable.getInstantGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameGenerator()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR);
        Mockito.when((Object)this.mockHoodieTable.getInstantFileNameParser()).thenReturn((Object)HoodieTestUtils.INSTANT_FILE_NAME_PARSER);
        HoodieTimeline inflightsAndRequestedTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)cleanTimeline.filterInflightsAndRequested()).thenReturn((Object)inflightsAndRequestedTimeline);
        Mockito.when((Object)inflightsAndRequestedTimeline.getInstants()).thenReturn(Collections.singletonList(cleanInstant));
        Mockito.when((Object)activeTimeline.transitionCleanRequestedToInflight((HoodieInstant)ArgumentMatchers.any(), (Option)ArgumentMatchers.any())).thenReturn((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clean", "002"));
        Mockito.when((Object)this.mockHoodieTable.getMetadataWriter("002")).thenReturn((Object)Option.empty());
        CleanActionExecutor cleanActionExecutor = new CleanActionExecutor(this.context, config, this.mockHoodieTable, "002");
        if (failureType == CleanFailureType.TRUE_ON_DELETE) {
            this.assertCleanExecutionSuccess(cleanActionExecutor, filePath);
        } else if (failureType == CleanFailureType.FALSE_ON_DELETE_IS_EXISTS_FALSE) {
            this.assertCleanExecutionSuccess(cleanActionExecutor, filePath);
        } else if (failureType == CleanFailureType.FALSE_ON_DELETE_IS_EXISTS_TRUE) {
            this.assertCleanExecutionFailure(cleanActionExecutor);
        } else if (failureType == CleanFailureType.FILE_NOT_FOUND_EXC_ON_DELETE) {
            this.assertCleanExecutionSuccess(cleanActionExecutor, filePath);
        } else {
            this.assertCleanExecutionFailure(cleanActionExecutor);
        }
    }

    private void assertCleanExecutionFailure(CleanActionExecutor cleanActionExecutor) {
        Assertions.assertThrows(HoodieException.class, () -> cleanActionExecutor.execute());
    }

    private void assertCleanExecutionSuccess(CleanActionExecutor cleanActionExecutor, StoragePath filePath) {
        HoodieCleanMetadata cleanMetadata = cleanActionExecutor.execute();
        Assertions.assertTrue((boolean)cleanMetadata.getPartitionMetadata().containsKey(PARTITION1));
        HoodieCleanPartitionMetadata cleanPartitionMetadata = (HoodieCleanPartitionMetadata)cleanMetadata.getPartitionMetadata().get(PARTITION1);
        Assertions.assertTrue((boolean)cleanPartitionMetadata.getDeletePathPatterns().contains(filePath.getName()));
    }

    private static HoodieWriteConfig getCleanByCommitsConfig() {
        return HoodieWriteConfig.newBuilder().withPath("/tmp").withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
    }

    static enum CleanFailureType {
        TRUE_ON_DELETE,
        FALSE_ON_DELETE_IS_EXISTS_FALSE,
        FALSE_ON_DELETE_IS_EXISTS_TRUE,
        FILE_NOT_FOUND_EXC_ON_DELETE,
        RUNTIME_EXC_ON_DELETE;

    }
}

