/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.marker.DirectWriteMarkers;
import org.apache.hudi.table.marker.TestWriteMarkersBase;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDirectWriteMarkers
extends TestWriteMarkersBase {
    @BeforeEach
    public void setup() throws IOException {
        this.initPath();
        this.initMetaClient();
        this.jsc = new JavaSparkContext(HoodieClientTestUtils.getSparkConfForTest(TestDirectWriteMarkers.class.getName()));
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.storage = this.metaClient.getStorage();
        this.markerFolderPath = new StoragePath(Paths.get(this.metaClient.getMarkerFolderPath("000"), new String[0]).toUri());
        this.writeMarkers = new DirectWriteMarkers(this.storage, this.metaClient.getBasePath().toString(), this.markerFolderPath.toString(), "000");
    }

    @AfterEach
    public void cleanup() {
        this.jsc.stop();
        this.context = null;
    }

    @Override
    void verifyMarkersInFileSystem(boolean isTablePartitioned) throws IOException {
        List markerFiles = HoodieTestTable.listRecursive((HoodieStorage)this.storage, (StoragePath)this.markerFolderPath).stream().filter(status -> status.getPath().getName().contains(".marker")).sorted().collect(Collectors.toList());
        List expectedList = this.getRelativeMarkerPathList(isTablePartitioned).stream().map(e -> this.markerFolderPath.toString() + "/" + e).collect(Collectors.toList());
        Assertions.assertIterableEquals(expectedList, (Iterable)markerFiles.stream().map(m -> m.getPath().toString()).collect(Collectors.toList()));
    }

    @Test
    public void testMarkerReconciliation() throws IOException {
        this.initMetaClient();
        this.createSomeMarkers(true);
        String fileName1 = "file5.parquet";
        String partitionPathToTest = "2020/06/01";
        StoragePath dataFile1 = this.createDataFile("2020/06/01", fileName1);
        this.writeMarkers.create("2020/06/01", fileName1, IOType.CREATE);
        String fileName2 = "file6.parquet";
        StoragePath dataFile2 = this.createDataFile("2020/06/01", fileName2);
        this.writeMarkers.create("2020/06/01", fileName2, IOType.CREATE);
        ArrayList<String> expectedMarkerPaths = new ArrayList<String>(this.getRelativeMarkerPathList(true));
        ArrayList<String> expectedDataPaths = new ArrayList<String>(expectedMarkerPaths.stream().map(entry -> entry.substring(0, entry.indexOf(".marker"))).collect(Collectors.toList()));
        expectedDataPaths.add(partitionPathToTest + "/" + fileName1);
        ArrayList writeStatList = new ArrayList();
        expectedDataPaths.forEach(entry -> {
            String fullPath = entry;
            String fileName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
            String partitionPath = fullPath.substring(0, fullPath.lastIndexOf("/"));
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPath(partitionPath + "/" + fileName);
            writeStatList.add(writeStat);
        });
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath()).withMarkersType(MarkerType.DIRECT.name()).build();
        HoodieSparkTable hoodieTable = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)this.context, (HoodieTableMetaClient)this.metaClient);
        hoodieTable.finalizeWrite((HoodieEngineContext)this.context, "000", writeStatList);
        Assertions.assertTrue((boolean)this.storage.exists(dataFile1));
        Assertions.assertTrue((!this.storage.exists(dataFile2) ? 1 : 0) != 0);
    }

    @Test
    public void testFailureToDeleteDuringReconciliation() {
    }
}

