/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.exception.HoodieRemoteException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.marker.TestWriteMarkersBase;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.hudi.timeline.service.TimelineServiceTestHarness;
import org.apache.spark.api.java.JavaSparkContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTimelineServerBasedWriteMarkers
extends TestWriteMarkersBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestTimelineServerBasedWriteMarkers.class);
    protected static int DEFAULT_READ_TIMEOUT_SECS = 60;
    TimelineService timelineService = null;

    @BeforeEach
    public void setup() throws IOException {
        this.initPath();
        this.initMetaClient();
        this.jsc = new JavaSparkContext(HoodieClientTestUtils.getSparkConfForTest(TestTimelineServerBasedWriteMarkers.class.getName()));
        this.context = new HoodieSparkEngineContext(this.jsc);
        this.storage = this.metaClient.getStorage();
        this.markerFolderPath = new StoragePath(this.metaClient.getMarkerFolderPath("000"));
        this.restartServerAndClient(0);
        LOG.info("Connecting to Timeline Server :" + this.timelineService.getServerPort());
    }

    @AfterEach
    public void cleanup() {
        if (this.timelineService != null) {
            this.timelineService.close();
        }
        this.jsc.stop();
        this.context = null;
    }

    @Override
    void verifyMarkersInFileSystem(boolean isTablePartitioned) throws IOException {
        List allMarkers = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem((String)this.markerFolderPath.toString(), (HoodieStorage)this.storage, (HoodieEngineContext)this.context, (int)1).values().stream().flatMap(Collection::stream).sorted().collect(Collectors.toList());
        List<String> expectedMarkers = this.getRelativeMarkerPathList(isTablePartitioned);
        Assertions.assertIterableEquals(expectedMarkers, allMarkers);
        StoragePath markerTypeFilePath = new StoragePath(this.markerFolderPath, "MARKERS.type");
        Assertions.assertTrue((boolean)MarkerUtils.doesMarkerTypeFileExist((HoodieStorage)this.storage, (String)this.markerFolderPath.toString()));
        InputStream inputStream = this.storage.open(markerTypeFilePath);
        Assertions.assertEquals((Object)MarkerType.TIMELINE_SERVER_BASED.toString(), (Object)FileIOUtils.readAsUTFString((InputStream)inputStream));
        this.closeQuietly(inputStream);
    }

    @ParameterizedTest
    @EnumSource(value=FileSystemViewStorageType.class)
    public void testCreationWithTimelineServiceRetries(FileSystemViewStorageType storageType) throws Exception {
        this.restartServerAndClient(0, storageType);
        LOG.info("Connecting to Timeline Server :" + this.timelineService.getServerPort());
        this.createSomeMarkers(true);
        Assertions.assertTrue((boolean)this.storage.exists(this.markerFolderPath));
        Assertions.assertTrue((boolean)this.writeMarkers.doesMarkerDirExist());
        this.restartServerAndClient(1);
        TestTimelineServerBasedWriteMarkers.validateRequestFailed(() -> ((WriteMarkers)this.writeMarkers).doesMarkerDirExist());
        this.restartServerAndClient(3);
        TimelineServerBasedWriteMarkers writeMarkersWithRetries = TestTimelineServerBasedWriteMarkers.initWriteMarkers(this.metaClient.getBasePath().toString(), this.markerFolderPath.toString(), this.timelineService.getServerPort(), true);
        Assertions.assertTrue((boolean)writeMarkersWithRetries.doesMarkerDirExist());
    }

    private void restartServerAndClient(int numberOfSimulatedConnectionFailures) {
        this.restartServerAndClient(numberOfSimulatedConnectionFailures, FileSystemViewStorageType.SPILLABLE_DISK);
    }

    private void restartServerAndClient(int numberOfSimulatedConnectionFailures, FileSystemViewStorageType storageType) {
        if (this.timelineService != null) {
            this.timelineService.close();
        }
        try {
            HoodieLocalEngineContext hoodieEngineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
            FileSystemViewStorageConfig storageConf = FileSystemViewStorageConfig.newBuilder().withStorageType(storageType).build();
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
            TimelineServiceTestHarness.Builder builder = TimelineServiceTestHarness.newBuilder();
            builder.withNumberOfSimulatedConnectionFailures(numberOfSimulatedConnectionFailures);
            this.timelineService = builder.build((HoodieEngineContext)hoodieEngineContext, (Configuration)this.storage.getConf().unwrap(), TimelineService.Config.builder().serverPort(0).enableMarkerRequests(true).build(), FileSystemViewManager.createViewManager((HoodieEngineContext)hoodieEngineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)storageConf, (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build()));
            this.timelineService.startService();
            this.writeMarkers = TestTimelineServerBasedWriteMarkers.initWriteMarkers(this.metaClient.getBasePath().toString(), this.markerFolderPath.toString(), this.timelineService.getServerPort(), false);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static TimelineServerBasedWriteMarkers initWriteMarkers(String basePath, String markerFolderPath, int serverPort, boolean enableRetries) {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(serverPort)).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(DEFAULT_READ_TIMEOUT_SECS));
        if (enableRetries) {
            builder.withRemoteTimelineClientRetry(true).withRemoteTimelineClientMaxRetryIntervalMs(Long.valueOf(30000L)).withRemoteTimelineClientMaxRetryNumbers(Integer.valueOf(5));
        }
        return new TimelineServerBasedWriteMarkers(basePath, markerFolderPath, "000", builder.build());
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void validateRequestFailed(Executable executable) {
        Assertions.assertThrows(HoodieRemoteException.class, (Executable)executable, (String)"Should catch a NoHTTPResponseException");
    }
}

