/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.TestTimelineServerBasedWriteMarkers;
import org.apache.hudi.table.marker.TimelineServerBasedWriteMarkersV1;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public class TestTimelineServerBasedWriteMarkersV1
extends TestTimelineServerBasedWriteMarkers {
    @Override
    @BeforeEach
    public void setup() throws IOException {
        super.setup();
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().withRemoteServerHost("localhost").withRemoteServerPort(Integer.valueOf(this.timelineService.getServerPort())).withRemoteTimelineClientTimeoutSecs(Integer.valueOf(DEFAULT_READ_TIMEOUT_SECS));
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        Mockito.when((Object)table.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)this.metaClient);
        HoodieWriteConfig writeConfig = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        Mockito.when((Object)table.getConfig()).thenReturn((Object)writeConfig);
        Mockito.when((Object)writeConfig.getViewStorageConfig()).thenReturn((Object)builder.build());
        this.writeMarkers = new TimelineServerBasedWriteMarkersV1(table, "000");
    }
}

