/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.bootstrap.index.TestBootstrapIndex;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BootstrapFileMapping;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.FileCreateUtilsLegacy;
import org.apache.hudi.common.testutils.HoodieMetadataTestTable;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.junit.jupiter.api.Assertions;

public class HoodieCleanerTestBase
extends HoodieClientTestBase {
    protected static HoodieCommitMetadata generateCommitMetadata(String instantTime, Map<String, List<String>> partitionToFilePaths) {
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.addMetadata("schema", "{\"namespace\": \"org.apache.hudi.avro.model\", \"type\": \"record\", \"name\": \"PhonyRecord\", \"fields\": []}");
        partitionToFilePaths.forEach((partitionPath, fileList) -> fileList.forEach(f -> {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setPartitionPath(partitionPath);
            writeStat.setPath(partitionPath + "/" + f);
            writeStat.setFileId(f);
            writeStat.setTotalWriteBytes(1L);
            writeStat.setFileSizeInBytes(1L);
            metadata.addWriteStat(partitionPath, writeStat);
        }));
        return metadata;
    }

    protected List<HoodieCleanStat> runCleaner(HoodieWriteConfig config) throws IOException {
        return this.runCleaner(config, false, false, 1, false);
    }

    protected List<HoodieCleanStat> runCleanerWithInstantFormat(HoodieWriteConfig config, boolean needInstantInHudiFormat) throws IOException {
        return this.runCleaner(config, false, false, 1, needInstantInHudiFormat);
    }

    protected List<HoodieCleanStat> runCleaner(HoodieWriteConfig config, int firstCommitSequence, boolean needInstantInHudiFormat) throws IOException {
        return this.runCleaner(config, false, false, firstCommitSequence, needInstantInHudiFormat);
    }

    protected List<HoodieCleanStat> runCleaner(HoodieWriteConfig config, boolean simulateRetryFailure) throws IOException {
        return this.runCleaner(config, simulateRetryFailure, false, 1, false);
    }

    protected List<HoodieCleanStat> runCleaner(HoodieWriteConfig config, boolean simulateRetryFailure, boolean simulateMetadataFailure) throws IOException {
        return this.runCleaner(config, simulateRetryFailure, simulateMetadataFailure, 1, false);
    }

    protected List<HoodieCleanStat> runCleaner(HoodieWriteConfig config, boolean simulateRetryFailure, boolean simulateMetadataFailure, Integer firstCommitSequence, boolean needInstantInHudiFormat) throws IOException {
        String cleanInstantTs;
        SparkRDDWriteClient writeClient = this.getHoodieWriteClient(config);
        HoodieCleanMetadata cleanMetadata1 = writeClient.clean(cleanInstantTs = needInstantInHudiFormat ? HoodieTestTable.makeNewCommitTime((int)firstCommitSequence, (String)"%014d") : HoodieTestTable.makeNewCommitTime((int)firstCommitSequence, (String)"%09d"));
        if (null == cleanMetadata1) {
            return new ArrayList<HoodieCleanStat>();
        }
        if (simulateRetryFailure) {
            HoodieInstant completedCleanInstant = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "clean", cleanInstantTs);
            HoodieCleanMetadata metadata = CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)this.metaClient, (HoodieInstant)completedCleanInstant);
            metadata.getPartitionMetadata().values().forEach(p -> {
                String dirPath = this.metaClient.getBasePath() + "/" + p.getPartitionPath();
                p.getSuccessDeleteFiles().forEach(p2 -> {
                    try {
                        this.metaClient.getStorage().create(new StoragePath(dirPath, p2), true).close();
                    }
                    catch (IOException e) {
                        throw new HoodieIOException(e.getMessage(), e);
                    }
                });
            });
            this.metaClient.reloadActiveTimeline().revertToInflight(completedCleanInstant);
            if (config.isMetadataTableEnabled() && simulateMetadataFailure) {
                HoodieTableMetaClient metadataMetaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.metaClient.getStorageConf(), (StoragePath)HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePath()), (HoodieTableVersion)this.metaClient.getTableConfig().getTableVersion());
                HoodieInstant deltaCommit = HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", cleanInstantTs);
                metadataMetaClient.reloadActiveTimeline().revertToInflight(deltaCommit);
            }
            writeClient.clean();
            HoodieCleanMetadata retriedCleanMetadata = CleanerUtils.getCleanerMetadata((HoodieTableMetaClient)HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient), (HoodieInstant)completedCleanInstant);
            cleanMetadata1.getPartitionMetadata().keySet().forEach(k -> {
                HoodieCleanPartitionMetadata p1 = (HoodieCleanPartitionMetadata)cleanMetadata1.getPartitionMetadata().get(k);
                HoodieCleanPartitionMetadata p2 = (HoodieCleanPartitionMetadata)retriedCleanMetadata.getPartitionMetadata().get(k);
                Assertions.assertEquals((Object)p1.getDeletePathPatterns(), (Object)p2.getDeletePathPatterns());
                Assertions.assertEquals((Object)p1.getSuccessDeleteFiles(), (Object)p2.getSuccessDeleteFiles());
                Assertions.assertEquals((Object)p1.getFailedDeleteFiles(), (Object)p2.getFailedDeleteFiles());
                Assertions.assertEquals((Object)p1.getPartitionPath(), (Object)p2.getPartitionPath());
                Assertions.assertEquals((Object)k, (Object)p1.getPartitionPath());
            });
        }
        Map<String, HoodieCleanStat> cleanStatMap = cleanMetadata1.getPartitionMetadata().values().stream().map(x -> new HoodieCleanStat.Builder().withPartitionPath(x.getPartitionPath()).withFailedDeletes(x.getFailedDeleteFiles()).withSuccessfulDeletes(x.getSuccessDeleteFiles()).withPolicy(HoodieCleaningPolicy.valueOf((String)x.getPolicy())).withDeletePathPattern(x.getDeletePathPatterns()).withEarliestCommitRetained(Option.ofNullable(cleanMetadata1.getEarliestCommitToRetain() != null ? HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "000") : null)).build()).collect(Collectors.toMap(HoodieCleanStat::getPartitionPath, x -> x));
        cleanMetadata1.getBootstrapPartitionMetadata().values().forEach(x -> {
            HoodieCleanStat s = (HoodieCleanStat)cleanStatMap.get(x.getPartitionPath());
            cleanStatMap.put(x.getPartitionPath(), new HoodieCleanStat.Builder().withPartitionPath(x.getPartitionPath()).withFailedDeletes(s.getFailedDeleteFiles()).withSuccessfulDeletes(s.getSuccessDeleteFiles()).withPolicy(HoodieCleaningPolicy.valueOf((String)x.getPolicy())).withDeletePathPattern(s.getDeletePathPatterns()).withEarliestCommitRetained(Option.ofNullable((Object)s.getEarliestCommitToRetain()).map(y -> HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", y))).withSuccessfulDeleteBootstrapBaseFiles(x.getSuccessDeleteFiles()).withFailedDeleteBootstrapBaseFiles(x.getFailedDeleteFiles()).withDeleteBootstrapBasePathPatterns(x.getDeletePathPatterns()).build());
        });
        return new ArrayList<HoodieCleanStat>(cleanStatMap.values());
    }

    public void commitWithMdt(String instantTime, Map<String, List<String>> partToFileId, HoodieTestTable testTable, HoodieWriteConfig config) throws Exception {
        this.commitWithMdt(instantTime, partToFileId, testTable, config, true, false);
    }

    public void commitWithMdt(String instantTime, Map<String, List<String>> partToFileId, HoodieTestTable testTable, HoodieWriteConfig config, boolean addBaseFiles, boolean addLogFiles) throws Exception {
        testTable.addInflightCommit(instantTime);
        HashMap<String, List<String>> partToFileIds = new HashMap<String, List<String>>();
        partToFileId.forEach((key, value) -> {
            try {
                ArrayList files = new ArrayList();
                FileCreateUtilsLegacy.createPartitionMetaFile((String)this.basePath, (String)key);
                if (addBaseFiles) {
                    files.addAll((Collection)testTable.withBaseFilesInPartition(key, value.toArray(new String[0])).getValue());
                }
                if (addLogFiles) {
                    value.forEach(logFilePrefix -> {
                        try {
                            files.addAll((Collection)testTable.withLogFile(key, logFilePrefix, new int[]{1, 2}).getValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                partToFileIds.put((String)key, files);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        HoodieCommitMetadata commitMeta = HoodieCleanerTestBase.generateCommitMetadata(instantTime, partToFileIds);
        try (HoodieTableMetadataWriter metadataWriter = this.getMetadataWriter(config);){
            metadataWriter.performTableServices(Option.of((Object)instantTime), true);
            metadataWriter.update(commitMeta, instantTime);
            this.metaClient.getActiveTimeline().saveAsComplete(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", instantTime), Option.of((Object)commitMeta));
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        }
    }

    protected HoodieTableMetadataWriter getMetadataWriter(HoodieWriteConfig config) {
        return SparkHoodieBackedTableMetadataWriter.create((StorageConfiguration)this.storageConf, (HoodieWriteConfig)config, (HoodieEngineContext)this.context);
    }

    protected HoodieTestTable tearDownTestTableAndReinit(HoodieTestTable testTable, HoodieWriteConfig config) throws Exception {
        testTable.close();
        return HoodieMetadataTestTable.of((HoodieTableMetaClient)this.metaClient, (HoodieTableMetadataWriter)this.getMetadataWriter(config), (Option)Option.of((Object)this.context));
    }

    protected Map<String, List<BootstrapFileMapping>> generateBootstrapIndexAndSourceData(String ... partitions) throws IOException {
        Path sourcePath = this.tempDir.resolve("data");
        Files.createDirectories(sourcePath, new FileAttribute[0]);
        Assertions.assertTrue((boolean)new File(sourcePath.toString()).exists());
        this.metaClient = HoodieTestUtils.init((String)this.basePath, (HoodieTableType)this.getTableType(), (String)sourcePath.toString(), (boolean)true);
        Map bootstrapMapping = TestBootstrapIndex.generateBootstrapIndex((HoodieTableMetaClient)this.metaClient, (String)sourcePath.toString(), (String[])partitions, (int)1);
        for (Map.Entry entry : bootstrapMapping.entrySet()) {
            new File(sourcePath + "/" + (String)entry.getKey()).mkdirs();
            Assertions.assertTrue((boolean)new File(((BootstrapFileMapping)((List)entry.getValue()).get(0)).getBootstrapFileStatus().getPath().getUri()).createNewFile());
        }
        return bootstrapMapping;
    }
}

