/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieWriteableTestTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkWriteableTestTable
extends HoodieWriteableTestTable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkWriteableTestTable.class);

    private HoodieSparkWriteableTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter) {
        this(basePath, storage, metaClient, schema, filter, metadataWriter, (Option<HoodieEngineContext>)Option.empty());
    }

    private HoodieSparkWriteableTestTable(String basePath, HoodieStorage storage, HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter, Option<HoodieEngineContext> context) {
        super(basePath, storage, metaClient, schema, filter, metadataWriter, context);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter) {
        return HoodieSparkWriteableTestTable.of(metaClient, schema, filter, (Option<HoodieEngineContext>)Option.empty());
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, Option<HoodieEngineContext> context) {
        return new HoodieSparkWriteableTestTable(metaClient.getBasePath().toString(), metaClient.getRawStorage(), metaClient, schema, filter, null, context);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter) {
        return HoodieSparkWriteableTestTable.of(metaClient, schema, filter, metadataWriter, (Option<HoodieEngineContext>)Option.empty());
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, BloomFilter filter, HoodieTableMetadataWriter metadataWriter, Option<HoodieEngineContext> context) {
        return new HoodieSparkWriteableTestTable(metaClient.getBasePath().toString(), metaClient.getRawStorage(), metaClient, schema, filter, metadataWriter, context);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema) {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.SIMPLE.name());
        return HoodieSparkWriteableTestTable.of(metaClient, schema, filter);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, HoodieTableMetadataWriter metadataWriter) {
        return HoodieSparkWriteableTestTable.of(metaClient, schema, metadataWriter, (Option<HoodieEngineContext>)Option.empty());
    }

    public static HoodieSparkWriteableTestTable of(HoodieTableMetaClient metaClient, Schema schema, HoodieTableMetadataWriter metadataWriter, Option<HoodieEngineContext> context) {
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)10000, (double)1.0E-7, (int)-1, (String)BloomFilterTypeCode.DYNAMIC_V0.name());
        return HoodieSparkWriteableTestTable.of(metaClient, schema, filter, metadataWriter, context);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTable hoodieTable, Schema schema) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        return HoodieSparkWriteableTestTable.of(metaClient, schema);
    }

    public static HoodieSparkWriteableTestTable of(HoodieTable hoodieTable, Schema schema, BloomFilter filter) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        return HoodieSparkWriteableTestTable.of(metaClient, schema, filter);
    }

    public HoodieSparkWriteableTestTable addCommit(String instantTime) throws Exception {
        return (HoodieSparkWriteableTestTable)super.addCommit(instantTime);
    }

    public HoodieSparkWriteableTestTable forCommit(String instantTime) {
        return (HoodieSparkWriteableTestTable)super.forCommit(instantTime);
    }

    public String getFileIdWithInserts(String partition) throws Exception {
        return this.getFileIdWithInserts(partition, new HoodieRecord[0]);
    }

    public String getFileIdWithInserts(String partition, HoodieRecord ... records) throws Exception {
        return this.getFileIdWithInserts(partition, Arrays.asList(records));
    }

    public String getFileIdWithInserts(String partition, List<HoodieRecord> records) throws Exception {
        String fileId = UUID.randomUUID().toString();
        this.withInserts(partition, fileId, records);
        return fileId;
    }

    public HoodieSparkWriteableTestTable withInserts(String partition, String fileId) throws Exception {
        return this.withInserts(partition, fileId, new HoodieRecord[0]);
    }

    public HoodieSparkWriteableTestTable withInserts(String partition, String fileId, HoodieRecord ... records) throws Exception {
        this.withInserts(partition, fileId, Arrays.asList(records));
        return this;
    }

    public StoragePath withInserts(String partition, String fileId, List<HoodieRecord> records) throws Exception {
        return super.withInserts(partition, fileId, records, (TaskContextSupplier)new SparkTaskContextSupplier());
    }

    public HoodieSparkWriteableTestTable withLogAppends(String partition, String fileId, HoodieRecord ... records) throws Exception {
        this.withLogAppends(partition, fileId, Arrays.asList(records));
        return this;
    }

    public Map<String, List<HoodieLogFile>> withLogAppends(String partition, String fileId, List<HoodieRecord> records) throws Exception {
        return super.withLogAppends(partition, fileId, records);
    }
}

