/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.spark.HoodieSparkKryoRegistrar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class TestHoodieSparkKryoRegistrar {
    @Test
    public void testSerdeHoodieHadoopConfiguration() {
        Kryo kryo = this.newKryo();
        HadoopStorageConfiguration conf = new HadoopStorageConfiguration(new Configuration());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, (Object)conf);
        output.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        Input input = new Input((InputStream)bais);
        HadoopStorageConfiguration deserialized = (HadoopStorageConfiguration)kryo.readObject(input, HadoopStorageConfiguration.class);
        input.close();
        Assertions.assertEquals(this.getPropsInMap(conf), this.getPropsInMap(deserialized));
    }

    private Kryo newKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        new HoodieSparkKryoRegistrar().registerClasses(kryo);
        return kryo;
    }

    private Map<String, String> getPropsInMap(HadoopStorageConfiguration conf) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        conf.unwrap().iterator().forEachRemaining(e -> {
            String cfr_ignored_0 = (String)configMap.put((String)e.getKey(), (String)e.getValue());
        });
        return configMap;
    }
}

