/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.model.HoodieInternalRow;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.keygen.AutoRecordGenWrapperKeyGenerator;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BucketBulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.BulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.ConsistentBucketBulkInsertDataInternalWriterHelper;
import org.apache.hudi.table.action.commit.ParallelismHelper;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils$;
import org.apache.spark.sql.HoodieUnsafeUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HoodieDatasetBulkInsertHelper$
extends ParallelismHelper<Dataset<Row>>
implements Logging {
    public static HoodieDatasetBulkInsertHelper$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HoodieDatasetBulkInsertHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> prepareForBulkInsert(Dataset<Row> df, HoodieWriteConfig config, BulkInsertPartitioner<Dataset<Row>> partitioner, String instantTime) {
        Dataset<Row> dataset;
        boolean populateMetaFields = config.populateMetaFields();
        StructType schema = df.schema();
        boolean autoGenerateRecordKeys = KeyGenUtils.isAutoGeneratedRecordKeysEnabled((TypedProperties)config.getProps());
        Seq metaFields = (Seq)new .colon.colon((Object)new StructField(HoodieRecord.COMMIT_TIME_METADATA_FIELD, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(HoodieRecord.RECORD_KEY_METADATA_FIELD, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(HoodieRecord.PARTITION_PATH_METADATA_FIELD, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(HoodieRecord.FILENAME_METADATA_FIELD, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        StructType updatedSchema = StructType$.MODULE$.apply((Seq)metaFields.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())), Seq$.MODULE$.canBuildFrom()));
        int targetParallelism = this.deduceShuffleParallelism(df, config.getBulkInsertShuffleParallelism());
        if (populateMetaFields) {
            String keyGeneratorClassName = config.getStringOrThrow(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME, "Key-generator class name is required");
            RDD prependedRdd = HoodieSparkUtils$.MODULE$.injectSQLConf(df.queryExecution().toRdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
                Object object;
                TypedProperties typedProps = TypedProperties.copy((Properties)config.getProps());
                if (autoGenerateRecordKeys) {
                    typedProps.setProperty("_hoodie.record.key.gen.partition.id", String.valueOf(TaskContext$.MODULE$.getPartitionId()));
                    object = typedProps.setProperty("_hoodie.record.key.gen.instant.time", instantTime);
                } else {
                    object = BoxedUnit.UNIT;
                }
                BuiltinKeyGenerator sparkKeyGenerator = (BuiltinKeyGenerator)ReflectionUtils.loadClass((String)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator(keyGeneratorClassName), (Object[])new Object[]{typedProps});
                BuiltinKeyGenerator keyGenerator = autoGenerateRecordKeys ? new AutoRecordGenWrapperKeyGenerator(typedProps, sparkKeyGenerator) : sparkKeyGenerator;
                return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                    UTF8String recordKey = keyGenerator.getRecordKey((InternalRow)row, schema);
                    UTF8String partitionPath = keyGenerator.getPartitionPath((InternalRow)row, schema);
                    UTF8String commitTimestamp = UTF8String.EMPTY_UTF8;
                    UTF8String commitSeqNo = UTF8String.EMPTY_UTF8;
                    UTF8String filename = UTF8String.EMPTY_UTF8;
                    return new HoodieInternalRow(commitTimestamp, commitSeqNo, recordKey, partitionPath, filename, (InternalRow)row, false);
                });
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)), SQLConf$.MODULE$.get(), ClassTag$.MODULE$.apply(InternalRow.class));
            RDD dedupedRdd = config.shouldCombineBeforeInsert() ? this.dedupeRows(prependedRdd, updatedSchema, config.getPreCombineField(), SparkHoodieIndexFactory.isGlobalIndex(config), targetParallelism) : prependedRdd;
            dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFromRDD(df.sparkSession(), dedupedRdd, updatedSchema);
        } else {
            LogicalPlan query = df.queryExecution().logical();
            Seq metaFieldsStubs = (Seq)metaFields.map((Function1 & Serializable & scala.Serializable)f -> {
                Literal x$1 = new Literal((Object)UTF8String.EMPTY_UTF8, (DataType)StringType$.MODULE$);
                String x$2 = f.name();
                ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
            }, Seq$.MODULE$.canBuildFrom());
            Project prependedQuery = new Project((Seq)metaFieldsStubs.$plus$plus((GenTraversableOnce)query.output(), Seq$.MODULE$.canBuildFrom()), query);
            dataset = HoodieUnsafeUtils$.MODULE$.createDataFrameFrom(df.sparkSession(), (LogicalPlan)prependedQuery);
        }
        Dataset<Row> updatedDF = dataset;
        return (Dataset)partitioner.repartitionRecords(updatedDF, targetParallelism);
    }

    public HoodieData<WriteStatus> bulkInsert(Dataset<Row> dataset, String instantTime, HoodieTable<?, ?, ?, ?> table, HoodieWriteConfig writeConfig, boolean arePartitionRecordsSorted, boolean shouldPreserveHoodieMetadata, WriteOperationType operation) {
        WriteOperationType writeOperationType = operation;
        StructType schema = WriteOperationType.CLUSTER.equals(writeOperationType) ? this.alignNotNullFields(dataset.schema(), new Schema.Parser().parse(writeConfig.getSchema())) : dataset.schema();
        return HoodieJavaRDD.of(HoodieSparkUtils$.MODULE$.injectSQLConf(dataset.queryExecution().toRdd().mapPartitions(arg_0 -> HoodieDatasetBulkInsertHelper$.$anonfun$bulkInsert$1(table, writeConfig, instantTime, schema, arePartitionRecordsSorted, shouldPreserveHoodieMetadata, arg_0), dataset.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(WriteStatus.class)), SQLConf$.MODULE$.get(), ClassTag$.MODULE$.apply(WriteStatus.class)).toJavaRDD());
    }

    private StructType alignNotNullFields(StructType sourceSchema, Schema avroSchema) {
        Buffer notNullFieldNames = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieDatasetBulkInsertHelper$.$anonfun$alignNotNullFields$1(f)))).map((Function1 & Serializable & scala.Serializable)f -> f.name(), Buffer$.MODULE$.canBuildFrom());
        if (notNullFieldNames.isEmpty()) {
            return sourceSchema;
        }
        Seq copiedFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            if (notNullFieldNames.contains((Object)field.name())) {
                boolean x$1 = false;
                String x$2 = field.copy$default$1();
                DataType x$3 = field.copy$default$2();
                Metadata x$4 = field.copy$default$4();
                return field.copy(x$2, x$3, x$1, x$4);
            }
            return field.copy(field.copy$default$1(), field.copy$default$2(), field.copy$default$3(), field.copy$default$4());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))).toSeq();
        return StructType$.MODULE$.apply(copiedFields);
    }

    private RDD<InternalRow> dedupeRows(RDD<InternalRow> rdd, StructType schema, String preCombineFieldRef, boolean isGlobalIndex, int targetParallelism) {
        int recordKeyMetaFieldOrd = schema.fieldIndex(HoodieRecord.RECORD_KEY_METADATA_FIELD);
        int partitionPathMetaFieldOrd = schema.fieldIndex(HoodieRecord.PARTITION_PATH_METADATA_FIELD);
        HoodieUnsafeRowUtils.NestedFieldPath preCombineFieldPath = (HoodieUnsafeRowUtils.NestedFieldPath)HoodieUnsafeRowUtils$.MODULE$.composeNestedFieldPath(schema, preCombineFieldRef).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new HoodieException(new StringBuilder(33).append("Pre-combine field ").append(preCombineFieldRef).append(" is missing in ").append(schema).toString());
        });
        return RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(rdd.map((Function1 & Serializable & scala.Serializable)row -> {
            String string;
            if (isGlobalIndex) {
                string = row.getString(recordKeyMetaFieldOrd);
            } else {
                String partitionPath = row.getString(partitionPathMetaFieldOrd);
                String recordKey = row.getString(recordKeyMetaFieldOrd);
                string = new StringBuilder(1).append(partitionPath).append(":").append(recordKey).toString();
            }
            String rowKey = string;
            return new Tuple2((Object)rowKey, (Object)row.copy());
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(InternalRow.class), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(oneRow, otherRow) -> {
            Comparable otherPreCombineVal;
            Comparable onePreCombineVal = (Comparable)HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue((InternalRow)oneRow, preCombineFieldPath);
            if (onePreCombineVal.compareTo(otherPreCombineVal = (Comparable)HoodieUnsafeRowUtils$.MODULE$.getNestedInternalRowValue((InternalRow)otherRow, preCombineFieldPath)) >= 0) {
                return oneRow;
            }
            return otherRow;
        }, targetParallelism), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(InternalRow.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    public int deduceShuffleParallelism(Dataset<Row> input, int configuredParallelism) {
        int deduceParallelism = super.deduceShuffleParallelism(input, configuredParallelism);
        if (deduceParallelism > 0) {
            return deduceParallelism;
        }
        return input.sparkSession().sparkContext().defaultParallelism();
    }

    private scala.collection.mutable.Seq<String> getPartitionPathFields(HoodieWriteConfig config) {
        String keyGeneratorClassName = config.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME);
        BuiltinKeyGenerator keyGenerator = (BuiltinKeyGenerator)ReflectionUtils.loadClass((String)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator(keyGeneratorClassName), (Object[])new Object[]{config.getProps()});
        return (scala.collection.mutable.Seq)JavaConverters$.MODULE$.asScalaBufferConverter(keyGenerator.getPartitionPathFields()).asScala();
    }

    public Seq<String> getPartitionPathCols(HoodieWriteConfig config) {
        Set partitionPathFields = this.getPartitionPathFields(config).toSet();
        Set nestedPartitionPathFields = (Set)partitionPathFields.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieDatasetBulkInsertHelper$.$anonfun$getPartitionPathCols$1(f)));
        return ((SetLike)partitionPathFields.$minus$minus((GenTraversableOnce)nestedPartitionPathFields)).toSeq();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterator $anonfun$bulkInsert$1(HoodieTable table$1, HoodieWriteConfig writeConfig$1, String instantTime$2, StructType schema$2, boolean arePartitionRecordsSorted$1, boolean shouldPreserveHoodieMetadata$1, Iterator iter) {
        block9: {
            block8: {
                taskContextSupplier = table$1.getTaskContextSupplier();
                taskPartitionId = (Integer)taskContextSupplier.getPartitionIdSupplier().get();
                taskId = Predef$.MODULE$.Integer2int((Integer)taskContextSupplier.getStageIdSupplier().get());
                taskEpochId = (Long)taskContextSupplier.getAttemptIdSupplier().get();
                var14_11 = false;
                var15_12 = null;
                var16_13 = writeConfig$1.getIndexType();
                if (!HoodieIndex.IndexType.BUCKET.equals(var16_13)) break block8;
                var14_11 = true;
                var15_12 = var16_13;
                v0 = writeConfig$1.getBucketIndexEngineType();
                var17_14 = HoodieIndex.BucketIndexEngineType.CONSISTENT_HASHING;
                if (v0 != null ? v0.equals(var17_14) == false : var17_14 != null) break block8;
                v1 = new ConsistentBucketBulkInsertDataInternalWriterHelper(table$1, writeConfig$1, instantTime$2, Predef$.MODULE$.Integer2int(taskPartitionId), taskId, Predef$.MODULE$.Long2long(taskEpochId), schema$2, writeConfig$1.populateMetaFields(), arePartitionRecordsSorted$1, shouldPreserveHoodieMetadata$1);
                break block9;
            }
            if (!var14_11) ** GOTO lbl-1000
            v2 = writeConfig$1.getBucketIndexEngineType();
            var18_15 = HoodieIndex.BucketIndexEngineType.SIMPLE;
            if (!(v2 != null ? v2.equals(var18_15) == false : var18_15 != null)) {
                v1 = new BucketBulkInsertDataInternalWriterHelper(table$1, writeConfig$1, instantTime$2, Predef$.MODULE$.Integer2int(taskPartitionId), taskId, Predef$.MODULE$.Long2long(taskEpochId), schema$2, writeConfig$1.populateMetaFields(), arePartitionRecordsSorted$1, shouldPreserveHoodieMetadata$1);
            } else lbl-1000:
            // 2 sources

            {
                v1 = new BulkInsertDataInternalWriterHelper(table$1, writeConfig$1, instantTime$2, Predef$.MODULE$.Integer2int(taskPartitionId), taskId, Predef$.MODULE$.Long2long(taskEpochId), schema$2, writeConfig$1.populateMetaFields(), arePartitionRecordsSorted$1, shouldPreserveHoodieMetadata$1);
            }
        }
        writer = v1;
        try {
            try {
                iter.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$bulkInsert$2$adapted(org.apache.hudi.table.action.commit.BulkInsertDataInternalWriterHelper org.apache.spark.sql.catalyst.InternalRow ), (Lorg/apache/spark/sql/catalyst/InternalRow;)Ljava/lang/Object;)((BulkInsertDataInternalWriterHelper)writer));
            }
            catch (Throwable t) {
                writer.abort();
                throw t;
            }
        }
        finally {
            writer.close();
        }
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(writer.getWriteStatuses()).asScala()).iterator();
    }

    public static final /* synthetic */ boolean $anonfun$alignNotNullFields$1(Schema.Field f) {
        return !f.schema().isNullable();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionPathCols$1(String f) {
        return new StringOps(Predef$.MODULE$.augmentString(f)).contains((Object)BoxesRunTime.boxToCharacter((char)'.'));
    }

    private HoodieDatasetBulkInsertHelper$() {
        super(JFunction$.MODULE$.toJavaSerializableFunctionUnchecked(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(Dataset<Row> df) {
                return Predef$.MODULE$.int2Integer(HoodieUnsafeUtils$.MODULE$.getNumPartitions(df));
            }
        }));
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$bulkInsert$2$adapted(BulkInsertDataInternalWriterHelper writer$1, InternalRow row) {
        writer$1.write(row);
        return BoxedUnit.UNIT;
    }
}

