/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.ExecutorFactory;

public class SparkLazyInsertIterable<T>
extends HoodieLazyInsertIterable<T> {
    private final boolean useWriterSchema;

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        this(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, false, writeHandleFactory);
    }

    public SparkLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, boolean useWriterSchema, WriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, writeHandleFactory);
        this.useWriterSchema = useWriterSchema;
    }

    protected List<WriteStatus> computeNext() {
        HoodieExecutor bufferedIteratorExecutor = null;
        try {
            List result;
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getWriteSchema());
            if (this.useWriterSchema) {
                schema = HoodieAvroUtils.addMetadataFields((Schema)schema);
            }
            bufferedIteratorExecutor = ExecutorFactory.create((HoodieWriteConfig)this.hoodieConfig, (Iterator)this.inputItr, (HoodieConsumer)this.getInsertHandler(), (Function)this.getTransformer(schema, this.hoodieConfig), (Runnable)this.hoodieTable.getPreExecuteRunnable());
            List list = result = (List)bufferedIteratorExecutor.execute();
            return list;
        }
        catch (Exception e) {
            throw new HoodieException((Throwable)e);
        }
        finally {
            if (null != bufferedIteratorExecutor) {
                bufferedIteratorExecutor.shutdownNow();
                bufferedIteratorExecutor.awaitTermination();
            }
        }
    }
}

