/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class PartitionPathRepartitionPartitionerWithRows
implements BulkInsertPartitioner<Dataset<Row>> {
    private final boolean isTablePartitioned;
    private final boolean shouldPopulateMetaFields;

    public PartitionPathRepartitionPartitionerWithRows(boolean isTablePartitioned, HoodieWriteConfig config) {
        this.isTablePartitioned = isTablePartitioned;
        this.shouldPopulateMetaFields = config.populateMetaFields();
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> rows, int outputSparkPartitions) {
        if (!this.shouldPopulateMetaFields) {
            throw new HoodieException(BulkInsertSortMode.PARTITION_PATH_REPARTITION.name() + " mode requires meta-fields to be enabled");
        }
        if (this.isTablePartitioned) {
            return rows.repartition(outputSparkPartitions, new Column[]{new Column(HoodieRecord.PARTITION_PATH_METADATA_FIELD)});
        }
        return rows.coalesce(outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return false;
    }
}

