/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.expression;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.index.expression.HoodieExpressionIndex;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;

public class ExpressionIndexSparkFunctions {
    private static final String SPARK_DATE_FORMAT = "date_format";
    private static final String SPARK_DAY = "day";
    private static final String SPARK_MONTH = "month";
    private static final String SPARK_YEAR = "year";
    private static final String SPARK_HOUR = "hour";
    private static final String SPARK_FROM_UNIXTIME = "from_unixtime";
    private static final String SPARK_UNIX_TIMESTAMP = "unix_timestamp";
    private static final String SPARK_TO_DATE = "to_date";
    private static final String SPARK_TO_TIMESTAMP = "to_timestamp";
    private static final String SPARK_DATE_ADD = "date_add";
    private static final String SPARK_DATE_SUB = "date_sub";
    private static final String SPARK_SUBSTRING = "substring";
    private static final String SPARK_UPPER = "upper";
    private static final String SPARK_LOWER = "lower";
    private static final String SPARK_TRIM = "trim";
    private static final String SPARK_LTRIM = "ltrim";
    private static final String SPARK_RTRIM = "rtrim";
    private static final String SPARK_LENGTH = "length";
    private static final String SPARK_REGEXP_REPLACE = "regexp_replace";
    private static final String SPARK_REGEXP_EXTRACT = "regexp_extract";
    private static final String SPARK_SPLIT = "split";
    public static final String IDENTITY_FUNCTION = "identity";
    private static final Map<String, SparkFunction> SPARK_FUNCTION_MAP = new HashMap<String, SparkFunction>();

    static {
        SPARK_FUNCTION_MAP.put(IDENTITY_FUNCTION, new SparkIdentityFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_SPLIT, new SparkSplitFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_REGEXP_EXTRACT, new SparkRegexExtractFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_REGEXP_REPLACE, new SparkRegexReplaceFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_LENGTH, new SparkLengthFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_RTRIM, new SparkRTrimFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_LTRIM, new SparkLTrimFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_TRIM, new SparkTrimFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_LOWER, new SparkLowerFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_UPPER, new SparkUpperFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_SUBSTRING, new SparkSubstringFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_DATE_ADD, new SparkDateAddFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_DATE_SUB, new SparkDateSubFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_TO_TIMESTAMP, new SparkToTimestampFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_TO_DATE, new SparkToDateFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_UNIX_TIMESTAMP, new SparkUnixTimestampFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_FROM_UNIXTIME, new SparkFromUnixTimeFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_HOUR, new SparkHourFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_YEAR, new SparkYearFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_MONTH, new SparkMonthFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_DAY, new SparkDayFunction(){});
        SPARK_FUNCTION_MAP.put(SPARK_DATE_FORMAT, new SparkDateFormatFunction(){});
    }

    static interface SparkDateFormatFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_DATE_FORMAT;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "format"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("DATE_FORMAT requires 1 column");
            }
            if (!options.containsKey("format")) {
                throw new IllegalArgumentException("DATE_FORMAT requires format option");
            }
            return functions.date_format((Column)columns.get(0), (String)options.get("format"));
        }
    }

    static interface SparkDayFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_DAY;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("DAY requires 1 column");
            }
            return functions.dayofmonth((Column)columns.get(0));
        }
    }

    static interface SparkMonthFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_MONTH;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("MONTH requires 1 column");
            }
            return functions.month((Column)columns.get(0));
        }
    }

    static interface SparkYearFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_YEAR;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("YEAR requires 1 column");
            }
            return functions.year((Column)columns.get(0));
        }
    }

    static interface SparkHourFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_HOUR;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("HOUR requires 1 column");
            }
            return functions.hour((Column)columns.get(0));
        }
    }

    static interface SparkFromUnixTimeFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_FROM_UNIXTIME;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "format"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("FROM_UNIXTIME requires 1 column");
            }
            if (options.containsKey("format")) {
                return functions.from_unixtime((Column)columns.get(0), (String)options.get("format"));
            }
            return functions.from_unixtime((Column)columns.get(0));
        }
    }

    static interface SparkUnixTimestampFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_UNIX_TIMESTAMP;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "format"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("UNIX_TIMESTAMP requires 1 column");
            }
            if (options.containsKey("format")) {
                return functions.unix_timestamp((Column)columns.get(0), (String)options.get("format"));
            }
            return functions.unix_timestamp((Column)columns.get(0));
        }
    }

    static interface SparkToDateFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_TO_DATE;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "format"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("TO_DATE requires 1 column");
            }
            if (options.containsKey("format")) {
                return functions.to_date((Column)columns.get(0), (String)options.get("format"));
            }
            return functions.to_date((Column)columns.get(0));
        }
    }

    static interface SparkToTimestampFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_TO_TIMESTAMP;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "format"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("TO_TIMESTAMP requires 1 column");
            }
            if (options.containsKey("format")) {
                return functions.to_timestamp((Column)columns.get(0), (String)options.get("format"));
            }
            return functions.to_timestamp((Column)columns.get(0));
        }
    }

    static interface SparkDateSubFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_DATE_SUB;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "days"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("DATE_SUB requires 1 column");
            }
            return functions.date_sub((Column)columns.get(0), (int)Integer.parseInt(options.get("days")));
        }
    }

    static interface SparkDateAddFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_DATE_ADD;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "days"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("DATE_ADD requires 1 column");
            }
            return functions.date_add((Column)columns.get(0), (int)Integer.parseInt(options.get("days")));
        }
    }

    static interface SparkSubstringFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_SUBSTRING;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "pos", "len"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("SUBSTRING requires 1 column");
            }
            return functions.substring((Column)columns.get(0), (int)Integer.parseInt(options.get("pos")), (int)Integer.parseInt(options.get("len")));
        }
    }

    static interface SparkUpperFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_UPPER;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("UPPER requires 1 column");
            }
            return functions.upper((Column)columns.get(0));
        }
    }

    static interface SparkLowerFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_LOWER;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("LOWER requires 1 column");
            }
            return functions.lower((Column)columns.get(0));
        }
    }

    static interface SparkTrimFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_TRIM;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "trimString"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("TRIM requires 1 column");
            }
            if (options.containsKey("trimString")) {
                return functions.trim((Column)columns.get(0), (String)options.get("trimString"));
            }
            return functions.trim((Column)columns.get(0));
        }
    }

    static interface SparkLTrimFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_LTRIM;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "trimString"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("LTRIM requires 1 column");
            }
            if (options.containsKey("trimString")) {
                return functions.ltrim((Column)columns.get(0), (String)options.get("trimString"));
            }
            return functions.ltrim((Column)columns.get(0));
        }
    }

    static interface SparkRTrimFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_RTRIM;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "trimString"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("RTRIM requires 1 column");
            }
            if (options.containsKey("trimString")) {
                return functions.rtrim((Column)columns.get(0), (String)options.get("trimString"));
            }
            return functions.rtrim((Column)columns.get(0));
        }
    }

    static interface SparkLengthFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_LENGTH;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("LENGTH requires 1 column");
            }
            return functions.length((Column)columns.get(0));
        }
    }

    static interface SparkRegexReplaceFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_REGEXP_REPLACE;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "pattern", "replacement"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("REGEXP_REPLACE requires 1 column");
            }
            return functions.regexp_replace((Column)columns.get(0), (String)options.get("pattern"), (String)options.get("replacement"));
        }
    }

    static interface SparkRegexExtractFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_REGEXP_EXTRACT;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "pattern", "idx"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("REGEXP_EXTRACT requires 1 column");
            }
            return functions.regexp_extract((Column)columns.get(0), (String)options.get("pattern"), (int)Integer.parseInt(options.get("idx")));
        }
    }

    static interface SparkSplitFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.SPARK_SPLIT;
        }

        @Override
        default public Set<String> getValidOptions() {
            return new HashSet<String>(Arrays.asList("expr", "pattern"));
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("SPLIT requires 1 column");
            }
            return functions.split((Column)columns.get(0), (String)options.get("pattern"));
        }
    }

    static interface SparkIdentityFunction
    extends SparkFunction {
        @Override
        default public String getFunctionName() {
            return ExpressionIndexSparkFunctions.IDENTITY_FUNCTION;
        }

        @Override
        default public Set<String> getValidOptions() {
            return Collections.singleton("expr");
        }

        @Override
        default public Column apply(List<Column> columns, Map<String, String> options) {
            if (columns.size() != 1) {
                throw new IllegalArgumentException("IDENTITY requires 1 column");
            }
            return columns.get(0);
        }
    }

    static interface SparkFunction
    extends Serializable {
        public String getFunctionName();

        public Set<String> getValidOptions();

        public Column apply(List<Column> var1, Map<String, String> var2);

        default public void validateOptions(Map<String, String> options, String indexType) {
            HashSet<String> validOptions = new HashSet<String>(this.getValidOptions());
            if (indexType.equals("bloom_filters")) {
                validOptions.addAll(HoodieExpressionIndex.BLOOM_FILTER_CONFIG_MAPPING.keySet());
            }
            HashSet<String> invalidOptions = new HashSet<String>(options.keySet());
            invalidOptions.removeAll(validOptions);
            ValidationUtils.checkArgument((boolean)invalidOptions.isEmpty(), (String)String.format("Input options %s are not valid for spark function %s", invalidOptions, this));
        }

        public static SparkFunction getSparkFunction(String functionName) {
            return (SparkFunction)SPARK_FUNCTION_MAP.get(functionName);
        }
    }
}

