/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class HoodieRowParquetWriteSupport
extends ParquetWriteSupport {
    private final Configuration hadoopConf;
    private final Option<HoodieBloomFilterWriteSupport<UTF8String>> bloomFilterWriteSupportOpt;

    public HoodieRowParquetWriteSupport(Configuration conf, StructType structType, Option<BloomFilter> bloomFilterOpt, HoodieConfig config) {
        Configuration hadoopConf = new Configuration(conf);
        hadoopConf.set("spark.sql.parquet.writeLegacyFormat", config.getStringOrDefault(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED, "false"));
        hadoopConf.set("spark.sql.parquet.outputTimestampType", config.getStringOrDefault(HoodieStorageConfig.PARQUET_OUTPUT_TIMESTAMP_TYPE));
        hadoopConf.set("spark.sql.parquet.fieldId.write.enabled", config.getStringOrDefault(HoodieStorageConfig.PARQUET_FIELD_ID_WRITE_ENABLED));
        HoodieRowParquetWriteSupport.setSchema((StructType)structType, (Configuration)hadoopConf);
        this.hadoopConf = hadoopConf;
        this.bloomFilterWriteSupportOpt = bloomFilterOpt.map(HoodieBloomFilterRowWriteSupport::new);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Map extraMetadata = (Map)this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap());
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(UTF8String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey((Comparable)recordKey));
    }

    public static HoodieRowParquetWriteSupport getHoodieRowParquetWriteSupport(Configuration conf, StructType structType, Option<BloomFilter> bloomFilterOpt, HoodieConfig config) {
        return (HoodieRowParquetWriteSupport)((Object)ReflectionUtils.loadClass((String)config.getStringOrDefault(HoodieStorageConfig.HOODIE_PARQUET_SPARK_ROW_WRITE_SUPPORT_CLASS), (Class[])new Class[]{Configuration.class, StructType.class, Option.class, HoodieConfig.class}, (Object[])new Object[]{conf, structType, bloomFilterOpt, config}));
    }

    private static class HoodieBloomFilterRowWriteSupport
    extends HoodieBloomFilterWriteSupport<UTF8String> {
        public HoodieBloomFilterRowWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        protected byte[] getUTF8Bytes(UTF8String key) {
            return key.getBytes();
        }

        protected UTF8String dereference(UTF8String key) {
            return key.clone();
        }
    }
}

