/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.SimpleAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class SimpleKeyGenerator
extends BuiltinKeyGenerator {
    private final SimpleAvroKeyGenerator simpleAvroKeyGenerator;

    public SimpleKeyGenerator(TypedProperties props) {
        this(props, (Option<String>)Option.ofNullable((Object)props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)), props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    SimpleKeyGenerator(TypedProperties props, String partitionPathField) {
        this(props, (Option<String>)Option.empty(), partitionPathField);
    }

    SimpleKeyGenerator(TypedProperties props, Option<String> recordKeyField, String partitionPathField) {
        super(props);
        this.validateRecordKey(recordKeyField);
        SimpleKeyGenerator.validatePartitionPath(partitionPathField);
        this.recordKeyFields = !recordKeyField.isPresent() ? Collections.emptyList() : Collections.singletonList(recordKeyField.get());
        this.partitionPathFields = partitionPathField == null ? Collections.emptyList() : Collections.singletonList(partitionPathField);
        this.simpleAvroKeyGenerator = new SimpleAvroKeyGenerator(props, recordKeyField, partitionPathField);
    }

    public String getRecordKey(GenericRecord record) {
        return this.simpleAvroKeyGenerator.getRecordKey(record);
    }

    public String getPartitionPath(GenericRecord record) {
        return this.simpleAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.tryInitRowAccessor(row.schema());
        Object[] recordKeys = this.rowAccessor.getRecordKeyParts(row);
        if (recordKeys[0] == null) {
            return SimpleKeyGenerator.handleNullRecordKey(null);
        }
        return SimpleKeyGenerator.requireNonNullNonEmptyKey(recordKeys[0].toString());
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        this.tryInitRowAccessor(schema);
        Object[] recordKeyValues = this.rowAccessor.getRecordKeyParts(internalRow);
        if (recordKeyValues[0] == null) {
            return SimpleKeyGenerator.handleNullRecordKey(null);
        }
        if (recordKeyValues[0] instanceof UTF8String) {
            return SimpleKeyGenerator.requireNonNullNonEmptyKey((UTF8String)recordKeyValues[0]);
        }
        return SimpleKeyGenerator.requireNonNullNonEmptyKey(UTF8String.fromString((String)recordKeyValues[0].toString()));
    }

    @Override
    public String getPartitionPath(Row row) {
        this.tryInitRowAccessor(row.schema());
        return this.combinePartitionPath(this.rowAccessor.getRecordPartitionPathValues(row));
    }

    @Override
    public UTF8String getPartitionPath(InternalRow row, StructType schema) {
        this.tryInitRowAccessor(schema);
        return this.combinePartitionPathUnsafe(this.rowAccessor.getRecordPartitionPathValues(row));
    }

    private static void validatePartitionPath(String partitionPathField) {
        ValidationUtils.checkArgument((partitionPathField == null || !partitionPathField.isEmpty() ? 1 : 0) != 0, (String)"Partition-path field has to be non-empty!");
        ValidationUtils.checkArgument((partitionPathField == null || !partitionPathField.contains(",") ? 1 : 0) != 0, (String)String.format("Single partition-path field is expected; provided (%s)", partitionPathField));
    }

    private void validateRecordKey(Option<String> recordKeyField) {
        ValidationUtils.checkArgument((!recordKeyField.isPresent() || !((String)recordKeyField.get()).isEmpty() ? 1 : 0) != 0, (String)"Record key field has to be non-empty!");
        ValidationUtils.checkArgument((!recordKeyField.isPresent() || !((String)recordKeyField.get()).contains(",") ? 1 : 0) != 0, (String)String.format("Single record-key field is expected; provided (%s)", recordKeyField));
    }
}

