/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkRowSerDe;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.spark.sql.avro.HoodieAvroSerializer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static AvroConversionUtils$ MODULE$;
    private final ConcurrentHashMap<Tuple3<StructType, Schema, Object>, Function1<InternalRow, GenericRecord>> ROW_TO_AVRO_CONVERTER_CACHE;
    private final ConcurrentHashMap<Schema, StructType> AVRO_SCHEMA_CACHE;

    static {
        new AvroConversionUtils$();
    }

    private ConcurrentHashMap<Tuple3<StructType, Schema, Object>, Function1<InternalRow, GenericRecord>> ROW_TO_AVRO_CONVERTER_CACHE() {
        return this.ROW_TO_AVRO_CONVERTER_CACHE;
    }

    private ConcurrentHashMap<Schema, StructType> AVRO_SCHEMA_CACHE() {
        return this.AVRO_SCHEMA_CACHE;
    }

    public Function1<GenericRecord, Option<InternalRow>> createAvroToInternalRowConverter(Schema rootAvroType, StructType rootCatalystType) {
        HoodieAvroDeserializer deserializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(rootAvroType, (DataType)rootCatalystType);
        return (Function1 & Serializable & scala.Serializable)record -> deserializer.deserialize(record).map((Function1 & Serializable & scala.Serializable)x$1 -> (InternalRow)x$1);
    }

    public Function1<InternalRow, GenericRecord> createInternalRowToAvroConverter(StructType rootCatalystType, Schema rootAvroType, boolean nullable) {
        Function<Tuple3, Function1> loader = key -> {
            HoodieAvroSerializer serializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroSerializer((DataType)key._1(), (Schema)key._2(), BoxesRunTime.unboxToBoolean((Object)key._3()));
            return (Function1 & Serializable & scala.Serializable)row -> {
                GenericRecord genericRecord;
                try {
                    genericRecord = (GenericRecord)serializer.serialize(row);
                }
                catch (HoodieSchemaException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new SchemaCompatibilityException("Failed to convert spark record into avro record", e);
                }
                return genericRecord;
            };
        };
        return this.ROW_TO_AVRO_CONVERTER_CACHE().computeIfAbsent((Tuple3<StructType, Schema, Object>)new Tuple3((Object)rootCatalystType, (Object)rootAvroType, (Object)BoxesRunTime.boxToBoolean((boolean)nullable)), loader);
    }

    @Deprecated
    public Function1<GenericRecord, Row> createConverterToRow(Schema sourceAvroSchema, StructType targetSqlType) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.getCatalystRowSerDe(targetSqlType);
        Function1<GenericRecord, Option<InternalRow>> converter = this.createAvroToInternalRowConverter(sourceAvroSchema, targetSqlType);
        return (Function1 & Serializable & scala.Serializable)avro -> (Row)((Option)converter.apply(avro)).map((Function1 & Serializable & scala.Serializable)internalRow -> serde.deserializeRow((InternalRow)internalRow)).get();
    }

    @Deprecated
    public Function1<Row, GenericRecord> createConverterToAvro(StructType sourceSqlType, String structName, String recordNamespace) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.getCatalystRowSerDe(sourceSqlType);
        Schema avroSchema = this.convertStructTypeToAvroSchema((DataType)sourceSqlType, structName, recordNamespace);
        Schema schema = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)avroSchema);
        Schema schema2 = avroSchema;
        boolean nullable = schema == null ? schema2 != null : !schema.equals(schema2);
        Function1<InternalRow, GenericRecord> converter = this.createInternalRowToAvroConverter(sourceSqlType, avroSchema, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)converter.apply((Object)serde.serializeRow((Row)row));
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return ss.createDataFrame(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)records -> {
            if (records.isEmpty()) {
                return package$.MODULE$.Iterator().empty();
            }
            Schema schema = new Schema.Parser().parse(schemaStr);
            StructType dataType = MODULE$.convertAvroSchemaToStructType(schema);
            Function1<GenericRecord, Row> converter = MODULE$.createConverterToRow(schema, dataType);
            return records.map((Function1 & Serializable & scala.Serializable)r -> (Row)converter.apply(r));
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String qualifiedName) {
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        Tuple2 tuple2 = new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).init())).mkString("."), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)namespace, (Object)name);
        String namespace2 = (String)tuple22._1();
        String name2 = (String)tuple22._2();
        return this.convertStructTypeToAvroSchema(structType, name2, namespace2);
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String structName, String recordNamespace) {
        Schema schema;
        try {
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Schema avroSchema = schemaConverters.toAvroType(structType, false, structName, recordNamespace);
            schema = this.getAvroSchemaWithDefaults(avroSchema, structType);
        }
        catch (AvroRuntimeException a) {
            throw new HoodieSchemaException(a.getMessage(), (Throwable)a);
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert struct type to avro schema: ").append(structType).toString(), (Throwable)e);
        }
        return schema;
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        Function<Schema, StructType> loader = key -> {
            StructType structType;
            try {
                HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
                Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType((Schema)key);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                DataType dataType = (DataType)tuple2._1();
                structType = (StructType)dataType;
            }
            catch (Exception e) {
                throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert avro schema to struct type: ").append(avroSchema).toString(), (Throwable)e);
            }
            return structType;
        };
        return this.AVRO_SCHEMA_CACHE().computeIfAbsent(avroSchema, loader);
    }

    public DataType convertAvroSchemaToDataType(Schema avroSchema) {
        DataType dataType;
        try {
            DataType dataType2;
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType(avroSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            dataType = dataType2 = (DataType)tuple2._1();
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(43).append("Failed to convert avro schema to DataType: ").append(avroSchema).toString(), (Throwable)e);
        }
        return dataType;
    }

    public Schema getAvroSchemaWithDefaults(Schema schema, DataType dataType) {
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            StructType structType = (StructType)dataType;
            StructField[] structFields = structType.fields();
            java.util.List modifiedFields = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
                Tuple2 tuple2;
                int i = structType.fieldIndex(field.name());
                String comment = structFields[i].metadata().contains("comment") ? structFields[i].metadata().getString("comment") : field.doc();
                Schema.Type type = field.schema().getType();
                Tuple2 tuple22 = tuple2 = Schema.Type.UNION.equals(type) ? MODULE$.resolveUnion(field.schema(), structFields[i].dataType()) : new Tuple2((Object)MODULE$.getAvroSchemaWithDefaults(field.schema(), structFields[i].dataType()), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Schema newSchema = (Schema)tuple2._1();
                boolean containsNullSchema = tuple2._2$mcZ$sp();
                Tuple2 tuple23 = new Tuple2((Object)newSchema, (Object)BoxesRunTime.boxToBoolean((boolean)containsNullSchema));
                Schema newSchema2 = (Schema)tuple23._1();
                boolean containsNullSchema2 = tuple23._2$mcZ$sp();
                return HoodieAvroUtils.createNewSchemaField((String)field.name(), (Schema)newSchema2, (String)comment, (Object)(containsNullSchema2 ? JsonProperties.NULL_VALUE : field.defaultVal()));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
            return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (java.util.List)modifiedFields);
        }
        if (Schema.Type.UNION.equals(type)) {
            Tuple2<Schema, Object> tuple2 = this.resolveUnion(schema, dataType);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema resolved = (Schema)tuple2._1();
            Schema resolved2 = resolved;
            return resolved2;
        }
        if (Schema.Type.MAP.equals(type)) {
            return Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema.getValueType(), ((MapType)dataType).valueType()));
        }
        if (Schema.Type.ARRAY.equals(type)) {
            return Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema.getElementType(), ((ArrayType)dataType).elementType()));
        }
        return schema;
    }

    private Tuple2<Schema, Object> resolveUnion(Schema schema2, DataType dataType) {
        Buffer innerFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala();
        boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)innerFields.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(nullFieldEncountered, schema) -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$resolveUnion$1(BoxesRunTime.unboxToBoolean((Object)nullFieldEncountered), schema))));
        return new Tuple2((Object)(containsNullSchema ? Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)((TraversableLike)innerFields.filter((Function1 & Serializable & scala.Serializable)innerSchema -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$resolveUnion$2(innerSchema)))).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).asJava())) : Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom())).asJava()))), (Object)BoxesRunTime.boxToBoolean((boolean)containsNullSchema));
    }

    @Deprecated
    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String qualifiedName = AvroSchemaUtils.getAvroRecordQualifiedName((String)tableName);
        String[] nameParts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).last(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).init())).mkString("."));
    }

    private Schema handleUnion(Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Schema.Type type3 = ((Schema)schema.getTypes().get(0)).getType();
            Schema.Type type4 = Schema.Type.NULL;
            int index = !(type3 != null ? !type3.equals(type4) : type4 != null) ? 1 : 0;
            return (Schema)schema.getTypes().get(index);
        }
        return schema;
    }

    public StructType alignFieldsNullability(StructType sourceSchema, Schema avroSchema) {
        Map avroFieldsMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        StructField[] alignedFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Option option = avroFieldsMap.get((Object)field.name());
            if (option instanceof Some) {
                Some some = (Some)option;
                Schema.Field avroField = (Schema.Field)some.value();
                boolean x$1 = avroField.schema().isNullable();
                String x$2 = field.copy$default$1();
                DataType x$3 = field.copy$default$2();
                Metadata x$4 = field.copy$default$4();
                StructField alignedField = field.copy(x$2, x$3, x$1, x$4);
                DataType dataType = field.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    Schema nestedAvroSchema = MODULE$.unwrapNullableSchema(avroField.schema());
                    Schema.Type type = nestedAvroSchema.getType();
                    Schema.Type type2 = Schema.Type.RECORD;
                    if (!(type != null ? !type.equals(type2) : type2 != null)) {
                        StructType x$5 = MODULE$.alignFieldsNullability(structType, nestedAvroSchema);
                        String x$6 = alignedField.copy$default$1();
                        boolean x$7 = alignedField.copy$default$3();
                        Metadata x$8 = alignedField.copy$default$4();
                        return alignedField.copy(x$6, (DataType)x$5, x$7, x$8);
                    }
                    return alignedField;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    Schema arraySchema = MODULE$.unwrapNullableSchema(avroField.schema());
                    Schema.Type type = arraySchema.getType();
                    Schema.Type type3 = Schema.Type.ARRAY;
                    if (!(type != null ? !type.equals(type3) : type3 != null)) {
                        Schema elemSchema = arraySchema.getElementType();
                        DataType newElementType = MODULE$.updateElementType(elementType, elemSchema);
                        ArrayType x$9 = new ArrayType(newElementType, elemSchema.isNullable());
                        String x$10 = alignedField.copy$default$1();
                        boolean x$11 = alignedField.copy$default$3();
                        Metadata x$12 = alignedField.copy$default$4();
                        return alignedField.copy(x$10, (DataType)x$9, x$11, x$12);
                    }
                    return alignedField;
                }
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    Schema mapSchema = MODULE$.unwrapNullableSchema(avroField.schema());
                    Schema.Type type = mapSchema.getType();
                    Schema.Type type4 = Schema.Type.MAP;
                    if (!(type != null ? !type.equals(type4) : type4 != null)) {
                        Schema valueSchema = mapSchema.getValueType();
                        DataType newValueType = MODULE$.updateElementType(valueType, valueSchema);
                        MapType x$13 = new MapType(keyType, newValueType, valueSchema.isNullable());
                        String x$14 = alignedField.copy$default$1();
                        boolean x$15 = alignedField.copy$default$3();
                        Metadata x$16 = alignedField.copy$default$4();
                        return alignedField.copy(x$14, (DataType)x$13, x$15, x$16);
                    }
                    return alignedField;
                }
                return alignedField;
            }
            if (None$.MODULE$.equals(option)) {
                return field.copy(field.copy$default$1(), field.copy$default$2(), field.copy$default$3(), field.copy$default$4());
            }
            throw new MatchError((Object)option);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(alignedFields);
    }

    private Schema unwrapNullableSchema(Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Buffer types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala();
            Buffer nonNullTypes = (Buffer)types.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$unwrapNullableSchema$1(x$4)));
            if (nonNullTypes.size() == 1) {
                return (Schema)nonNullTypes.head();
            }
            return schema;
        }
        return schema;
    }

    private DataType updateElementType(DataType dataType, Schema avroSchema) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            Schema.Type type = avroSchema.getType();
            Schema.Type type2 = Schema.Type.RECORD;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                return this.alignFieldsNullability(structType, avroSchema);
            }
            return structType;
        }
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elemType = arrayType.elementType();
            Schema.Type type = avroSchema.getType();
            Schema.Type type3 = Schema.Type.ARRAY;
            if (!(type != null ? !type.equals(type3) : type3 != null)) {
                Schema elemSchema = avroSchema.getElementType();
                return new ArrayType(this.updateElementType(elemType, elemSchema), elemSchema.isNullable());
            }
            return dataType;
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            Schema.Type type = avroSchema.getType();
            Schema.Type type4 = Schema.Type.MAP;
            if (!(type != null ? !type.equals(type4) : type4 != null)) {
                Schema valueSchema = avroSchema.getValueType();
                return new MapType(keyType, this.updateElementType(valueType, valueSchema), valueSchema.isNullable());
            }
            return dataType;
        }
        return dataType;
    }

    public static final /* synthetic */ boolean $anonfun$resolveUnion$1(boolean nullFieldEncountered, Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return nullFieldEncountered | !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$resolveUnion$2(Schema innerSchema) {
        Schema.Type type = innerSchema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public static final /* synthetic */ boolean $anonfun$unwrapNullableSchema$1(Schema x$4) {
        Schema.Type type = x$4.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
        this.ROW_TO_AVRO_CONVERTER_CACHE = new ConcurrentHashMap();
        this.AVRO_SCHEMA_CACHE = new ConcurrentHashMap();
    }
}

