/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.avro.Schema;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.DefaultJavaTypeConverter;
import org.apache.hudi.common.util.JavaTypeConverter;
import org.apache.hudi.util.OrderingValueEngineTypeConverter;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;

public abstract class BaseSparkInternalRecordContext
extends RecordContext<InternalRow> {
    private OrderingValueEngineTypeConverter orderingValueConverter;

    protected BaseSparkInternalRecordContext(HoodieTableConfig tableConfig) {
        super(tableConfig, (JavaTypeConverter)new DefaultJavaTypeConverter());
    }

    protected BaseSparkInternalRecordContext() {
        super((JavaTypeConverter)new DefaultJavaTypeConverter());
    }

    public static Object getFieldValueFromInternalRow(InternalRow row, Schema recordSchema, String fieldName) {
        return BaseSparkInternalRecordContext.getFieldValueFromInternalRowInternal(row, recordSchema, fieldName, false);
    }

    public static Object getFieldValueFromInternalRowAsJava(InternalRow row, Schema recordSchema, String fieldName) {
        return BaseSparkInternalRecordContext.getFieldValueFromInternalRowInternal(row, recordSchema, fieldName, true);
    }

    private static Object getFieldValueFromInternalRowInternal(InternalRow row, Schema recordSchema, String fieldName, boolean convertToJavaType) {
        StructType structType = HoodieInternalRowUtils.getCachedSchema(recordSchema);
        Option<HoodieUnsafeRowUtils.NestedFieldPath> cachedNestedFieldPath = HoodieInternalRowUtils.getCachedPosList(structType, fieldName);
        if (cachedNestedFieldPath.isDefined()) {
            HoodieUnsafeRowUtils.NestedFieldPath nestedFieldPath = (HoodieUnsafeRowUtils.NestedFieldPath)cachedNestedFieldPath.get();
            Object value = HoodieUnsafeRowUtils.getNestedInternalRowValue(row, nestedFieldPath);
            return convertToJavaType ? BaseSparkInternalRecordContext.sparkTypeToJavaType(value) : value;
        }
        return null;
    }

    private static Object sparkTypeToJavaType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof UTF8String) {
            return ((UTF8String)value).toString();
        }
        if (value instanceof Decimal) {
            return ((Decimal)value).toJavaBigDecimal();
        }
        if (value instanceof byte[]) {
            return ByteBuffer.wrap((byte[])value);
        }
        if (value instanceof CalendarInterval || value instanceof InternalRow || value instanceof MapData || value instanceof ArrayData) {
            throw new UnsupportedOperationException(String.format("Unsupported value type (%s)", value.getClass().getName()));
        }
        return value;
    }

    public Object getValue(InternalRow row, Schema schema, String fieldName) {
        return BaseSparkInternalRecordContext.getFieldValueFromInternalRow(row, schema, fieldName);
    }

    public String getMetaFieldValue(InternalRow record, int pos) {
        return record.getString(pos);
    }

    public HoodieRecord<InternalRow> constructHoodieRecord(BufferedRecord<InternalRow> bufferedRecord, String partitionPath) {
        HoodieKey hoodieKey = new HoodieKey(bufferedRecord.getRecordKey(), partitionPath);
        if (bufferedRecord.isDelete()) {
            return new HoodieEmptyRecord(hoodieKey, bufferedRecord.getHoodieOperation(), bufferedRecord.getOrderingValue(), HoodieRecord.HoodieRecordType.SPARK);
        }
        Schema schema = this.getSchemaFromBufferRecord(bufferedRecord);
        InternalRow row = (InternalRow)bufferedRecord.getRecord();
        return new HoodieSparkRecord(hoodieKey, row, HoodieInternalRowUtils.getCachedSchema(schema), false, bufferedRecord.getHoodieOperation(), bufferedRecord.getOrderingValue(), bufferedRecord.isDelete());
    }

    public InternalRow constructEngineRecord(Schema recordSchema, Object[] fieldValues) {
        return new GenericInternalRow(fieldValues);
    }

    public InternalRow mergeWithEngineRecord(Schema schema, Map<Integer, Object> updateValues, BufferedRecord<InternalRow> baseRecord) {
        List fields = schema.getFields();
        Object[] values = new Object[fields.size()];
        for (Schema.Field field : fields) {
            int pos = field.pos();
            if (updateValues.containsKey(pos)) {
                values[pos] = updateValues.get(pos);
                continue;
            }
            values[pos] = this.getValue((InternalRow)baseRecord.getRecord(), schema, field.name());
        }
        return new GenericInternalRow(values);
    }

    public Comparable convertValueToEngineType(Comparable value) {
        if (value instanceof String) {
            return SparkAdapterSupport$.MODULE$.sparkAdapter().getUTF8StringFactory().wrapUTF8String(UTF8String.fromString((String)((String)((Object)value))));
        }
        return value;
    }

    public Comparable convertOrderingValueToEngineType(Comparable value) {
        return this.orderingValueConverter.convert(value);
    }

    protected Comparable ensureComparability(Object value) {
        if (value instanceof UTF8String) {
            return SparkAdapterSupport$.MODULE$.sparkAdapter().getUTF8StringFactory().wrapUTF8String((UTF8String)value);
        }
        return (Comparable)value;
    }

    public Comparable convertPartitionValueToEngineType(Comparable value) {
        if (value instanceof String) {
            return UTF8String.fromString((String)((String)((Object)value)));
        }
        return value;
    }

    public InternalRow getDeleteRow(String recordKey) {
        UTF8String[] metaFields = new UTF8String[]{null, null, UTF8String.fromString((String)recordKey), UTF8String.fromString((String)this.partitionPath), null};
        return SparkAdapterSupport$.MODULE$.sparkAdapter().createInternalRow(metaFields, null, false);
    }

    public InternalRow seal(InternalRow internalRow) {
        return internalRow.copy();
    }

    public InternalRow toBinaryRow(Schema schema, InternalRow internalRow) {
        if (internalRow instanceof UnsafeRow) {
            return internalRow;
        }
        UnsafeProjection unsafeProjection = HoodieInternalRowUtils.getCachedUnsafeProjection(schema);
        return unsafeProjection.apply(internalRow);
    }

    public UnaryOperator<InternalRow> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        Function1<InternalRow, UnsafeRow> unsafeRowWriter = HoodieInternalRowUtils.getCachedUnsafeRowWriter(HoodieInternalRowUtils.getCachedSchema(from), HoodieInternalRowUtils.getCachedSchema(to), renamedColumns, Collections.emptyMap());
        return row -> (InternalRow)unsafeRowWriter.apply(row);
    }

    void initOrderingValueConverter(Schema dataSchema, List<String> orderingFieldNames) {
        this.orderingValueConverter = OrderingValueEngineTypeConverter.create(dataSchema, orderingFieldNames);
    }
}

