/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.BaseSparkInternalRecordContext;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.OverwriteWithLatestSparkRecordMerger;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import scala.Function1;

public abstract class BaseSparkInternalRowReaderContext
extends HoodieReaderContext<InternalRow> {
    protected BaseSparkInternalRowReaderContext(StorageConfiguration<?> storageConfig, HoodieTableConfig tableConfig, BaseSparkInternalRecordContext recordContext) {
        super(storageConfig, tableConfig, Option.empty(), Option.empty(), (RecordContext)recordContext);
    }

    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return Option.of((Object)new DefaultSparkRecordMerger());
            }
            case COMMIT_TIME_ORDERING: {
                return Option.of((Object)new OverwriteWithLatestSparkRecordMerger());
            }
        }
        Option recordMerger = HoodieRecordUtils.createValidRecordMerger((EngineType)EngineType.SPARK, (String)mergeImplClasses, (String)mergeStrategyId);
        if (recordMerger.isEmpty()) {
            throw new IllegalArgumentException("No valid spark merger implementation set for `hoodie.write.record.merge.custom.implementation.classes`");
        }
        return recordMerger;
    }

    protected UnaryOperator<InternalRow> getBootstrapProjection(Schema from, Schema to, List<Pair<String, Object>> partitionFieldAndValues) {
        Map<Integer, Object> partitionValuesByIndex = partitionFieldAndValues.stream().collect(Collectors.toMap(pair -> to.getField((String)pair.getKey()).pos(), Pair::getRight));
        Function1<InternalRow, UnsafeRow> unsafeRowWriter = HoodieInternalRowUtils.getCachedUnsafeRowWriter(HoodieInternalRowUtils.getCachedSchema(from), HoodieInternalRowUtils.getCachedSchema(to), Collections.emptyMap(), partitionValuesByIndex);
        return row -> (InternalRow)unsafeRowWriter.apply(row);
    }

    public void setSchemaHandler(FileGroupReaderSchemaHandler<InternalRow> schemaHandler) {
        super.setSchemaHandler(schemaHandler);
        List orderingFieldNames = HoodieRecordUtils.getOrderingFieldNames((RecordMergeMode)this.getMergeMode(), (HoodieTableConfig)this.tableConfig);
        Schema schema = schemaHandler.getRequiredSchema();
        ((BaseSparkInternalRecordContext)this.recordContext).initOrderingValueConverter(schema, orderingFieldNames);
    }
}

