/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieSparkRecordMerger;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.merge.SparkRecordMergingUtils;

public class DefaultSparkRecordMerger
extends HoodieSparkRecordMerger {
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    public <T> BufferedRecord<T> merge(BufferedRecord<T> older, BufferedRecord<T> newer, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        if (HoodieRecordMerger.isCommitTimeOrderingDelete(older, newer)) {
            return newer;
        }
        if (older.getOrderingValue().compareTo(newer.getOrderingValue()) > 0) {
            return older;
        }
        return newer;
    }

    public <T> BufferedRecord<T> partialMerge(BufferedRecord<T> older, BufferedRecord<T> newer, Schema readerSchema, RecordContext<T> recordContext, TypedProperties props) throws IOException {
        if (HoodieRecordMerger.isCommitTimeOrderingDelete(older, newer)) {
            return newer;
        }
        if (older.getOrderingValue().compareTo(newer.getOrderingValue()) > 0) {
            if (older.isDelete() || newer.isDelete()) {
                return older;
            }
            Schema oldSchema = recordContext.getSchemaFromBufferRecord(older);
            Schema newSchema = recordContext.getSchemaFromBufferRecord(newer);
            return SparkRecordMergingUtils.mergePartialRecords(newer, newSchema, older, oldSchema, readerSchema, recordContext);
        }
        if (newer.isDelete() || older.isDelete()) {
            return newer;
        }
        Schema oldSchema = recordContext.getSchemaFromBufferRecord(older);
        Schema newSchema = recordContext.getSchemaFromBufferRecord(newer);
        return SparkRecordMergingUtils.mergePartialRecords(older, oldSchema, newer, newSchema, readerSchema, recordContext);
    }
}

