/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hudi.client.BaseClusterer;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.Option;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkClusteringClient<T>
extends BaseClusterer<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkClusteringClient.class);

    public HoodieSparkClusteringClient(BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> clusteringClient) {
        super(clusteringClient);
    }

    public void cluster(String instantTime) throws IOException {
        LOG.info("Executing clustering instance {}", (Object)instantTime);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.clusteringClient;
        Option commitMetadata = writeClient.cluster(instantTime).getCommitMetadata();
        Stream hoodieWriteStatStream = ((HoodieCommitMetadata)commitMetadata.get()).getPartitionToWriteStats().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream());
        long errorsCount = hoodieWriteStatStream.mapToLong(HoodieWriteStat::getTotalWriteErrors).sum();
        if (errorsCount > 0L) {
            LOG.error("Clustering for instant ({}) failed with write errors", (Object)instantTime);
        }
    }
}

