/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import org.apache.hudi.client.BaseCompactor;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieSparkCompactor<T>
extends BaseCompactor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkCompactor.class);
    private final transient HoodieEngineContext context;

    public HoodieSparkCompactor(BaseHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> compactionClient, HoodieEngineContext context) {
        super(compactionClient);
        this.context = context;
    }

    public void compact(String instantTime) {
        LOG.info("Compactor executing compaction {}", (Object)instantTime);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.compactionClient;
        HoodieWriteMetadata compactionMetadata = writeClient.compact(instantTime);
        writeClient.commitCompaction(instantTime, compactionMetadata, Option.empty());
    }
}

