/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.hudi.callback.common.WriteStatusValidator;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.table.HoodieSparkMergeOnReadMetadataTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRDDMetadataWriteClient<T>
extends SparkRDDWriteClient<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRDDMetadataWriteClient.class);
    private Option<String> firstInstantOpt = Option.empty();
    private int invocationCounts = 0;

    public SparkRDDMetadataWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        super(context, clientConfig);
    }

    public SparkRDDMetadataWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService);
    }

    @Override
    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc, Option<WriteStatusValidator> writeStatusValidatorOpt) {
        this.context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Committing stats: " + this.config.getTableName());
        ValidationUtils.checkArgument((!writeStatusValidatorOpt.isPresent() ? 1 : 0) != 0, (String)"Metadata table is not expected to contain write status validator");
        List hoodieWriteStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, hoodieWriteStats, extraMetadata, commitActionType, partitionToReplacedFileIds, extraPreCommitFunc);
    }

    public JavaRDD<WriteStatus> firstUpsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, List<HoodieFileGroupId> hoodieFileGroupIdList) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable((Object)instantTime));
        ValidationUtils.checkState((boolean)this.firstInstantOpt.isEmpty(), (String)"Upsert Prepped should be invoked for the first time");
        ++this.invocationCounts;
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        this.firstInstantOpt = Option.of((Object)instantTime);
        HoodieWriteMetadata<HoodieData<WriteStatus>> result = ((HoodieSparkMergeOnReadMetadataTable)table).upsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords), hoodieFileGroupIdList);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }

    public JavaRDD<WriteStatus> secondaryUpsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable((Object)instantTime));
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        boolean initialCall = this.firstInstantOpt.isEmpty();
        if (initialCall) {
            this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
            this.firstInstantOpt = Option.of((Object)instantTime);
        } else {
            ValidationUtils.checkArgument((boolean)((String)this.firstInstantOpt.get()).equals(instantTime), (String)("Upsert Prepped invoked for metadata table using same write client instance  for two different instant times " + (String)this.firstInstantOpt.get() + " and " + instantTime));
        }
        ValidationUtils.checkArgument((this.invocationCounts <= 2 ? 1 : 0) != 0, (String)("Upsert Prepped invoked more then twice for the same instant time with metadata write client " + (String)this.firstInstantOpt.get()));
        HoodieWriteMetadata<HoodieData<WriteStatus>> result = ((HoodieSparkMergeOnReadMetadataTable)table).upsertPrepped(this.context, instantTime, HoodieJavaRDD.of(preppedRecords), initialCall);
        HoodieWriteMetadata resultRDD = result.clone(HoodieJavaRDD.getJavaRDD((HoodieData)result.getWriteStatuses()));
        return (JavaRDD)this.postWrite(resultRDD, instantTime, table);
    }
}

