/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.StreamingMetadataWriteHandler;
import org.apache.hudi.client.TableWriteStats;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.SparkReleaseResources;
import org.apache.hudi.client.utils.SparkValidatorUtils;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;

public class SparkRDDTableServiceClient<T>
extends BaseHoodieTableServiceClient<HoodieData<HoodieRecord<T>>, HoodieData<WriteStatus>, JavaRDD<WriteStatus>> {
    private final StreamingMetadataWriteHandler streamingMetadataWriteHandler;

    protected SparkRDDTableServiceClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineService) {
        this(context, clientConfig, timelineService, new StreamingMetadataWriteHandler());
    }

    @VisibleForTesting
    public SparkRDDTableServiceClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineService, StreamingMetadataWriteHandler streamingMetadataWriteHandler) {
        super(context, clientConfig, timelineService);
        this.streamingMetadataWriteHandler = streamingMetadataWriteHandler;
    }

    protected TableWriteStats triggerWritesAndFetchWriteStats(HoodieWriteMetadata<JavaRDD<WriteStatus>> tableServiceWriteMetadata) {
        List<SparkRDDWriteClient.SlimWriteStats> writeStatusMetadataTrackerList = SparkRDDWriteClient.SlimWriteStats.from((JavaRDD<WriteStatus>)((JavaRDD)tableServiceWriteMetadata.getWriteStatuses()));
        List dataTableWriteStats = writeStatusMetadataTrackerList.stream().filter(entry -> !entry.isMetadataTable()).map(SparkRDDWriteClient.SlimWriteStats::getWriteStat).collect(Collectors.toList());
        List mdtWriteStats = writeStatusMetadataTrackerList.stream().filter(SparkRDDWriteClient.SlimWriteStats::isMetadataTable).map(SparkRDDWriteClient.SlimWriteStats::getWriteStat).collect(Collectors.toList());
        if (HoodieTableMetadata.isMetadataTable((String)this.config.getBasePath())) {
            ValidationUtils.checkArgument((boolean)dataTableWriteStats.isEmpty(), (String)"Metadata table should not expect any data table write status.");
            return new TableWriteStats(mdtWriteStats, Collections.emptyList());
        }
        return new TableWriteStats(dataTableWriteStats, mdtWriteStats);
    }

    protected HoodieWriteMetadata<HoodieData<WriteStatus>> partialUpdateTableMetadata(HoodieTable table, HoodieWriteMetadata<HoodieData<WriteStatus>> writeMetadata, String instantTime, WriteOperationType writeOperationType) {
        if (this.isStreamingWriteToMetadataEnabled(table)) {
            boolean enforceCoalesceWithRepartition;
            boolean bl = enforceCoalesceWithRepartition = writeOperationType == WriteOperationType.CLUSTER;
            if (enforceCoalesceWithRepartition) {
                enforceCoalesceWithRepartition = this.computeEnforceCoalesceWithRepartitionForClustering(table, instantTime);
            }
            writeMetadata.setWriteStatuses(this.streamingMetadataWriteHandler.streamWriteToMetadataTable(table, (HoodieData<WriteStatus>)((HoodieData)writeMetadata.getWriteStatuses()), instantTime, enforceCoalesceWithRepartition, this.config.getMetadataConfig().getStreamingWritesCoalesceDivisorForDataTableWrites()));
        }
        return writeMetadata;
    }

    private boolean computeEnforceCoalesceWithRepartitionForClustering(HoodieTable table, String instantTime) {
        HoodieClusteringPlan clusteringPlan = (HoodieClusteringPlan)ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)table.getMetaClient(), (HoodieInstant)((HoodieInstant)ClusteringUtils.getRequestedClusteringInstant((String)instantTime, (HoodieActiveTimeline)table.getActiveTimeline(), (InstantGenerator)table.getInstantGenerator()).get())).map(Pair::getRight).orElseThrow(() -> new HoodieClusteringException("Unable to read clustering plan for instant: " + instantTime));
        if (clusteringPlan.getStrategy().getStrategyParams().containsKey(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()) && !StringUtils.isNullOrEmpty((String)((String)clusteringPlan.getStrategy().getStrategyParams().get(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key())))) {
            return false;
        }
        return this.config.getBulkInsertSortMode() == BulkInsertSortMode.NONE;
    }

    protected void writeToMetadataTable(HoodieTable table, String instantTime, HoodieCommitMetadata metadata, List<HoodieWriteStat> partialMetadataWriteStats) {
        if (this.isStreamingWriteToMetadataEnabled(table)) {
            this.streamingMetadataWriteHandler.commitToMetadataTable(table, instantTime, metadata, partialMetadataWriteStats);
        } else {
            this.writeTableMetadata(table, instantTime, metadata);
        }
    }

    protected HoodieWriteMetadata<JavaRDD<WriteStatus>> convertToOutputMetadata(HoodieWriteMetadata<HoodieData<WriteStatus>> writeMetadata) {
        return writeMetadata.clone(HoodieJavaRDD.getJavaRDD((HoodieData)writeMetadata.getWriteStatuses()));
    }

    protected void runPrecommitValidationForClustering(HoodieWriteMetadata<JavaRDD<WriteStatus>> writeMetadata, HoodieTable table, String instantTime) {
        HoodieWriteMetadata recreatedWriteMetadata = new HoodieWriteMetadata();
        if (writeMetadata.getWriteStats().isPresent()) {
            recreatedWriteMetadata.setWriteStats((List)writeMetadata.getWriteStats().get());
        }
        recreatedWriteMetadata.setPartitionToReplaceFileIds(writeMetadata.getPartitionToReplaceFileIds());
        SparkValidatorUtils.runValidators(this.config, (HoodieWriteMetadata<HoodieData<WriteStatus>>)recreatedWriteMetadata, this.context, table, instantTime);
    }

    protected HoodieTable<?, HoodieData<HoodieRecord<T>>, ?, HoodieData<WriteStatus>> createTable(HoodieWriteConfig config, StorageConfiguration<?> storageConf, boolean skipValidation) {
        return this.createTableAndValidate(config, HoodieSparkTable::create, skipValidation);
    }

    protected void releaseResources(String instantTime) {
        SparkReleaseResources.releaseCachedData(this.context, this.config, this.basePath, instantTime);
    }
}

