/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.CoalescingPartitioner;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class StreamingMetadataWriteHandler {
    private final Map<String, Option<HoodieTableMetadataWriter>> metadataWriterMap = new HashMap<String, Option<HoodieTableMetadataWriter>>();

    public HoodieData<WriteStatus> streamWriteToMetadataTable(HoodieTable table, HoodieData<WriteStatus> dataTableWriteStatuses, String instantTime, boolean enforceCoalesceWithRepartition, int coalesceDivisorForDataTableWrites) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.getMetadataWriter(instantTime, table);
        ValidationUtils.checkState((boolean)metadataWriterOpt.isPresent(), (String)("Cannot instantiate metadata writer for the table of interest " + table.getMetaClient().getBasePath()));
        return this.streamWriteToMetadataTable(dataTableWriteStatuses, (HoodieTableMetadataWriter)metadataWriterOpt.get(), table, instantTime, enforceCoalesceWithRepartition, coalesceDivisorForDataTableWrites);
    }

    public void commitToMetadataTable(HoodieTable table, String instantTime, HoodieCommitMetadata metadata, List<HoodieWriteStat> partialMetadataWriteStats) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.getMetadataWriter(instantTime, table);
        ValidationUtils.checkState((boolean)metadataWriterOpt.isPresent(), (String)"Should not be reachable. Metadata Writer should have been instantiated by now");
        try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
            metadataWriter.completeStreamingCommit(instantTime, table.getContext(), partialMetadataWriteStats, metadata);
        }
        catch (Exception e) {
            throw new HoodieException("Error while completing streaming commit to metadata with instant " + instantTime, (Throwable)e);
        }
        finally {
            this.metadataWriterMap.remove(instantTime);
        }
    }

    private HoodieData<WriteStatus> streamWriteToMetadataTable(HoodieData<WriteStatus> dataTableWriteStatuses, HoodieTableMetadataWriter metadataWriter, HoodieTable table, String instantTime, boolean enforceCoalesceWithRepartition, int coalesceDivisorForDataTableWrites) {
        HoodieData mdtWriteStatuses = metadataWriter.streamWriteToMetadataPartitions(dataTableWriteStatuses, instantTime);
        mdtWriteStatuses.persist("MEMORY_AND_DISK_SER", table.getContext(), HoodieData.HoodieDataCacheKey.of((String)table.getMetaClient().getBasePath().toString(), (String)instantTime));
        int coalesceParallelism = Math.max(1, dataTableWriteStatuses.getNumPartitions() / coalesceDivisorForDataTableWrites);
        HoodieJavaRDD coalescedDataWriteStatuses = enforceCoalesceWithRepartition ? HoodieJavaRDD.of(HoodieJavaRDD.getJavaRDD(dataTableWriteStatuses).mapToPair((PairFunction & Serializable)writeStatus -> new Tuple2((Object)writeStatus.getStat().getPath(), writeStatus)).partitionBy((Partitioner)new CoalescingPartitioner(coalesceParallelism)).map((Function & Serializable)entry -> (WriteStatus)entry._2)) : dataTableWriteStatuses.coalesce(coalesceParallelism);
        return coalescedDataWriteStatuses.union(mdtWriteStatuses);
    }

    @VisibleForTesting
    synchronized Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstant, HoodieTable table) {
        if (!table.getMetaClient().getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            return Option.empty();
        }
        if (this.metadataWriterMap.containsKey(triggeringInstant)) {
            return this.metadataWriterMap.get(triggeringInstant);
        }
        Option metadataWriterOpt = table.getMetadataWriter(triggeringInstant, true, true);
        this.metadataWriterMap.put(triggeringInstant, (Option<HoodieTableMetadataWriter>)metadataWriterOpt);
        metadataWriterOpt.ifPresent(metadataWriter -> metadataWriter.startCommit(triggeringInstant));
        return this.metadataWriterMap.get(triggeringInstant);
    }
}

