/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.ClusteringGroupInfo;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.cluster.strategy.ClusteringExecutionStrategy;

public abstract class SingleSparkJobExecutionStrategy<T>
extends ClusteringExecutionStrategy<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    public SingleSparkJobExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    public HoodieWriteMetadata<HoodieData<WriteStatus>> performClustering(HoodieClusteringPlan clusteringPlan, Schema schema, String instantTime) {
        TaskContextSupplier taskContextSupplier = this.getEngineContext().getTaskContextSupplier();
        SerializableSchema serializableSchema = new SerializableSchema(schema);
        List clusteringGroupInfos = clusteringPlan.getInputGroups().stream().map(ClusteringGroupInfo::create).collect(Collectors.toList());
        ReaderContextFactory readerContextFactory = this.getEngineContext().getReaderContextFactory(this.getHoodieTable().getMetaClient());
        HoodieData writeStatus = this.getEngineContext().parallelize(clusteringGroupInfos).map((SerializableFunction & Serializable)group -> this.performClusteringForGroup((ReaderContextFactory<T>)readerContextFactory, (ClusteringGroupInfo)group, clusteringPlan.getStrategy().getStrategyParams(), (Boolean)Option.ofNullable((Object)clusteringPlan.getPreserveHoodieMetadata()).orElse((Object)false), serializableSchema, taskContextSupplier, instantTime)).flatMap(List::iterator);
        HoodieWriteMetadata writeMetadata = new HoodieWriteMetadata();
        writeMetadata.setWriteStatuses((Object)writeStatus);
        return writeMetadata;
    }

    protected abstract List<WriteStatus> performClusteringForGroup(ReaderContextFactory<T> var1, ClusteringGroupInfo var2, Map<String, String> var3, boolean var4, SerializableSchema var5, TaskContextSupplier var6, String var7);
}

