/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.clustering.run.strategy.SparkBinaryCopyClusteringExecutionStrategy;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ClusteringGroupInfo;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.parquet.io.ParquetBinaryCopyChecker;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkStreamCopyClusteringExecutionStrategy<T>
extends SparkBinaryCopyClusteringExecutionStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkStreamCopyClusteringExecutionStrategy.class);

    public SparkStreamCopyClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public boolean supportBinaryStreamCopy(List<ClusteringGroupInfo> inputGroups, Map<String, String> strategyParams) {
        if (this.getHoodieTable().getMetaClient().getTableType() != HoodieTableType.COPY_ON_WRITE) {
            LOG.warn("SparkStreamCopyClusteringExecutionStrategy is only supported for COW tables. Will fall back to common clustering execution strategy.");
            return false;
        }
        Option orderByColumnsOpt = Option.ofNullable((Object)strategyParams.get(HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key())).map(listStr -> listStr.split(","));
        if (orderByColumnsOpt.isPresent()) {
            LOG.warn("SparkStreamCopyClusteringExecutionStrategy does not support sort by columns. Will fall back to common clustering execution strategy.");
            return false;
        }
        if (!this.getHoodieTable().getMetaClient().getTableConfig().getBaseFileFormat().equals((Object)HoodieFileFormat.PARQUET)) {
            LOG.warn("SparkStreamCopyClusteringExecutionStrategy only supports parquet base files. Will fall back to common clustering execution strategy.");
            return false;
        }
        if (!this.writeConfig.isBinaryCopySchemaEvolutionEnabled()) {
            LOG.info("Schema evolution disabled, skipping schema compatibility checks for binary stream copy");
            return true;
        }
        LOG.info("Schema evolution enabled, performing schema compatibility checks for binary stream copy");
        JavaSparkContext engineContext = HoodieSparkEngineContext.getSparkContext(this.getEngineContext());
        List fileStatus = engineContext.parallelize(inputGroups, inputGroups.size()).flatMap((FlatMapFunction & Serializable)group -> group.getOperations().iterator()).map((Function & Serializable)op -> {
            String filePath = op.getDataFilePath();
            return ParquetBinaryCopyChecker.collectFileInfo((Configuration)((Configuration)this.getHoodieTable().getStorageConf().unwrapAs(Configuration.class)), (String)filePath);
        }).collect();
        boolean compatible = ParquetBinaryCopyChecker.verifyFiles((List)fileStatus);
        if (!compatible) {
            LOG.warn("Schema compatibility check failed. Will fall back to common clustering execution strategy.");
        }
        return compatible;
    }
}

