/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.model;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public abstract class HoodieInternalRow
extends InternalRow {
    protected final UTF8String[] metaFields;
    protected final InternalRow sourceRow;
    protected final boolean sourceContainsMetaFields;

    public HoodieInternalRow(UTF8String[] metaFields, InternalRow sourceRow, boolean sourceContainsMetaFields) {
        this.metaFields = metaFields;
        this.sourceRow = sourceRow;
        this.sourceContainsMetaFields = sourceContainsMetaFields;
    }

    public int numFields() {
        if (this.sourceContainsMetaFields) {
            return this.sourceRow.numFields();
        }
        return this.sourceRow.numFields() + this.metaFields.length;
    }

    public void setNullAt(int ordinal) {
        if (ordinal < this.metaFields.length) {
            this.metaFields[ordinal] = null;
        } else {
            this.sourceRow.setNullAt(this.rebaseOrdinal(ordinal));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(int ordinal, Object value) {
        if (ordinal < this.metaFields.length) {
            if (value instanceof UTF8String) {
                this.metaFields[ordinal] = (UTF8String)value;
                return;
            } else {
                if (!(value instanceof String)) throw new IllegalArgumentException(String.format("Could not update the row at (%d) with value of type (%s), either UTF8String or String are expected", ordinal, value.getClass().getSimpleName()));
                this.metaFields[ordinal] = UTF8String.fromString((String)((String)value));
            }
            return;
        } else {
            this.sourceRow.update(this.rebaseOrdinal(ordinal), value);
        }
    }

    public boolean isNullAt(int ordinal) {
        if (ordinal < this.metaFields.length) {
            return this.metaFields[ordinal] == null;
        }
        return this.sourceRow.isNullAt(this.rebaseOrdinal(ordinal));
    }

    public UTF8String getUTF8String(int ordinal) {
        if (ordinal < this.metaFields.length) {
            return this.metaFields[ordinal];
        }
        return this.sourceRow.getUTF8String(this.rebaseOrdinal(ordinal));
    }

    public Object get(int ordinal, DataType dataType) {
        if (ordinal < this.metaFields.length) {
            this.validateMetaFieldDataType(dataType);
            return this.metaFields[ordinal];
        }
        return this.sourceRow.get(this.rebaseOrdinal(ordinal), dataType);
    }

    public boolean getBoolean(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Boolean.class);
        return this.sourceRow.getBoolean(this.rebaseOrdinal(ordinal));
    }

    public byte getByte(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Byte.class);
        return this.sourceRow.getByte(this.rebaseOrdinal(ordinal));
    }

    public short getShort(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Short.class);
        return this.sourceRow.getShort(this.rebaseOrdinal(ordinal));
    }

    public int getInt(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Integer.class);
        return this.sourceRow.getInt(this.rebaseOrdinal(ordinal));
    }

    public long getLong(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Long.class);
        return this.sourceRow.getLong(this.rebaseOrdinal(ordinal));
    }

    public float getFloat(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Float.class);
        return this.sourceRow.getFloat(this.rebaseOrdinal(ordinal));
    }

    public double getDouble(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Double.class);
        return this.sourceRow.getDouble(this.rebaseOrdinal(ordinal));
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        this.ruleOutMetaFieldsAccess(ordinal, Decimal.class);
        return this.sourceRow.getDecimal(this.rebaseOrdinal(ordinal), precision, scale);
    }

    public byte[] getBinary(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, Byte[].class);
        return this.sourceRow.getBinary(this.rebaseOrdinal(ordinal));
    }

    public CalendarInterval getInterval(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, CalendarInterval.class);
        return this.sourceRow.getInterval(this.rebaseOrdinal(ordinal));
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        this.ruleOutMetaFieldsAccess(ordinal, InternalRow.class);
        return this.sourceRow.getStruct(this.rebaseOrdinal(ordinal), numFields);
    }

    public ArrayData getArray(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, ArrayData.class);
        return this.sourceRow.getArray(this.rebaseOrdinal(ordinal));
    }

    public MapData getMap(int ordinal) {
        this.ruleOutMetaFieldsAccess(ordinal, MapData.class);
        return this.sourceRow.getMap(this.rebaseOrdinal(ordinal));
    }

    protected int rebaseOrdinal(int ordinal) {
        return this.sourceContainsMetaFields ? ordinal : ordinal - this.metaFields.length;
    }

    private void validateMetaFieldDataType(DataType dataType) {
        if (!dataType.sameType((DataType)StringType$.MODULE$)) {
            throw new ClassCastException(String.format("Can not cast meta-field of type UTF8String to %s", dataType.simpleString()));
        }
    }

    protected void ruleOutMetaFieldsAccess(int ordinal, Class<?> expectedDataType) {
        if (ordinal < this.metaFields.length) {
            throw new ClassCastException(String.format("Can not cast meta-field of type UTF8String at (%d) as %s", ordinal, expectedDataType.getName()));
        }
    }
}

