/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import org.apache.spark.TaskContext;
import org.apache.spark.util.TaskCompletionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;

public class CloseableIteratorListener
implements TaskCompletionListener {
    private static final Logger LOG = LoggerFactory.getLogger(CloseableIteratorListener.class);
    private final Object iterator;

    private CloseableIteratorListener(Object iterator) {
        this.iterator = iterator;
    }

    public static <T> java.util.Iterator<T> addListener(java.util.Iterator<T> iterator) {
        TaskContext.get().addTaskCompletionListener((TaskCompletionListener)new CloseableIteratorListener(iterator));
        return iterator;
    }

    public static <T> Iterator<T> addListener(Iterator<T> iterator) {
        TaskContext.get().addTaskCompletionListener((TaskCompletionListener)new CloseableIteratorListener(iterator));
        return iterator;
    }

    public void onTaskCompletion(TaskContext context) {
        if (this.iterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.iterator).close();
            }
            catch (Exception ex) {
                LOG.warn("Failed to properly close iterator", (Throwable)ex);
            }
        }
    }
}

