/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.data;

import java.util.HashSet;
import java.util.Set;
import org.apache.spark.Dependency;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;

public class HoodieSparkRDDUtils {
    public static void unpersistRDDWithDependencies(RDD<?> rdd) {
        HashSet<Integer> visitedRddIds = new HashSet<Integer>();
        HoodieSparkRDDUtils.unpersistRDDWithDependenciesInternal(rdd, visitedRddIds);
    }

    private static void unpersistRDDWithDependenciesInternal(RDD<?> rdd, Set<Integer> visitedRddIds) {
        if (rdd == null || visitedRddIds.contains(rdd.id())) {
            return;
        }
        visitedRddIds.add(rdd.id());
        if (rdd.getStorageLevel() != StorageLevel.NONE()) {
            rdd.unpersist(false);
        }
        for (Dependency dep : rdd.dependencies()) {
            HoodieSparkRDDUtils.unpersistRDDWithDependenciesInternal(dep.rdd(), visitedRddIds);
        }
    }

    private HoodieSparkRDDUtils() {
    }
}

