/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bucket.partition.NumBucketsFunction;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.sql.BucketPartitionUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class BucketIndexBulkInsertPartitionerWithRows
implements BulkInsertPartitioner<Dataset<Row>> {
    private final String indexKeyFields;
    private final NumBucketsFunction numBucketsFunction;
    private final HoodieWriteConfig writeConfig;
    private FileSystemViewStorageConfig viewConfig;

    public BucketIndexBulkInsertPartitionerWithRows(String indexKeyFields, HoodieWriteConfig writeConfig) {
        this(writeConfig, NumBucketsFunction.fromWriteConfig((HoodieWriteConfig)writeConfig), indexKeyFields);
    }

    public BucketIndexBulkInsertPartitionerWithRows(HoodieWriteConfig writeConfig, String expressions, String rule, int bucketNumber) {
        this(writeConfig, new NumBucketsFunction(expressions, rule, bucketNumber), writeConfig.getBucketIndexHashFieldWithDefault());
    }

    private BucketIndexBulkInsertPartitionerWithRows(HoodieWriteConfig writeConfig, NumBucketsFunction numBucketsFunction, String indexKeyFields) {
        this.indexKeyFields = indexKeyFields;
        this.numBucketsFunction = numBucketsFunction;
        this.writeConfig = writeConfig;
        if (writeConfig.isUsingRemotePartitioner()) {
            this.viewConfig = writeConfig.getViewStorageConfig();
        }
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> rows, int outputPartitions) {
        Partitioner partitioner = this.writeConfig.isUsingRemotePartitioner() && this.writeConfig.isEmbeddedTimelineServerEnabled() ? BucketPartitionUtils$.MODULE$.getRemotePartitioner(this.viewConfig, this.numBucketsFunction, outputPartitions) : BucketPartitionUtils$.MODULE$.getLocalePartitioner(this.numBucketsFunction, outputPartitions);
        return BucketPartitionUtils$.MODULE$.createDataFrame(rows, this.indexKeyFields, this.numBucketsFunction, partitioner);
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

