/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class PartitionSortPartitionerWithRows
implements BulkInsertPartitioner<Dataset<Row>> {
    private final boolean shouldPopulateMetaFields;

    public PartitionSortPartitionerWithRows(HoodieWriteConfig config) {
        this.shouldPopulateMetaFields = config.populateMetaFields();
    }

    public Dataset<Row> repartitionRecords(Dataset<Row> rows, int outputSparkPartitions) {
        if (!this.shouldPopulateMetaFields) {
            throw new HoodieException(BulkInsertSortMode.PARTITION_SORT.name() + " mode requires meta-fields to be enabled");
        }
        return rows.coalesce(outputSparkPartitions).sortWithinPartitions(HoodieRecord.PARTITION_PATH_METADATA_FIELD, new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD});
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

