/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.config.HoodieIndexingConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieMetadataIndexException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.record.HoodieRecordIndex;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.action.index.BaseHoodieIndexClient;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class HoodieSparkIndexClient
extends BaseHoodieIndexClient {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSparkIndexClient.class);
    private Option<SparkSession> sparkSessionOpt = Option.empty();
    private Option<HoodieWriteConfig> writeConfigOpt = Option.empty();
    private Option<HoodieEngineContext> engineContextOpt = Option.empty();

    public HoodieSparkIndexClient(SparkSession sparkSession) {
        this((Option<SparkSession>)Option.of((Object)sparkSession), (Option<HoodieWriteConfig>)Option.empty(), (Option<HoodieEngineContext>)Option.empty());
    }

    public HoodieSparkIndexClient(HoodieWriteConfig writeConfig, HoodieEngineContext engineContext) {
        this((Option<SparkSession>)Option.empty(), (Option<HoodieWriteConfig>)Option.of((Object)writeConfig), (Option<HoodieEngineContext>)Option.of((Object)engineContext));
    }

    public HoodieSparkIndexClient(Option<SparkSession> sparkSessionOpt, Option<HoodieWriteConfig> writeConfig, Option<HoodieEngineContext> engineContext) {
        this.sparkSessionOpt = sparkSessionOpt;
        this.writeConfigOpt = writeConfig;
        this.engineContextOpt = engineContext;
    }

    public void create(HoodieTableMetaClient metaClient, String userIndexName, String indexType, java.util.Map<String, java.util.Map<String, String>> columns, java.util.Map<String, String> options, java.util.Map<String, String> tableProperties) throws Exception {
        if (indexType.equals("secondary_index") || indexType.equals("bloom_filters") || indexType.equals("column_stats")) {
            this.createExpressionOrSecondaryIndex(metaClient, userIndexName, indexType, columns, options, tableProperties);
        } else {
            this.createRecordIndex(metaClient, userIndexName, indexType, options);
        }
    }

    private void createRecordIndex(HoodieTableMetaClient metaClient, String userIndexName, String indexType, java.util.Map<String, String> options) {
        block18: {
            if (!userIndexName.equals("record_index")) {
                throw new HoodieIndexException("Record index should be named as record_index");
            }
            String fullIndexName = "record_index";
            if (HoodieIndexUtils.indexExists((HoodieTableMetaClient)metaClient, (String)fullIndexName)) {
                throw new HoodieMetadataIndexException("Index already exists: " + userIndexName);
            }
            java.util.Map<String, String> overrideOpts = Collections.emptyMap();
            if (HoodieRecordIndex.isPartitioned(options)) {
                overrideOpts = Collections.singletonMap(HoodieMetadataConfig.RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "true");
            }
            HoodieIndexVersion version = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)metaClient.getTableConfig().getTableVersion(), (MetadataPartitionType)MetadataPartitionType.RECORD_INDEX);
            LOG.info("Creating index {} using version {}", (Object)fullIndexName, (Object)version);
            try (SparkRDDWriteClient writeClient = this.getWriteClient(metaClient, (Option<HoodieIndexDefinition>)Option.empty(), (Option<String>)Option.of((Object)indexType), overrideOpts);){
                HoodieIndexVersion currentVersion = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)metaClient.getTableConfig().getTableVersion(), (MetadataPartitionType)MetadataPartitionType.RECORD_INDEX);
                Option<String> indexInstantTime = HoodieSparkIndexClient.doSchedule(writeClient, metaClient, fullIndexName, MetadataPartitionType.RECORD_INDEX, currentVersion);
                if (indexInstantTime.isPresent()) {
                    writeClient.index((String)indexInstantTime.get());
                    break block18;
                }
                throw new HoodieMetadataIndexException("Scheduling of index action did not return any instant.");
            }
            catch (Throwable t) {
                this.drop(metaClient, fullIndexName, (Option<HoodieIndexDefinition>)Option.empty());
                throw t;
            }
        }
    }

    public void createOrUpdateColumnStatsIndexDefinition(HoodieTableMetaClient metaClient, List<String> columnsToIndex) {
        HoodieIndexDefinition indexDefinition = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withIndexFunction("column_stats").withSourceFields(columnsToIndex).withVersion(HoodieTableMetadataUtil.existingIndexVersionOrDefault((String)"column_stats", (HoodieTableMetaClient)metaClient)).withIndexOptions(Collections.EMPTY_MAP).build();
        LOG.info("Registering or updating index: {} of type: {}", (Object)indexDefinition.getIndexName(), (Object)indexDefinition.getIndexType());
        HoodieIndexUtils.register((HoodieTableMetaClient)metaClient, (HoodieIndexDefinition)indexDefinition);
    }

    private void createExpressionOrSecondaryIndex(HoodieTableMetaClient metaClient, String userIndexName, String indexType, java.util.Map<String, java.util.Map<String, String>> columns, java.util.Map<String, String> options, java.util.Map<String, String> tableProperties) throws Exception {
        block16: {
            HoodieIndexDefinition indexDefinition = HoodieIndexUtils.getSecondaryOrExpressionIndexDefinition((HoodieTableMetaClient)metaClient, (String)userIndexName, (String)indexType, columns, options, tableProperties);
            if (!metaClient.getTableConfig().getRelativeIndexDefinitionPath().isPresent() || !metaClient.getIndexForMetadataPartition(indexDefinition.getIndexName()).isPresent()) {
                LOG.info("Index definition is not present. Registering index: {} of type: {}", (Object)indexDefinition.getIndexName(), (Object)indexDefinition.getIndexType());
                HoodieIndexUtils.register((HoodieTableMetaClient)metaClient, (HoodieIndexDefinition)indexDefinition);
            }
            ValidationUtils.checkState((boolean)metaClient.getIndexMetadata().isPresent(), (String)"Index definition is not present");
            LOG.info("Creating index {}", (Object)indexDefinition);
            Option expressionIndexDefinitionOpt = Option.ofNullable((Object)indexDefinition);
            try (SparkRDDWriteClient writeClient = this.getWriteClient(metaClient, (Option<HoodieIndexDefinition>)expressionIndexDefinitionOpt, (Option<String>)Option.of((Object)indexType), Collections.emptyMap());){
                MetadataPartitionType partitionType = indexType.equals("secondary_index") ? MetadataPartitionType.SECONDARY_INDEX : MetadataPartitionType.EXPRESSION_INDEX;
                HoodieIndexVersion currentVersion = HoodieIndexVersion.getCurrentVersion((HoodieTableVersion)metaClient.getTableConfig().getTableVersion(), (MetadataPartitionType)MetadataPartitionType.RECORD_INDEX);
                Option<String> indexInstantTime = HoodieSparkIndexClient.doSchedule(writeClient, metaClient, indexDefinition.getIndexName(), partitionType, currentVersion);
                if (indexInstantTime.isPresent()) {
                    writeClient.index((String)indexInstantTime.get());
                    break block16;
                }
                throw new HoodieMetadataIndexException("Scheduling of index action did not return any instant.");
            }
            catch (Throwable t) {
                LOG.error("Error while creating index: {}. Index will be dropped.", (Object)indexDefinition.getIndexName(), (Object)t);
                this.drop(metaClient, indexDefinition.getIndexName(), (Option<HoodieIndexDefinition>)Option.ofNullable((Object)indexDefinition));
                throw t;
            }
        }
    }

    private void drop(HoodieTableMetaClient metaClient, String indexName, Option<HoodieIndexDefinition> indexDefinitionOpt) {
        LOG.info("Dropping index {}", (Object)indexName);
        try (SparkRDDWriteClient writeClient = this.getWriteClient(metaClient, indexDefinitionOpt, (Option<String>)Option.empty(), Collections.emptyMap());){
            writeClient.dropIndex(Collections.singletonList(indexName));
        }
    }

    public void drop(HoodieTableMetaClient metaClient, String indexName, boolean ignoreIfNotExists) {
        LOG.info("Dropping index {}", (Object)indexName);
        Option indexDefinitionOpt = metaClient.getIndexMetadata().map(HoodieIndexMetadata::getIndexDefinitions).map(definition -> (HoodieIndexDefinition)definition.get(indexName));
        try (SparkRDDWriteClient writeClient = this.getWriteClient(metaClient, (Option<HoodieIndexDefinition>)indexDefinitionOpt, (Option<String>)Option.empty(), Collections.emptyMap());){
            writeClient.dropIndex(Collections.singletonList(indexName));
        }
    }

    private SparkRDDWriteClient getWriteClient(HoodieTableMetaClient metaClient, Option<HoodieIndexDefinition> indexDefinitionOpt, Option<String> indexTypeOpt, java.util.Map<String, String> configs) {
        try {
            HoodieWriteConfig localWriteConfig;
            TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
            String schemaStr = schemaUtil.getTableAvroSchema(false).toString();
            TypedProperties props = this.getProps(metaClient, indexDefinitionOpt, indexTypeOpt, schemaStr);
            if (!this.engineContextOpt.isPresent()) {
                this.engineContextOpt = Option.of((Object)((Object)new HoodieSparkEngineContext(new JavaSparkContext(((SparkSession)this.sparkSessionOpt.get()).sparkContext()))));
            }
            if ((localWriteConfig = HoodieWriteConfig.newBuilder().withPath(metaClient.getBasePath()).withProperties((Properties)props).withEmbeddedTimelineServerEnabled(false).withSchema(schemaStr).withEngineType(EngineType.SPARK).withProps(configs).build()).getWriteConcurrencyMode().supportsMultiWriter() && StringUtils.isNullOrEmpty((String)localWriteConfig.getLockProviderClass())) {
                throw new IllegalArgumentException("To create index asynchronously, multi-writer configurations need to be enabled and hence 'hoodie.write.lock.provider' is expected to be set for such cases. For single writer mode, feel free to set the config value to org.apache.hudi.client.transaction.lock.InProcessLockProvider and retry index creation");
            }
            return new SparkRDDWriteClient((HoodieEngineContext)this.engineContextOpt.get(), localWriteConfig, (Option<EmbeddedTimelineService>)Option.empty());
        }
        catch (Exception e) {
            throw new HoodieException("Failed to create write client while performing index operation ", (Throwable)e);
        }
    }

    private TypedProperties getProps(HoodieTableMetaClient metaClient, Option<HoodieIndexDefinition> indexDefinitionOpt, Option<String> indexTypeOpt, String schemaStr) {
        if (this.writeConfigOpt.isPresent()) {
            return ((HoodieWriteConfig)this.writeConfigOpt.get()).getProps();
        }
        TypedProperties typedProperties = metaClient.getTableConfig().getProps();
        ((java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)((SparkSession)this.sparkSessionOpt.get()).sqlContext().getAllConfs()).asJava()).forEach((k, v) -> {
            if (k.startsWith("hoodie.")) {
                typedProperties.put(k, v);
            }
        });
        typedProperties.putAll(HoodieSparkIndexClient.buildWriteConfig(metaClient, indexDefinitionOpt, indexTypeOpt));
        typedProperties.put((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key(), (Object)schemaStr);
        return typedProperties;
    }

    private static Option<String> doSchedule(SparkRDDWriteClient<HoodieRecordPayload> client, HoodieTableMetaClient metaClient, String indexName, MetadataPartitionType partitionType, HoodieIndexVersion version) {
        List<MetadataPartitionType> partitionTypes = Collections.singletonList(partitionType);
        if (metaClient.getTableConfig().getMetadataPartitions().isEmpty()) {
            throw new HoodieException("Metadata table is not yet initialized. Initialize FILES partition before any other partition " + Arrays.toString(partitionTypes.toArray()));
        }
        return client.scheduleIndexing(partitionTypes, Collections.singletonList(indexName));
    }

    private static java.util.Map<String, String> buildWriteConfig(HoodieTableMetaClient metaClient, Option<HoodieIndexDefinition> indexDefinitionOpt, Option<String> indexTypeOpt) {
        HashMap<String, String> writeConfig = new HashMap<String, String>();
        if (metaClient.getTableConfig().isMetadataTableAvailable()) {
            String indexType;
            writeConfig.put(HoodieWriteConfig.WRITE_CONCURRENCY_MODE.key(), WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL.name());
            metaClient.getTableConfig().getMetadataPartitions().forEach(partitionPath -> {
                if (partitionPath.equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "true");
                }
                if (partitionPath.equals(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key(), "true");
                }
                if (partitionPath.equals(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                    writeConfig.put(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key(), "true");
                }
            });
            if (indexTypeOpt.isPresent() && (indexType = (String)indexTypeOpt.get()).equals("record_index")) {
                writeConfig.put(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "true");
            }
        }
        indexDefinitionOpt.ifPresent(indexDefinition -> HoodieIndexingConfig.fromIndexDefinition((HoodieIndexDefinition)indexDefinition).getProps().forEach((key, value) -> writeConfig.put(key.toString(), value.toString())));
        return writeConfig;
    }
}

