/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.HoodieInternalProxyIndex;
import org.apache.hudi.index.SparkMetadataTableGlobalRecordLevelIndex;
import org.apache.hudi.index.SparkMetadataTableRecordLevelIndex;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndexHelper;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.index.bucket.HoodieSparkConsistentBucketIndex;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.index.simple.HoodieGlobalSimpleIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;

public final class SparkHoodieIndexFactory {
    public static HoodieIndex createIndex(HoodieWriteConfig config) {
        boolean sqlMergeIntoPrepped = config.getProps().getBoolean("_hoodie.spark.sql.merge.into.prepped", false);
        if (sqlMergeIntoPrepped) {
            return new HoodieInternalProxyIndex(config);
        }
        if (!StringUtils.isNullOrEmpty((String)config.getIndexClass())) {
            return HoodieIndexUtils.createUserDefinedIndex((HoodieWriteConfig)config);
        }
        switch (config.getIndexType()) {
            case INMEMORY: {
                return new HoodieInMemoryHashIndex(config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
            }
            case GLOBAL_BLOOM: {
                return new HoodieGlobalBloomIndex(config, (BaseHoodieBloomIndexHelper)SparkHoodieBloomIndexHelper.getInstance());
            }
            case SIMPLE: {
                return new HoodieSimpleIndex(config, HoodieSparkKeyGeneratorFactory.createBaseKeyGenerator(config));
            }
            case GLOBAL_SIMPLE: {
                return new HoodieGlobalSimpleIndex(config, HoodieSparkKeyGeneratorFactory.createBaseKeyGenerator(config));
            }
            case BUCKET: {
                switch (config.getBucketIndexEngineType()) {
                    case SIMPLE: {
                        return new HoodieSimpleBucketIndex(config);
                    }
                    case CONSISTENT_HASHING: {
                        return new HoodieSparkConsistentBucketIndex(config);
                    }
                }
                throw new HoodieIndexException("Unknown bucket index engine type: " + config.getBucketIndexEngineType());
            }
            case RECORD_INDEX: 
            case GLOBAL_RECORD_LEVEL_INDEX: {
                return new SparkMetadataTableGlobalRecordLevelIndex(config);
            }
            case RECORD_LEVEL_INDEX: {
                return new SparkMetadataTableRecordLevelIndex(config);
            }
        }
        throw new HoodieIndexException("Index type unspecified, set " + config.getIndexType());
    }

    public static boolean isGlobalIndex(HoodieWriteConfig config) {
        switch (config.getIndexType()) {
            case INMEMORY: {
                return true;
            }
            case BLOOM: {
                return false;
            }
            case GLOBAL_BLOOM: {
                return true;
            }
            case SIMPLE: {
                return false;
            }
            case GLOBAL_SIMPLE: {
                return true;
            }
            case BUCKET: {
                return false;
            }
            case RECORD_INDEX: 
            case GLOBAL_RECORD_LEVEL_INDEX: {
                return true;
            }
            case RECORD_LEVEL_INDEX: {
                return false;
            }
        }
        return SparkHoodieIndexFactory.createIndex(config).isGlobal();
    }
}

