/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Either;
import org.apache.hudi.common.util.HoodieDataUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkMetadataTableGlobalRecordLevelIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkMetadataTableGlobalRecordLevelIndex.class);

    public SparkMetadataTableGlobalRecordLevelIndex(HoodieWriteConfig config) {
        super(config);
    }

    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        Either<Integer, Map<String, Integer>> fileGroupSize;
        try {
            ValidationUtils.checkState((boolean)hoodieTable.getMetaClient().getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX));
            fileGroupSize = this.fetchFileGroupSize(hoodieTable);
            ValidationUtils.checkState((this.getTotalFileGroupCount(fileGroupSize) > 0 ? 1 : 0) != 0, (String)"Record index should have at least one file group");
        }
        catch (IllegalStateException | TableNotFoundException e) {
            LOG.warn("Record index not initialized. Falling back to {} for tagging records", (Object)this.getFallbackIndexType().name());
            HoodieWriteConfig otherConfig = HoodieWriteConfig.newBuilder().withProperties((Properties)this.config.getProps()).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(this.getFallbackIndexType()).build()).build();
            HoodieIndex fallbackIndex = SparkHoodieIndexFactory.createIndex(otherConfig);
            ValidationUtils.checkArgument((this.isGlobal() == fallbackIndex.isGlobal() ? 1 : 0) != 0, (String)"Fallback index needs to have same isGlobal() as the record index");
            return fallbackIndex.tagLocation(records, context, hoodieTable);
        }
        if (this.config.getRecordIndexUseCaching()) {
            records.persist(this.config.getRecordIndexInputStorageLevel());
        }
        HoodiePairData<String, HoodieRecordGlobalLocation> keyAndExistingLocations = this.lookupRecords(records, context, hoodieTable, fileGroupSize);
        HoodieData taggedRecords = HoodieIndexUtils.tagGlobalLocationBackToRecords(records, keyAndExistingLocations, (boolean)false, (boolean)this.shouldUpdatePartitionPath(hoodieTable), (HoodieWriteConfig)this.config, (HoodieTable)hoodieTable);
        if (this.config.getRecordIndexUseCaching()) {
            records.unpersist();
        }
        return taggedRecords;
    }

    protected HoodieIndex.IndexType getFallbackIndexType() {
        return HoodieIndex.IndexType.GLOBAL_SIMPLE;
    }

    protected <R> HoodiePairData<String, HoodieRecordGlobalLocation> lookupRecords(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable, Either<Integer, Map<String, Integer>> fileGroupSize) {
        int numFileGroups = (Integer)fileGroupSize.asLeft();
        HoodieIndexVersion indexVersion = HoodieTableMetadataUtil.existingIndexVersionOrDefault((String)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (HoodieTableMetaClient)hoodieTable.getMetaClient());
        SerializableBiFunction mappingFunction = MetadataPartitionType.fromPartitionPath((String)MetadataPartitionType.RECORD_INDEX.getPartitionPath()).getFileGroupMappingFunction(indexVersion);
        JavaRDD partitionedKeyRDD = HoodieJavaRDD.getJavaRDD(records).map(HoodieRecord::getRecordKey).keyBy((Function & Serializable)k -> (Integer)mappingFunction.apply(k, (Object)numFileGroups)).partitionBy((Partitioner)new PartitionIdPassthrough(numFileGroups)).map((Function & Serializable)t -> (String)t._2);
        ValidationUtils.checkState((partitionedKeyRDD.getNumPartitions() <= numFileGroups ? 1 : 0) != 0);
        return HoodieJavaPairRDD.of(partitionedKeyRDD.mapPartitionsToPair((PairFlatMapFunction)new RecordIndexFileGroupLookupFunction(hoodieTable)));
    }

    protected Either<Integer, Map<String, Integer>> fetchFileGroupSize(HoodieTable hoodieTable) {
        return Either.left((Object)hoodieTable.getMetadataTable().getNumFileGroupsForPartition(MetadataPartitionType.RECORD_INDEX));
    }

    protected int getTotalFileGroupCount(Either<Integer, Map<String, Integer>> fileGroupSize) {
        return (Integer)fileGroupSize.asLeft();
    }

    protected boolean shouldUpdatePartitionPath(HoodieTable hoodieTable) {
        return this.config.getRecordIndexUpdatePartitionPath() && hoodieTable.isPartitioned();
    }

    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatuses;
    }

    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    public boolean isGlobal() {
        return true;
    }

    public boolean canIndexLogFiles() {
        return false;
    }

    public boolean isImplicitWithStorage() {
        return false;
    }

    protected class PartitionIdPassthrough
    extends Partitioner {
        private final int numPartitions;

        public PartitionIdPassthrough(int numPartitions) {
            this.numPartitions = numPartitions;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public int getPartition(Object key) {
            return (Integer)key;
        }
    }

    private static class RecordIndexFileGroupLookupFunction
    implements PairFlatMapFunction<Iterator<String>, String, HoodieRecordGlobalLocation> {
        private final HoodieTable hoodieTable;

        public RecordIndexFileGroupLookupFunction(HoodieTable hoodieTable) {
            this.hoodieTable = hoodieTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<Tuple2<String, HoodieRecordGlobalLocation>> call(Iterator<String> recordKeyIterator) {
            ArrayList keysToLookup = new ArrayList();
            recordKeyIterator.forEachRemaining(keysToLookup::add);
            HoodiePairData recordIndexData = this.hoodieTable.getMetadataTable().readRecordIndexLocationsWithKeys((HoodieData)HoodieListData.eager(keysToLookup));
            try {
                List recordIndexInfo = HoodieDataUtils.dedupeAndCollectAsList((HoodiePairData)recordIndexData);
                Iterator<Tuple2<String, HoodieRecordGlobalLocation>> iterator = recordIndexInfo.stream().map(e -> new Tuple2(e.getKey(), e.getValue())).iterator();
                return iterator;
            }
            finally {
                recordIndexData.unpersistWithDependencies();
            }
        }
    }
}

