/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.util.Either;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkMetadataTableGlobalRecordLevelIndex;
import org.apache.hudi.metadata.BucketizedMetadataTableFileGroupIndexParser;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import scala.Tuple2;

public class SparkMetadataTableRecordLevelIndex
extends SparkMetadataTableGlobalRecordLevelIndex {
    public SparkMetadataTableRecordLevelIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    protected HoodieIndex.IndexType getFallbackIndexType() {
        return HoodieIndex.IndexType.SIMPLE;
    }

    @Override
    protected <R> HoodiePairData<String, HoodieRecordGlobalLocation> lookupRecords(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable, Either<Integer, Map<String, Integer>> fileGroupSize) {
        Map fileGroupCountPerDataPartition = (Map)fileGroupSize.asRight();
        int numFileGroups = this.getTotalFileGroupCount(fileGroupSize);
        Map partitionOffsetIndexes = BucketizedMetadataTableFileGroupIndexParser.generatePartitionToBaseIndexOffsets((Map)fileGroupCountPerDataPartition);
        JavaRDD partitionedKeyRDD = HoodieJavaRDD.getJavaRDD(records).filter((Function & Serializable)record -> partitionOffsetIndexes.containsKey(record.getPartitionPath())).map((Function & Serializable)record -> Pair.of((Object)record.getPartitionPath(), (Object)record.getRecordKey())).keyBy((Function & Serializable)k -> (Integer)partitionOffsetIndexes.get(k.getLeft()) + HoodieTableMetadataUtil.mapRecordKeyToFileGroupIndex((String)((String)k.getRight()), (int)((Integer)fileGroupCountPerDataPartition.get(k.getLeft())))).partitionBy((Partitioner)new SparkMetadataTableGlobalRecordLevelIndex.PartitionIdPassthrough(numFileGroups)).map((Function & Serializable)t -> (Pair)t._2);
        ValidationUtils.checkState((partitionedKeyRDD.getNumPartitions() <= numFileGroups ? 1 : 0) != 0);
        return HoodieJavaPairRDD.of(partitionedKeyRDD.mapPartitionsToPair((PairFlatMapFunction)new PartitionedRecordIndexFileGroupLookupFunction(hoodieTable)));
    }

    @Override
    protected Either<Integer, Map<String, Integer>> fetchFileGroupSize(HoodieTable hoodieTable) {
        HashMap partitionSizes = new HashMap();
        Map fileGroups = hoodieTable.getMetadataTable().getBucketizedFileGroupsForPartitionedRLI(MetadataPartitionType.RECORD_INDEX);
        fileGroups.keySet().forEach(k -> partitionSizes.put(k, ((List)fileGroups.get(k)).size()));
        return Either.right(partitionSizes);
    }

    @Override
    protected int getTotalFileGroupCount(Either<Integer, Map<String, Integer>> fileGroupSize) {
        return BucketizedMetadataTableFileGroupIndexParser.calculateNumberOfFileGroups((Map)((Map)fileGroupSize.asRight()));
    }

    @Override
    protected boolean shouldUpdatePartitionPath(HoodieTable hoodieTable) {
        return false;
    }

    private static class PartitionedRecordIndexFileGroupLookupFunction
    implements PairFlatMapFunction<Iterator<Pair<String, String>>, String, HoodieRecordGlobalLocation> {
        private final HoodieTable hoodieTable;

        public PartitionedRecordIndexFileGroupLookupFunction(HoodieTable hoodieTable) {
            this.hoodieTable = hoodieTable;
        }

        public Iterator<Tuple2<String, HoodieRecordGlobalLocation>> call(Iterator<Pair<String, String>> partitionPathRecordKeyIterator) throws Exception {
            String[] partitionName = new String[]{null};
            ArrayList keysToLookup = new ArrayList();
            partitionPathRecordKeyIterator.forEachRemaining(p -> {
                keysToLookup.add(p.getRight());
                if (partitionName[0] == null) {
                    partitionName[0] = (String)p.getLeft();
                }
            });
            assert (partitionName[0] != null || keysToLookup.isEmpty());
            Map recordIndexInfo = this.hoodieTable.getMetadataTable().readRecordIndexLocationsWithKeys((HoodieData)HoodieListData.eager(keysToLookup), Option.ofNullable((Object)partitionName[0])).collectAsList().stream().collect(HashMap::new, (map, pair) -> {
                HoodieRecordGlobalLocation cfr_ignored_0 = (HoodieRecordGlobalLocation)map.put(pair.getKey(), pair.getValue());
            }, HashMap::putAll);
            return recordIndexInfo.entrySet().stream().map(e -> new Tuple2(e.getKey(), e.getValue())).iterator();
        }
    }
}

