/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieSparkParquetStreamWriter;
import org.apache.hudi.io.storage.HoodieSparkParquetWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkFileWriterFactory
extends HoodieFileWriterFactory {
    public HoodieSparkFileWriterFactory(HoodieStorage storage) {
        super(storage);
    }

    protected HoodieFileWriter newParquetFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        boolean populateMetaFields = config.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieRowParquetWriteSupport writeSupport = HoodieSparkFileWriterFactory.getHoodieRowParquetWriteSupport(this.storage.getConf(), schema, config, HoodieSparkFileWriterFactory.enableBloomFilter((boolean)populateMetaFields, (HoodieConfig)config));
        HoodieRowParquetConfig parquetConfig = new HoodieRowParquetConfig(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), config.getIntOrDefault(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getIntOrDefault(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLongOrDefault(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), (Configuration)this.storage.getConf().unwrapAs(Configuration.class), config.getDoubleOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        parquetConfig.getHadoopConf().addResource(writeSupport.getHadoopConf());
        return new HoodieSparkParquetWriter(path, parquetConfig, instantTime, taskContextSupplier, populateMetaFields);
    }

    protected HoodieFileWriter newParquetFileWriter(OutputStream outputStream, HoodieConfig config, Schema schema) throws IOException {
        boolean enableBloomFilter = false;
        HoodieRowParquetWriteSupport writeSupport = HoodieSparkFileWriterFactory.getHoodieRowParquetWriteSupport(this.storage.getConf(), schema, config, enableBloomFilter);
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieRowParquetConfig parquetConfig = new HoodieRowParquetConfig(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), config.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE), config.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE), config.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), writeSupport.getHadoopConf(), config.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        parquetConfig.getHadoopConf().addResource(writeSupport.getHadoopConf());
        return new HoodieSparkParquetStreamWriter(new FSDataOutputStream(outputStream, null), parquetConfig);
    }

    protected HoodieFileWriter newHFileFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new HoodieIOException("Not support write to HFile");
    }

    protected HoodieFileWriter newOrcFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new HoodieIOException("Not support write to Orc file");
    }

    private static HoodieRowParquetWriteSupport getHoodieRowParquetWriteSupport(StorageConfiguration<?> conf, Schema schema, HoodieConfig config, boolean enableBloomFilter) {
        Option filter = enableBloomFilter ? Option.of((Object)HoodieSparkFileWriterFactory.createBloomFilter((HoodieConfig)config)) : Option.empty();
        StructType structType = HoodieInternalRowUtils.getCachedSchema(schema);
        return HoodieRowParquetWriteSupport.getHoodieRowParquetWriteSupport((Configuration)conf.unwrapAs(Configuration.class), structType, (Option<BloomFilter>)filter, config);
    }
}

