/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.TypeUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.io.storage.HoodieSparkFileReader;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.HoodieAvroParquetSchemaConverter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.SchemaRepair;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.parquet.HoodieParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkBasicSchemaEvolution;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.Option$;

public class HoodieSparkParquetReader
implements HoodieSparkFileReader {
    public static final String ENABLE_LOGICAL_TIMESTAMP_REPAIR = "spark.hudi.logicalTimestampField.repair.enable";
    private final StoragePath path;
    private final HoodieStorage storage;
    private final FileFormatUtils parquetUtils;
    private final List<ClosableIterator> readerIterators = new ArrayList<ClosableIterator>();
    private org.apache.hudi.common.util.Option<MessageType> fileSchemaOption = org.apache.hudi.common.util.Option.empty();
    private org.apache.hudi.common.util.Option<StructType> structTypeOption = org.apache.hudi.common.util.Option.empty();
    private org.apache.hudi.common.util.Option<Schema> schemaOption = org.apache.hudi.common.util.Option.empty();

    public HoodieSparkParquetReader(HoodieStorage storage, StoragePath path) {
        this.path = path;
        this.storage = storage.newInstance(path, storage.getConf().newInstance());
        this.storage.getConf().set("parquet.avro.add-list-element-records", "false");
        this.parquetUtils = HoodieIOFactory.getIOFactory((HoodieStorage)storage).getFileFormatUtils(HoodieFileFormat.PARQUET);
    }

    public String[] readMinMaxRecordKeys() {
        return this.parquetUtils.readMinMaxRecordKeys(this.storage, this.path);
    }

    public BloomFilter readBloomFilter() {
        return this.parquetUtils.readBloomFilterFromMetadata(this.storage, this.path);
    }

    public Set<Pair<String, Long>> filterRowKeys(Set<String> candidateRowKeys) {
        return this.parquetUtils.filterRowKeys(this.storage, this.path, candidateRowKeys);
    }

    public ClosableIterator<HoodieRecord<InternalRow>> getRecordIterator(Schema readerSchema, Schema requestedSchema) throws IOException {
        return this.getRecordIterator(requestedSchema);
    }

    public ClosableIterator<HoodieRecord<InternalRow>> getRecordIterator(Schema schema) throws IOException {
        ClosableIterator<UnsafeRow> iterator = this.getUnsafeRowIterator(schema);
        return new CloseableMappingIterator(iterator, data -> (HoodieRecord)TypeUtils.unsafeCast((Object)((Object)new HoodieSparkRecord((UnsafeRow)data))));
    }

    public ClosableIterator<String> getRecordKeyIterator() throws IOException {
        Schema schema = HoodieAvroUtils.getRecordKeySchema();
        ClosableIterator<UnsafeRow> iterator = this.getUnsafeRowIterator(schema);
        return new CloseableMappingIterator(iterator, data -> {
            HoodieSparkRecord record = (HoodieSparkRecord)((Object)((Object)TypeUtils.unsafeCast((Object)((Object)new HoodieSparkRecord((UnsafeRow)data)))));
            return record.getRecordKey();
        });
    }

    public ClosableIterator<UnsafeRow> getUnsafeRowIterator(Schema requestedSchema) throws IOException {
        Schema nonNullSchema = AvroSchemaUtils.getNonNullTypeFromUnion((Schema)requestedSchema);
        StructType structSchema = HoodieInternalRowUtils.getCachedSchema(nonNullSchema);
        org.apache.hudi.common.util.Option messageSchema = org.apache.hudi.common.util.Option.of((Object)HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)((Configuration)this.storage.getConf().unwrapAs(Configuration.class))).convert(nonNullSchema));
        boolean enableTimestampFieldRepair = this.storage.getConf().getBoolean(ENABLE_LOGICAL_TIMESTAMP_REPAIR, true);
        StructType dataStructType = this.convertToStruct(enableTimestampFieldRepair ? SchemaRepair.repairLogicalTypes((MessageType)this.getFileSchema(), (org.apache.hudi.common.util.Option)messageSchema) : this.getFileSchema());
        SparkBasicSchemaEvolution evolution = new SparkBasicSchemaEvolution(dataStructType, structSchema, SQLConf.get().sessionLocalTimeZone());
        String readSchemaJson = evolution.getRequestSchema().json();
        this.storage.getConf().set("parquet.read.schema", readSchemaJson);
        this.storage.getConf().set(ParquetReadSupport.SPARK_ROW_REQUESTED_SCHEMA(), readSchemaJson);
        this.storage.getConf().set(SQLConf.PARQUET_BINARY_AS_STRING().key(), SQLConf.get().getConf(SQLConf.PARQUET_BINARY_AS_STRING()).toString());
        this.storage.getConf().set(SQLConf.PARQUET_INT96_AS_TIMESTAMP().key(), SQLConf.get().getConf(SQLConf.PARQUET_INT96_AS_TIMESTAMP()).toString());
        ParquetReader reader = ParquetReader.builder((ReadSupport)new HoodieParquetReadSupport((Option<ZoneId>)Option$.MODULE$.empty(), true, true, SparkAdapterSupport$.MODULE$.sparkAdapter().getRebaseSpec("CORRECTED"), SparkAdapterSupport$.MODULE$.sparkAdapter().getRebaseSpec("LEGACY"), (org.apache.hudi.common.util.Option<MessageType>)messageSchema), (Path)new Path(this.path.toUri())).withConf((Configuration)this.storage.getConf().unwrapAs(Configuration.class)).build();
        UnsafeProjection projection = evolution.generateUnsafeProjection();
        ParquetReaderIterator parquetReaderIterator = new ParquetReaderIterator(reader);
        CloseableMappingIterator projectedIterator = new CloseableMappingIterator((ClosableIterator)parquetReaderIterator, arg_0 -> ((UnsafeProjection)projection).apply(arg_0));
        this.readerIterators.add((ClosableIterator)projectedIterator);
        return projectedIterator;
    }

    private MessageType getFileSchema() {
        if (this.fileSchemaOption.isEmpty()) {
            MessageType messageType = ((ParquetUtils)this.parquetUtils).readSchema(this.storage, this.path);
            this.fileSchemaOption = org.apache.hudi.common.util.Option.of((Object)messageType);
        }
        return (MessageType)this.fileSchemaOption.get();
    }

    public Schema getSchema() {
        if (this.schemaOption.isEmpty()) {
            MessageType messageType = this.getFileSchema();
            StructType structType = this.getStructSchema();
            this.schemaOption = org.apache.hudi.common.util.Option.of((Object)SparkAdapterSupport$.MODULE$.sparkAdapter().getAvroSchemaConverters().toAvroType((DataType)structType, true, messageType.getName(), ""));
        }
        return (Schema)this.schemaOption.get();
    }

    protected StructType getStructSchema() {
        if (this.structTypeOption.isEmpty()) {
            MessageType messageType = this.getFileSchema();
            this.structTypeOption = org.apache.hudi.common.util.Option.of((Object)this.convertToStruct(messageType));
        }
        return (StructType)this.structTypeOption.get();
    }

    private StructType convertToStruct(MessageType messageType) {
        return new ParquetToSparkSchemaConverter((Configuration)this.storage.getConf().unwrapAs(Configuration.class)).convert(messageType);
    }

    public void close() {
        this.readerIterators.forEach(ClosableIterator::close);
    }

    public long getTotalRecords() {
        return this.parquetUtils.getRowCount(this.storage, this.path);
    }
}

