/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.io.storage.HoodieSparkFileWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.hudi.parquet.io.OutputStreamBackedOutputFile;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.unsafe.types.UTF8String;

public class HoodieSparkParquetStreamWriter
implements HoodieSparkFileWriter,
AutoCloseable {
    private final ParquetWriter<InternalRow> writer;
    private final HoodieRowParquetWriteSupport writeSupport;

    public HoodieSparkParquetStreamWriter(FSDataOutputStream outputStream, HoodieRowParquetConfig parquetConfig) throws IOException {
        this.writeSupport = (HoodieRowParquetWriteSupport)((Object)parquetConfig.getWriteSupport());
        this.writer = ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder((OutputFile)new OutputStreamBackedOutputFile(outputStream), this.writeSupport).withWriteMode(ParquetFileWriter.Mode.CREATE)).withCompressionCodec(parquetConfig.getCompressionCodecName())).withRowGroupSize(parquetConfig.getBlockSize())).withPageSize(parquetConfig.getPageSize())).withDictionaryPageSize(parquetConfig.getPageSize())).withDictionaryEncoding(parquetConfig.dictionaryEnabled())).withWriterVersion(ParquetWriter.DEFAULT_WRITER_VERSION)).withConf(parquetConfig.getHadoopConf())).build();
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public void writeRow(String key, InternalRow record) throws IOException {
        this.writer.write((Object)record);
        this.writeSupport.add(UTF8String.fromString((String)key));
    }

    @Override
    public void writeRowWithMetadata(HoodieKey key, InternalRow record) throws IOException {
        this.writeRow(key.getRecordKey(), record);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private final WriteSupport<T> writeSupport;

        private Builder(Path file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        private Builder(OutputFile file, WriteSupport<T> writeSupport) {
            super(file);
            this.writeSupport = writeSupport;
        }

        protected Builder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return this.writeSupport;
        }
    }
}

