/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieBloomFilterWriteSupport;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.HoodieUTF8StringFactory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.VersionUtils;
import scala.Enumeration;
import scala.Function1;

public class HoodieRowParquetWriteSupport
extends WriteSupport<InternalRow> {
    private static final Schema MAP_KEY_SCHEMA = Schema.create((Schema.Type)Schema.Type.STRING);
    private static final String MAP_REPEATED_NAME = "key_value";
    private static final String MAP_KEY_NAME = "key";
    private static final String MAP_VALUE_NAME = "value";
    private final Configuration hadoopConf;
    private final Option<HoodieBloomFilterWriteSupport<UTF8String>> bloomFilterWriteSupportOpt;
    private final byte[] decimalBuffer = new byte[Decimal.minBytesForPrecision()[DecimalType.MAX_PRECISION()]];
    private final Enumeration.Value datetimeRebaseMode = (Enumeration.Value)SparkAdapterSupport$.MODULE$.sparkAdapter().getDateTimeRebaseMode();
    private final Function1<Object, Object> dateRebaseFunction = DataSourceUtils.createDateRebaseFuncInWrite((Enumeration.Value)this.datetimeRebaseMode, (String)"Parquet");
    private final Function1<Object, Object> timestampRebaseFunction = DataSourceUtils.createTimestampRebaseFuncInWrite((Enumeration.Value)this.datetimeRebaseMode, (String)"Parquet");
    private final boolean writeLegacyListFormat;
    private final ValueWriter[] rootFieldWriters;
    private final Schema avroSchema;
    private final StructType structType;
    private RecordConsumer recordConsumer;

    public HoodieRowParquetWriteSupport(Configuration conf, StructType structType, Option<BloomFilter> bloomFilterOpt, HoodieConfig config) {
        Configuration hadoopConf = new Configuration(conf);
        String writeLegacyFormatEnabled = config.getStringOrDefault(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED, "false");
        hadoopConf.set("spark.sql.parquet.writeLegacyFormat", writeLegacyFormatEnabled);
        hadoopConf.set("spark.sql.parquet.outputTimestampType", config.getStringOrDefault(HoodieStorageConfig.PARQUET_OUTPUT_TIMESTAMP_TYPE));
        hadoopConf.set("spark.sql.parquet.fieldId.write.enabled", config.getStringOrDefault(HoodieStorageConfig.PARQUET_FIELD_ID_WRITE_ENABLED));
        this.writeLegacyListFormat = Boolean.parseBoolean(writeLegacyFormatEnabled) || Boolean.parseBoolean(config.getStringOrDefault("parquet.avro.write-old-list-structure", "false"));
        this.structType = structType;
        this.avroSchema = (Schema)SerDeHelper.fromJson((String)config.getString(HoodieWriteConfig.INTERNAL_SCHEMA_STRING)).map(internalSchema -> AvroInternalSchemaConverter.convert((InternalSchema)internalSchema, (String)"spark_schema")).orElseGet(() -> {
            String schemaString = (String)Option.ofNullable((Object)config.getString(HoodieWriteConfig.WRITE_SCHEMA_OVERRIDE)).orElseGet(() -> config.getString(HoodieWriteConfig.AVRO_SCHEMA_STRING));
            Schema parsedSchema = new Schema.Parser().parse(schemaString);
            return HoodieAvroUtils.addMetadataFields((Schema)parsedSchema, (boolean)config.getBooleanOrDefault(HoodieWriteConfig.ALLOW_OPERATION_METADATA_FIELD));
        });
        ParquetWriteSupport.setSchema((StructType)structType, (Configuration)hadoopConf);
        this.rootFieldWriters = this.getFieldWriters(structType, this.avroSchema);
        this.hadoopConf = hadoopConf;
        this.bloomFilterWriteSupportOpt = bloomFilterOpt.map(HoodieBloomFilterRowWriteSupport::new);
    }

    private ValueWriter[] getFieldWriters(StructType schema, Schema avroSchema) {
        return (ValueWriter[])Arrays.stream(schema.fields()).map(field -> {
            Schema.Field avroField = avroSchema == null ? null : avroSchema.getField(field.name());
            return this.makeWriter(avroField == null ? null : avroField.schema(), field.dataType());
        }).toArray(ValueWriter[]::new);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("org.apache.spark.version", VersionUtils.shortVersion((String)HoodieSparkUtils.getSparkVersion()));
        if (SparkAdapterSupport$.MODULE$.sparkAdapter().isLegacyBehaviorPolicy(this.datetimeRebaseMode)) {
            metadata.put("org.apache.spark.legacyDateTime", "");
            metadata.put("org.apache.spark.timeZone", SQLConf.get().sessionLocalTimeZone());
        }
        Configuration configurationCopy = new Configuration(configuration);
        configurationCopy.set("parquet.avro.write-old-list-structure", Boolean.toString(this.writeLegacyListFormat));
        MessageType messageType = this.convert(this.structType, this.avroSchema);
        return new WriteSupport.WriteContext(messageType, metadata);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(InternalRow row) {
        this.consumeMessage(() -> this.writeFields(row, this.structType, this.rootFieldWriters));
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Map extraMetadata = (Map)this.bloomFilterWriteSupportOpt.map(HoodieBloomFilterWriteSupport::finalizeMetadata).orElse(Collections.emptyMap());
        return new WriteSupport.FinalizedWriteContext(extraMetadata);
    }

    public void add(UTF8String recordKey) {
        this.bloomFilterWriteSupportOpt.ifPresent(bloomFilterWriteSupport -> bloomFilterWriteSupport.addKey((Comparable)recordKey));
    }

    private void consumeMessage(Runnable writer) {
        this.recordConsumer.startMessage();
        writer.run();
        this.recordConsumer.endMessage();
    }

    private void consumeGroup(Runnable writer) {
        this.recordConsumer.startGroup();
        writer.run();
        this.recordConsumer.endGroup();
    }

    private void consumeField(String field, int index, Runnable writer) {
        this.recordConsumer.startField(field, index);
        writer.run();
        this.recordConsumer.endField(field, index);
    }

    private void writeFields(InternalRow row, StructType schema, ValueWriter[] fieldWriters) {
        for (int i = 0; i < row.numFields(); ++i) {
            int index = i;
            if (row.isNullAt(i)) continue;
            this.consumeField(schema.fields()[i].name(), index, () -> fieldWriters[index].write((SpecializedGetters)row, index));
        }
    }

    private ValueWriter makeWriter(Schema avroSchema, DataType dataType) {
        LogicalType logicalType;
        Schema resolvedSchema = avroSchema == null ? null : AvroSchemaUtils.getNonNullTypeFromUnion((Schema)avroSchema);
        LogicalType logicalType2 = logicalType = resolvedSchema != null ? resolvedSchema.getLogicalType() : null;
        if (dataType == DataTypes.BooleanType) {
            return (row, ordinal) -> this.recordConsumer.addBoolean(row.getBoolean(ordinal));
        }
        if (dataType == DataTypes.DateType) {
            return (row, ordinal) -> this.recordConsumer.addInteger(((Integer)this.dateRebaseFunction.apply((Object)row.getInt(ordinal))).intValue());
        }
        if (dataType == DataTypes.ShortType) {
            return (row, ordinal) -> this.recordConsumer.addInteger((int)row.getShort(ordinal));
        }
        if (dataType == DataTypes.IntegerType || dataType instanceof YearMonthIntervalType) {
            return (row, ordinal) -> this.recordConsumer.addInteger(row.getInt(ordinal));
        }
        if (dataType == DataTypes.LongType || dataType instanceof DayTimeIntervalType) {
            return (row, ordinal) -> this.recordConsumer.addLong(row.getLong(ordinal));
        }
        if (dataType == DataTypes.TimestampType) {
            if (logicalType == null || logicalType.getName().equals(LogicalTypes.timestampMicros().getName())) {
                return (row, ordinal) -> this.recordConsumer.addLong(((Long)this.timestampRebaseFunction.apply((Object)row.getLong(ordinal))).longValue());
            }
            if (logicalType.getName().equals(LogicalTypes.timestampMillis().getName())) {
                return (row, ordinal) -> this.recordConsumer.addLong(DateTimeUtils.microsToMillis((long)((Long)this.timestampRebaseFunction.apply((Object)row.getLong(ordinal)))));
            }
            throw new UnsupportedOperationException("Unsupported Avro logical type for TimestampType: " + logicalType);
        }
        if (SparkAdapterSupport$.MODULE$.sparkAdapter().isTimestampNTZType(dataType)) {
            if (logicalType == null || logicalType.getName().equals(LogicalTypes.localTimestampMicros().getName())) {
                return (row, ordinal) -> this.recordConsumer.addLong(row.getLong(ordinal));
            }
            if (logicalType.getName().equals(LogicalTypes.localTimestampMillis().getName())) {
                return (row, ordinal) -> this.recordConsumer.addLong(DateTimeUtils.microsToMillis((long)row.getLong(ordinal)));
            }
            throw new UnsupportedOperationException("Unsupported Avro logical type for TimestampNTZType: " + logicalType);
        }
        if (dataType == DataTypes.FloatType) {
            return (row, ordinal) -> this.recordConsumer.addFloat(row.getFloat(ordinal));
        }
        if (dataType == DataTypes.DoubleType) {
            return (row, ordinal) -> this.recordConsumer.addDouble(row.getDouble(ordinal));
        }
        if (dataType == DataTypes.StringType) {
            return (row, ordinal) -> this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
        }
        if (dataType == DataTypes.BinaryType) {
            return (row, ordinal) -> this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
        }
        if (dataType instanceof DecimalType) {
            return (row, ordinal) -> {
                byte[] fixedLengthBytes;
                int precision = ((DecimalType)dataType).precision();
                ValidationUtils.checkArgument((precision <= DecimalType.MAX_PRECISION() ? 1 : 0) != 0, () -> String.format("Decimal precision %s exceeds max precision %s", precision, DecimalType.MAX_PRECISION()));
                int scale = ((DecimalType)dataType).scale();
                byte[] bytes = row.getDecimal(ordinal, precision, scale).toJavaBigDecimal().unscaledValue().toByteArray();
                int numBytes = Decimal.minBytesForPrecision()[precision];
                if (bytes.length == numBytes) {
                    fixedLengthBytes = bytes;
                } else {
                    byte signByte = bytes[0] < 0 ? (byte)-1 : (byte)0;
                    Arrays.fill(this.decimalBuffer, 0, numBytes - bytes.length, signByte);
                    System.arraycopy(bytes, 0, this.decimalBuffer, numBytes - bytes.length, bytes.length);
                    fixedLengthBytes = this.decimalBuffer;
                }
                this.recordConsumer.addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes));
            };
        }
        if (dataType instanceof ArrayType) {
            ValueWriter elementWriter = this.makeWriter(resolvedSchema == null ? null : resolvedSchema.getElementType(), ((ArrayType)dataType).elementType());
            if (!this.writeLegacyListFormat) {
                return this.threeLevelArrayWriter("list", "element", elementWriter);
            }
            if (((ArrayType)dataType).containsNull()) {
                return this.threeLevelArrayWriter("bag", "array", elementWriter);
            }
            return this.twoLevelArrayWriter("array", elementWriter);
        }
        if (dataType instanceof MapType) {
            ValueWriter keyWriter = this.makeWriter(MAP_KEY_SCHEMA, DataTypes.StringType);
            ValueWriter valueWriter = this.makeWriter(resolvedSchema == null ? null : resolvedSchema.getValueType(), ((MapType)dataType).valueType());
            return (row, ordinal) -> {
                MapData mapData = row.getMap(ordinal);
                ArrayData keyArray = mapData.keyArray();
                ArrayData valueArray = mapData.valueArray();
                this.consumeGroup(() -> {
                    if (mapData.numElements() > 0) {
                        this.consumeField(MAP_REPEATED_NAME, 0, () -> {
                            int i = 0;
                            while (i < mapData.numElements()) {
                                int index = i++;
                                this.consumeGroup(() -> {
                                    this.consumeField(MAP_KEY_NAME, 0, () -> keyWriter.write((SpecializedGetters)keyArray, index));
                                    if (!valueArray.isNullAt(index)) {
                                        this.consumeField(MAP_VALUE_NAME, 1, () -> valueWriter.write((SpecializedGetters)valueArray, index));
                                    }
                                });
                            }
                        });
                    }
                });
            };
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            ValueWriter[] fieldWriters = this.getFieldWriters(structType, resolvedSchema);
            return (row, ordinal) -> {
                InternalRow struct = row.getStruct(ordinal, fieldWriters.length);
                this.consumeGroup(() -> this.writeFields(struct, structType, fieldWriters));
            };
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    private ValueWriter twoLevelArrayWriter(String repeatedFieldName, ValueWriter elementWriter) {
        return (row, ordinal) -> {
            ArrayData array = row.getArray(ordinal);
            this.consumeGroup(() -> {
                if (array.numElements() > 0) {
                    this.consumeField(repeatedFieldName, 0, () -> {
                        for (int i = 0; i < array.numElements(); ++i) {
                            elementWriter.write((SpecializedGetters)row.getArray(ordinal), i);
                        }
                    });
                }
            });
        };
    }

    private ValueWriter threeLevelArrayWriter(String repeatedFieldName, String elementFieldName, ValueWriter elementWriter) {
        return (row, ordinal) -> {
            ArrayData array = row.getArray(ordinal);
            this.consumeGroup(() -> {
                if (array.numElements() > 0) {
                    this.consumeField(repeatedFieldName, 0, () -> {
                        int i = 0;
                        while (i < array.numElements()) {
                            int index = i++;
                            this.consumeGroup(() -> {
                                if (!array.isNullAt(index)) {
                                    this.consumeField(elementFieldName, 0, () -> elementWriter.write((SpecializedGetters)array, index));
                                }
                            });
                        }
                    });
                }
            });
        };
    }

    public static HoodieRowParquetWriteSupport getHoodieRowParquetWriteSupport(Configuration conf, StructType structType, Option<BloomFilter> bloomFilterOpt, HoodieConfig config) {
        return (HoodieRowParquetWriteSupport)((Object)ReflectionUtils.loadClass((String)config.getStringOrDefault(HoodieStorageConfig.HOODIE_PARQUET_SPARK_ROW_WRITE_SUPPORT_CLASS), (Class[])new Class[]{Configuration.class, StructType.class, Option.class, HoodieConfig.class}, (Object[])new Object[]{conf, structType, bloomFilterOpt, config}));
    }

    private MessageType convert(StructType structType, Schema avroSchema) {
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields((Type[])Arrays.stream(structType.fields()).map(field -> {
            Schema.Field avroField = avroSchema.getField(field.name());
            return this.convertField(avroField == null ? null : avroField.schema(), (StructField)field);
        }).toArray(Type[]::new))).named("spark_schema");
    }

    private Type convertField(Schema avroFieldSchema, StructField structField) {
        Type type = this.convertField(avroFieldSchema, structField, structField.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
        if (ParquetUtils.hasFieldId((StructField)structField)) {
            return type.withId(ParquetUtils.getFieldId((StructField)structField));
        }
        return type;
    }

    private Type convertField(Schema avroFieldSchema, StructField structField, Type.Repetition repetition) {
        Schema resolvedSchema = avroFieldSchema == null ? null : AvroSchemaUtils.getNonNullTypeFromUnion((Schema)avroFieldSchema);
        LogicalType logicalType = resolvedSchema != null ? resolvedSchema.getLogicalType() : null;
        DataType dataType = structField.dataType();
        if (dataType == DataTypes.BooleanType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType == DataTypes.DateType) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named(structField.name());
        }
        if (dataType == DataTypes.ShortType) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named(structField.name());
        }
        if (dataType == DataTypes.IntegerType || dataType instanceof YearMonthIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType == DataTypes.LongType || dataType instanceof DayTimeIntervalType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType == DataTypes.TimestampType) {
            if (logicalType == null || logicalType.getName().equals(LogicalTypes.timestampMicros().getName())) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(structField.name());
            }
            if (logicalType.getName().equals(LogicalTypes.timestampMillis().getName())) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(structField.name());
            }
            throw new UnsupportedOperationException("Unsupported timestamp type: " + logicalType);
        }
        if (SparkAdapterSupport$.MODULE$.sparkAdapter().isTimestampNTZType(dataType)) {
            if (logicalType == null || logicalType.getName().equals(LogicalTypes.localTimestampMicros().getName())) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named(structField.name());
            }
            if (logicalType.getName().equals(LogicalTypes.localTimestampMillis().getName())) {
                return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named(structField.name());
            }
            throw new UnsupportedOperationException("Unsupported timestamp type: " + logicalType);
        }
        if (dataType == DataTypes.FloatType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType == DataTypes.DoubleType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType == DataTypes.StringType) {
            return (Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named(structField.name());
        }
        if (dataType == DataTypes.BinaryType) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(structField.name());
        }
        if (dataType instanceof DecimalType) {
            int precision = ((DecimalType)dataType).precision();
            int scale = ((DecimalType)dataType).scale();
            return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)scale, (int)precision))).length(Decimal.minBytesForPrecision()[precision])).named(structField.name());
        }
        if (dataType instanceof ArrayType) {
            Schema avroElementSchema;
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            Schema schema = avroElementSchema = resolvedSchema == null ? null : resolvedSchema.getElementType();
            if (!this.writeLegacyListFormat) {
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)((Types.GroupBuilder)Types.repeatedGroup().addField(this.convertField(avroElementSchema, new StructField("element", elementType, arrayType.containsNull(), Metadata.empty())))).named("list"))).named(structField.name());
            }
            if (arrayType.containsNull()) {
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField((Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(avroElementSchema, new StructField("array", elementType, true, Metadata.empty())))).named("bag"))).named(structField.name());
            }
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).addField(this.convertField(avroElementSchema, new StructField("array", elementType, false, Metadata.empty()), Type.Repetition.REPEATED))).named(structField.name());
        }
        if (dataType instanceof MapType) {
            Schema avroValueSchema = resolvedSchema == null ? null : resolvedSchema.getValueType();
            MapType mapType = (MapType)dataType;
            return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)repetition).as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).addField((Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.repeatedGroup().addField(this.convertField(MAP_KEY_SCHEMA, new StructField(MAP_KEY_NAME, DataTypes.StringType, false, Metadata.empty())))).addField(this.convertField(avroValueSchema, new StructField(MAP_VALUE_NAME, mapType.valueType(), mapType.valueContainsNull(), Metadata.empty())))).named(MAP_REPEATED_NAME))).named(structField.name());
        }
        if (dataType instanceof StructType) {
            Types.GroupBuilder groupBuilder = Types.buildGroup((Type.Repetition)repetition);
            Arrays.stream(((StructType)dataType).fields()).forEach(field -> {
                Schema.Field avroField = resolvedSchema == null ? null : resolvedSchema.getField(field.name());
                groupBuilder.addField(this.convertField(avroField == null ? null : avroField.schema(), (StructField)field));
            });
            return (Type)groupBuilder.named(structField.name());
        }
        throw new UnsupportedOperationException("Unsupported type: " + dataType);
    }

    private static class HoodieBloomFilterRowWriteSupport
    extends HoodieBloomFilterWriteSupport<UTF8String> {
        private static final HoodieUTF8StringFactory UTF8STRING_FACTORY = SparkAdapterSupport$.MODULE$.sparkAdapter().getUTF8StringFactory();

        public HoodieBloomFilterRowWriteSupport(BloomFilter bloomFilter) {
            super(bloomFilter);
        }

        protected int compareRecordKey(UTF8String a, UTF8String b) {
            return UTF8STRING_FACTORY.wrapUTF8String(a).compareTo(UTF8STRING_FACTORY.wrapUTF8String(b));
        }

        protected byte[] getUTF8Bytes(UTF8String key) {
            return key.getBytes();
        }

        protected UTF8String dereference(UTF8String key) {
            return key.clone();
        }
    }

    @FunctionalInterface
    private static interface ValueWriter {
        public void write(SpecializedGetters var1, int var2);
    }
}

