/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkRecordMergingUtils {
    private static final Map<Schema, Map<Integer, StructField>> FIELD_ID_TO_FIELD_MAPPING_CACHE = new ConcurrentHashMap<Schema, Map<Integer, StructField>>();
    private static final Map<Schema, Map<String, Integer>> FIELD_NAME_TO_ID_MAPPING_CACHE = new ConcurrentHashMap<Schema, Map<String, Integer>>();
    private static final Map<Pair<Pair<Schema, Schema>, Schema>, Pair<Map<Integer, StructField>, Pair<StructType, Schema>>> MERGED_SCHEMA_CACHE = new ConcurrentHashMap<Pair<Pair<Schema, Schema>, Schema>, Pair<Map<Integer, StructField>, Pair<StructType, Schema>>>();

    public static BufferedRecord<InternalRow> mergePartialRecords(BufferedRecord<InternalRow> older, Schema oldSchema, BufferedRecord<InternalRow> newer, Schema newSchema, Schema readerSchema, RecordContext<InternalRow> recordContext) {
        Pair<Map<Integer, StructField>, Pair<StructType, Schema>> mergedSchemaPair = SparkRecordMergingUtils.getCachedMergedSchema(oldSchema, newSchema, readerSchema);
        boolean isNewerPartial = SparkRecordMergingUtils.isPartial(newSchema, (Schema)((Pair)mergedSchemaPair.getRight()).getRight());
        if (isNewerPartial) {
            InternalRow oldRow = (InternalRow)older.getRecord();
            InternalRow newPartialRow = (InternalRow)newer.getRecord();
            Map mergedIdToFieldMapping = (Map)mergedSchemaPair.getLeft();
            Map<String, Integer> oldNameToIdMapping = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(oldSchema);
            Map<String, Integer> newPartialNameToIdMapping = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(newSchema);
            ArrayList<Object> values = new ArrayList<Object>(mergedIdToFieldMapping.size());
            for (int fieldId = 0; fieldId < mergedIdToFieldMapping.size(); ++fieldId) {
                StructField structField = (StructField)mergedIdToFieldMapping.get(fieldId);
                Integer ordInPartialUpdate = newPartialNameToIdMapping.get(structField.name());
                if (ordInPartialUpdate != null) {
                    values.add(newPartialRow.get(ordInPartialUpdate.intValue(), structField.dataType()));
                    continue;
                }
                values.add(oldRow.get(oldNameToIdMapping.get(structField.name()).intValue(), structField.dataType()));
            }
            GenericInternalRow mergedRow = new GenericInternalRow(values.toArray());
            return BufferedRecords.fromEngineRecord((Object)mergedRow, (Schema)((Schema)((Pair)mergedSchemaPair.getRight()).getRight()), recordContext, (Comparable)newer.getOrderingValue(), (String)newer.getRecordKey(), (boolean)newer.isDelete());
        }
        return newer;
    }

    public static Map<Integer, StructField> getCachedFieldIdToFieldMapping(Schema avroSchema) {
        return FIELD_ID_TO_FIELD_MAPPING_CACHE.computeIfAbsent(avroSchema, schema -> {
            StructType structType = HoodieInternalRowUtils.getCachedSchema(schema);
            HashMap<Integer, StructField> schemaFieldIdMapping = new HashMap<Integer, StructField>();
            int fieldId = 0;
            for (StructField field : structType.fields()) {
                schemaFieldIdMapping.put(fieldId, field);
                ++fieldId;
            }
            return schemaFieldIdMapping;
        });
    }

    public static Map<String, Integer> getCachedFieldNameToIdMapping(Schema avroSchema) {
        return FIELD_NAME_TO_ID_MAPPING_CACHE.computeIfAbsent(avroSchema, schema -> {
            StructType structType = HoodieInternalRowUtils.getCachedSchema(schema);
            HashMap<String, Integer> schemaFieldIdMapping = new HashMap<String, Integer>();
            int fieldId = 0;
            for (StructField field : structType.fields()) {
                schemaFieldIdMapping.put(field.name(), fieldId);
                ++fieldId;
            }
            return schemaFieldIdMapping;
        });
    }

    public static Pair<Map<Integer, StructField>, Pair<StructType, Schema>> getCachedMergedSchema(Schema oldSchema, Schema newSchema, Schema readerSchema) {
        return MERGED_SCHEMA_CACHE.computeIfAbsent((Pair<Pair<Schema, Schema>, Schema>)Pair.of((Object)Pair.of((Object)oldSchema, (Object)newSchema), (Object)readerSchema), schemaPair -> {
            Schema schema1 = (Schema)((Pair)schemaPair.getLeft()).getLeft();
            Schema schema2 = (Schema)((Pair)schemaPair.getLeft()).getRight();
            Schema refSchema = (Schema)schemaPair.getRight();
            Map<String, Integer> nameToIdMapping1 = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(schema1);
            Map<String, Integer> nameToIdMapping2 = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(schema2);
            Map<Integer, StructField> refFieldIdToFieldMapping = SparkRecordMergingUtils.getCachedFieldIdToFieldMapping(refSchema);
            HashSet<String> fieldNameSet = new HashSet<String>();
            fieldNameSet.addAll(nameToIdMapping1.keySet());
            fieldNameSet.addAll(nameToIdMapping2.keySet());
            int fieldId = 0;
            HashMap<Integer, StructField> mergedMapping = new HashMap<Integer, StructField>();
            ArrayList<StructField> mergedFieldList = new ArrayList<StructField>();
            for (int i = 0; i < refFieldIdToFieldMapping.size(); ++i) {
                StructField field = refFieldIdToFieldMapping.get(i);
                if (!fieldNameSet.contains(field.name())) continue;
                mergedMapping.put(fieldId, field);
                mergedFieldList.add(field);
                ++fieldId;
            }
            StructType mergedStructType = new StructType(mergedFieldList.toArray(new StructField[0]));
            Schema mergedSchema = AvroSchemaCache.intern((Schema)AvroConversionUtils.convertStructTypeToAvroSchema((DataType)mergedStructType, readerSchema.getName(), readerSchema.getNamespace()));
            return Pair.of(mergedMapping, (Object)Pair.of((Object)mergedStructType, (Object)mergedSchema));
        });
    }

    public static boolean isPartial(Schema schema, Schema mergedSchema) {
        return !schema.equals((Object)mergedSchema);
    }
}

