/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDMetadataWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.index.HoodieSparkIndexClient;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriterTableVersionSix;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.MetadataTableFileGroupIndexParser;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkHoodieBackedTableMetadataWriterTableVersionSix
extends HoodieBackedTableMetadataWriterTableVersionSix<JavaRDD<HoodieRecord>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkHoodieBackedTableMetadataWriter.class);

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriterTableVersionSix(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriterTableVersionSix(conf, writeConfig, failedWritesCleaningPolicy, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        return SparkHoodieBackedTableMetadataWriterTableVersionSix.create(conf, writeConfig, context, (Option<String>)Option.empty());
    }

    SparkHoodieBackedTableMetadataWriterTableVersionSix(StorageConfiguration<?> hadoopConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        super(hadoopConf, writeConfig, failedWritesCleaningPolicy, engineContext, inflightInstantTimestamp);
    }

    protected void initRegistry() {
        if (this.metadataWriteConfig.isMetricsOn()) {
            if (this.metadataWriteConfig.isExecutorMetricsEnabled() && this.metadataWriteConfig.getMetricsReporterType() != MetricsReporterType.INMEMORY) {
                Registry registry = Registry.getRegistry((String)"HoodieMetadata", (String)DistributedRegistry.class.getName());
                HoodieSparkEngineContext sparkEngineContext = (HoodieSparkEngineContext)this.engineContext;
                ((DistributedRegistry)registry).register(sparkEngineContext.getJavaSparkContext());
            } else {
                Registry registry = Registry.getRegistry((String)"HoodieMetadata");
            }
            this.metrics = Option.of((Object)new HoodieMetadataMetrics(this.metadataWriteConfig.getMetricsConfig(), this.dataMetaClient.getStorage()));
        } else {
            this.metrics = Option.empty();
        }
    }

    protected void commit(String instantTime, Map<String, HoodieData<HoodieRecord>> partitionRecordsMap) {
        this.commitInternal(instantTime, partitionRecordsMap, false, Option.empty());
    }

    protected JavaRDD<HoodieRecord> convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> records) {
        return HoodieJavaRDD.getJavaRDD(records);
    }

    protected HoodieData<WriteStatus> convertEngineSpecificDataToHoodieData(JavaRDD<WriteStatus> records) {
        throw new HoodieNotSupportedException("Unsupported flow for table version 6");
    }

    protected void bulkInsertAndCommit(BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, JavaRDD<WriteStatus>> writeClient, String instantTime, JavaRDD<HoodieRecord> preppedRecordInputs, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        JavaRDD writeStatusJavaRDD = (JavaRDD)writeClient.bulkInsertPreppedRecords(preppedRecordInputs, instantTime, bulkInsertPartitioner);
        writeClient.commit(instantTime, (Object)writeStatusJavaRDD, Option.empty(), "deltacommit", Collections.emptyMap());
    }

    protected void upsertAndCommit(BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, JavaRDD<WriteStatus>> writeClient, String instantTime, JavaRDD<HoodieRecord> preppedRecordInputs) {
        int parallelism = this.dataWriteConfig.getMetadataConfig().getRecordPreparationParallelism();
        if (parallelism > 0 && preppedRecordInputs.getNumPartitions() > parallelism) {
            preppedRecordInputs = preppedRecordInputs.coalesce(parallelism);
        }
        JavaRDD writeStatusJavaRDD = (JavaRDD)writeClient.upsertPreppedRecords(preppedRecordInputs, instantTime);
        writeClient.commit(instantTime, (Object)writeStatusJavaRDD, Option.empty(), "deltacommit", Collections.emptyMap());
    }

    protected void upsertAndCommit(BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, JavaRDD<WriteStatus>> writeClient, String instantTime, JavaRDD<HoodieRecord> preppedRecordInputs, List<HoodieFileGroupId> fileGroupsIdsToUpdate) {
        JavaRDD writeStatusJavaRDD = (JavaRDD)writeClient.upsertPreppedRecords(preppedRecordInputs, instantTime);
        writeClient.commit(instantTime, (Object)writeStatusJavaRDD, Option.empty(), "deltacommit", Collections.emptyMap());
    }

    protected void bulkCommit(String instantTime, String partitionPath, HoodieData<HoodieRecord> records, MetadataTableFileGroupIndexParser indexParser) {
        SparkHoodieMetadataBulkInsertPartitioner partitioner = new SparkHoodieMetadataBulkInsertPartitioner(indexParser);
        this.commitInternal(instantTime, Collections.singletonMap(partitionPath, records), true, Option.of((Object)partitioner));
    }

    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        List<String> partitionsToDrop = partitions.stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toList());
        LOG.info("Deleting Metadata Table partitions: {}", partitionsToDrop);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.getWriteClient();
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)WriteOperationType.DELETE_PARTITION, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        writeClient.startCommitForMetadataTable(this.metadataMetaClient, instantTime, actionType);
        HoodieWriteResult result = writeClient.deletePartitions(partitionsToDrop, instantTime);
        writeClient.commit(instantTime, result.getWriteStatuses(), Option.empty(), "replacecommit", result.getPartitionToReplaceFileIds());
    }

    public BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, JavaRDD<WriteStatus>> initializeWriteClient() {
        return new SparkRDDMetadataWriteClient(this.engineContext, this.metadataWriteConfig, (Option<EmbeddedTimelineService>)Option.empty());
    }

    protected EngineType getEngineType() {
        return EngineType.SPARK;
    }

    protected void updateColumnsToIndexWithColStats(List<String> columnsToIndex) {
        new HoodieSparkIndexClient(this.dataWriteConfig, this.engineContext).createOrUpdateColumnStatsIndexDefinition(this.dataMetaClient, columnsToIndex);
    }

    protected HoodieData<HoodieRecord> getExpressionIndexRecords(List<Pair<String, Pair<String, Long>>> partitionFilePathAndSizeTriplet, HoodieIndexDefinition indexDefinition, HoodieTableMetaClient metaClient, int parallelism, Schema tableSchema, Schema readerSchema, StorageConfiguration<?> storageConf, String instantTime) {
        throw new HoodieNotSupportedException("Expression index not supported for Java metadata table writer yet.");
    }
}

