/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataTableFileGroupIndexParser;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import scala.Tuple2;

public class SparkHoodieMetadataBulkInsertPartitioner
implements BulkInsertPartitioner<JavaRDD<HoodieRecord>> {
    private final MetadataTableFileGroupIndexParser fileGroupIndexParser;
    private List<String> fileIDPfxs;

    public SparkHoodieMetadataBulkInsertPartitioner(MetadataTableFileGroupIndexParser indexParser) {
        this.fileGroupIndexParser = indexParser;
    }

    public JavaRDD<HoodieRecord> repartitionRecords(JavaRDD<HoodieRecord> records, int outputSparkPartitions) {
        Comparator keyComparator = (Comparator & Serializable)(t1, t2) -> ((String)t1._2).compareTo((String)t2._2);
        JavaRDD partitionedRDD = records.keyBy((Function & Serializable)r -> {
            int fileGroupIndex = this.fileGroupIndexParser.getFileGroupIndex(r.getCurrentLocation().getFileId());
            return new Tuple2((Object)fileGroupIndex, (Object)r.getRecordKey());
        }).repartitionAndSortWithinPartitions((Partitioner)new FileGroupPartitioner(), keyComparator).map((Function & Serializable)t -> (HoodieRecord)t._2);
        this.fileIDPfxs = partitionedRDD.mapPartitions((FlatMapFunction & Serializable)recordItr -> {
            ArrayList<String> fileIds = new ArrayList<String>(1);
            if (recordItr.hasNext()) {
                HoodieRecord record = (HoodieRecord)recordItr.next();
                String fileID = HoodieTableMetadataUtil.getFileGroupPrefix((String)record.getCurrentLocation().getFileId());
                fileIds.add(fileID);
            } else {
                fileIds.add("");
            }
            return fileIds.iterator();
        }, true).collect();
        ValidationUtils.checkArgument((partitionedRDD.getNumPartitions() == this.fileIDPfxs.size() ? 1 : 0) != 0, (String)String.format("Generated fileIDPfxs (%d) are lesser in size than the partitions %d", this.fileIDPfxs.size(), partitionedRDD.getNumPartitions()));
        return partitionedRDD;
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    public String getFileIdPfx(int partitionId) {
        return this.fileIDPfxs.get(partitionId);
    }

    private class FileGroupPartitioner
    extends Partitioner {
        private FileGroupPartitioner() {
        }

        public int getPartition(Object key) {
            return (Integer)((Tuple2)key)._1;
        }

        public int numPartitions() {
            return SparkHoodieMetadataBulkInsertPartitioner.this.fileGroupIndexParser.getNumberOfFileGroups();
        }
    }
}

