/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sort;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.optimize.HilbertCurveUtils;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.hudi.execution.ByteArraySorting;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.davidmoten.hilbert.HilbertCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Seq;

public class SpaceCurveSortingHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceCurveSortingHelper.class);

    public static Dataset<Row> orderDataFrameByMappingValues(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, List<String> orderByCols, int targetPartitionCount) {
        JavaRDD<Row> sortedRDD;
        Map columnsMap = Arrays.stream(df.schema().fields()).collect(Collectors.toMap(StructField::name, java.util.function.Function.identity()));
        List checkCols = orderByCols.stream().filter(columnsMap::containsKey).collect(Collectors.toList());
        if (orderByCols.size() != checkCols.size()) {
            LOG.error(String.format("Trying to ordering over a column(s) not present in the schema (%s); skipping", CollectionUtils.diff(orderByCols, checkCols)));
            return df;
        }
        if (orderByCols.size() == 1) {
            String orderByColName = orderByCols.get(0);
            LOG.debug("Single column to order by ({}), skipping space-curve ordering", (Object)orderByColName);
            return df.repartitionByRange(targetPartitionCount, new Column[]{new Column(orderByColName)});
        }
        int fieldNum = df.schema().fields().length;
        Map<Integer, StructField> fieldMap = orderByCols.stream().collect(Collectors.toMap(e -> Arrays.asList(df.schema().fields()).indexOf(columnsMap.get(e)), columnsMap::get));
        switch (layoutOptStrategy) {
            case ZORDER: {
                sortedRDD = SpaceCurveSortingHelper.createZCurveSortedRDD((JavaRDD<Row>)df.toJavaRDD(), fieldMap, fieldNum, targetPartitionCount);
                break;
            }
            case HILBERT: {
                sortedRDD = SpaceCurveSortingHelper.createHilbertSortedRDD((JavaRDD<Row>)df.toJavaRDD(), fieldMap, fieldNum, targetPartitionCount);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Not supported layout-optimization strategy (%s)", layoutOptStrategy));
            }
        }
        StructType newStructType = SpaceCurveSortingHelper.composeOrderedRDDStructType(df.schema());
        return df.sparkSession().createDataFrame(sortedRDD, newStructType).drop("Index");
    }

    private static StructType composeOrderedRDDStructType(StructType schema) {
        return StructType$.MODULE$.apply(CollectionUtils.combine(Arrays.asList(schema.fields()), Collections.singletonList(new StructField("Index", (DataType)BinaryType$.MODULE$, true, Metadata.empty()))));
    }

    private static JavaRDD<Row> createZCurveSortedRDD(JavaRDD<Row> originRDD, Map<Integer, StructField> fieldMap, int fieldNum, int fileNum) {
        return originRDD.map((Function & Serializable)row -> {
            byte[][] zBytes = (byte[][])fieldMap.entrySet().stream().map(entry -> {
                int index = (Integer)entry.getKey();
                StructField field = (StructField)entry.getValue();
                return SpaceCurveSortingHelper.mapColumnValueTo8Bytes(row, index, field.dataType());
            }).toArray(x$0 -> new byte[x$0][]);
            byte[] zOrdinalBytes = BinaryUtil.interleaving((byte[][])zBytes, (int)8);
            return SpaceCurveSortingHelper.appendToRow(row, zOrdinalBytes);
        }).sortBy((Function & Serializable)f -> new ByteArraySorting((byte[])f.get(fieldNum)), true, fileNum);
    }

    private static JavaRDD<Row> createHilbertSortedRDD(JavaRDD<Row> originRDD, final Map<Integer, StructField> fieldMap, int fieldNum, int fileNum) {
        return originRDD.mapPartitions((FlatMapFunction & Serializable)rows -> {
            final HilbertCurve hilbertCurve = HilbertCurve.bits((int)63).dimensions(fieldMap.size());
            return new Iterator<Row>(){

                @Override
                public boolean hasNext() {
                    return rows.hasNext();
                }

                @Override
                public Row next() {
                    Row row = (Row)rows.next();
                    long[] longs = fieldMap.entrySet().stream().mapToLong(entry -> {
                        int index = (Integer)entry.getKey();
                        StructField field = (StructField)entry.getValue();
                        return SpaceCurveSortingHelper.mapColumnValueToLong(row, index, field.dataType());
                    }).toArray();
                    byte[] hilbertCurvePosBytes = HilbertCurveUtils.indexBytes((HilbertCurve)hilbertCurve, (long[])longs, (int)63);
                    return SpaceCurveSortingHelper.appendToRow(row, hilbertCurvePosBytes);
                }
            };
        }).sortBy((Function & Serializable)f -> new ByteArraySorting((byte[])f.get(fieldNum)), true, fileNum);
    }

    private static Row appendToRow(Row row, Object value) {
        Object[] currentValues = JavaScalaConverters.convertScalaListToJavaList(row.toSeq()).toArray();
        return RowFactory.create((Object[])CollectionUtils.append((Object[])currentValues, (Object)value));
    }

    @Nonnull
    private static byte[] mapColumnValueTo8Bytes(Row row, int index, DataType dataType) {
        if (dataType instanceof LongType) {
            return BinaryUtil.longTo8Byte((long)(row.isNullAt(index) ? Long.MAX_VALUE : row.getLong(index)));
        }
        if (dataType instanceof DoubleType) {
            return BinaryUtil.doubleTo8Byte((double)(row.isNullAt(index) ? Double.MAX_VALUE : row.getDouble(index)));
        }
        if (dataType instanceof IntegerType) {
            return BinaryUtil.intTo8Byte((int)(row.isNullAt(index) ? Integer.MAX_VALUE : row.getInt(index)));
        }
        if (dataType instanceof FloatType) {
            return BinaryUtil.doubleTo8Byte((double)(row.isNullAt(index) ? 3.4028234663852886E38 : (double)row.getFloat(index)));
        }
        if (dataType instanceof StringType) {
            return BinaryUtil.utf8To8Byte((String)(row.isNullAt(index) ? "" : row.getString(index)));
        }
        if (dataType instanceof DateType) {
            return BinaryUtil.longTo8Byte((long)(row.isNullAt(index) ? Long.MAX_VALUE : row.getDate(index).getTime()));
        }
        if (dataType instanceof TimestampType) {
            return BinaryUtil.longTo8Byte((long)(row.isNullAt(index) ? Long.MAX_VALUE : row.getTimestamp(index).getTime()));
        }
        if (dataType instanceof ByteType) {
            return BinaryUtil.byteTo8Byte((byte)(row.isNullAt(index) ? (byte)127 : row.getByte(index)));
        }
        if (dataType instanceof ShortType) {
            return BinaryUtil.intTo8Byte((int)(row.isNullAt(index) ? Short.MAX_VALUE : (int)row.getShort(index)));
        }
        if (dataType instanceof DecimalType) {
            return BinaryUtil.longTo8Byte((long)(row.isNullAt(index) ? Long.MAX_VALUE : row.getDecimal(index).longValue()));
        }
        if (dataType instanceof BooleanType) {
            boolean value = !row.isNullAt(index) && row.getBoolean(index);
            return BinaryUtil.intTo8Byte((int)(value ? 1 : 0));
        }
        if (dataType instanceof BinaryType) {
            byte[] byArray;
            if (row.isNullAt(index)) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            } else {
                byArray = (byte[])row.get(index);
            }
            return BinaryUtil.paddingTo8Byte((byte[])byArray);
        }
        throw new UnsupportedOperationException(String.format("Unsupported data-type (%s)", dataType.typeName()));
    }

    private static long mapColumnValueToLong(Row row, int index, DataType dataType) {
        if (dataType instanceof LongType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : row.getLong(index);
        }
        if (dataType instanceof DoubleType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : Double.doubleToLongBits(row.getDouble(index));
        }
        if (dataType instanceof IntegerType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : (long)row.getInt(index);
        }
        if (dataType instanceof FloatType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : Double.doubleToLongBits(row.getFloat(index));
        }
        if (dataType instanceof StringType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertStringToLong((String)row.getString(index));
        }
        if (dataType instanceof DateType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : row.getDate(index).getTime();
        }
        if (dataType instanceof TimestampType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : row.getTimestamp(index).getTime();
        }
        if (dataType instanceof ByteType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertBytesToLong((byte[])new byte[]{row.getByte(index)});
        }
        if (dataType instanceof ShortType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : (long)row.getShort(index);
        }
        if (dataType instanceof DecimalType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : row.getDecimal(index).longValue();
        }
        if (dataType instanceof BooleanType) {
            boolean value = !row.isNullAt(index) && row.getBoolean(index);
            return value ? Long.MAX_VALUE : 0L;
        }
        if (dataType instanceof BinaryType) {
            return row.isNullAt(index) ? Long.MAX_VALUE : BinaryUtil.convertBytesToLong((byte[])((byte[])row.get(index)));
        }
        throw new UnsupportedOperationException(String.format("Unsupported data-type (%s)", dataType.typeName()));
    }

    public static Dataset<Row> orderDataFrameBySamplingValues(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, List<String> orderByCols, int targetPartitionCount) {
        return RangeSampleSort$.MODULE$.sortDataFrameBySample(df, layoutOptStrategy, (Seq<String>)JavaScalaConverters.convertJavaListToScalaList(orderByCols), targetPartitionCount);
    }
}

