/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.stats;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.stats.ValueMetadata;
import org.apache.hudi.stats.ValueType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.VarcharType;

public class SparkValueMetadataUtils {
    public static ValueMetadata getValueMetadata(DataType dataType, HoodieIndexVersion indexVersion) {
        if (indexVersion.lowerThan(HoodieIndexVersion.V2)) {
            return ValueMetadata.V1EmptyMetadata.get();
        }
        if (dataType == null) {
            return ValueMetadata.NULL_METADATA;
        }
        ValueType valueType = SparkValueMetadataUtils.fromDataType(dataType);
        if (valueType == ValueType.DECIMAL) {
            return ValueMetadata.DecimalMetadata.create((int)((DecimalType)dataType).precision(), (int)((DecimalType)dataType).scale());
        }
        return new ValueMetadata(valueType);
    }

    private static ValueType fromDataType(DataType dataType) {
        if (dataType instanceof NullType) {
            return ValueType.NULL;
        }
        if (dataType instanceof BooleanType) {
            return ValueType.BOOLEAN;
        }
        if (dataType instanceof IntegerType || dataType instanceof ShortType || dataType instanceof ByteType) {
            return ValueType.INT;
        }
        if (dataType instanceof LongType) {
            return ValueType.LONG;
        }
        if (dataType instanceof FloatType) {
            return ValueType.FLOAT;
        }
        if (dataType instanceof DoubleType) {
            return ValueType.DOUBLE;
        }
        if (dataType instanceof StringType || dataType instanceof CharType || dataType instanceof VarcharType) {
            return ValueType.STRING;
        }
        if (dataType instanceof TimestampType) {
            return ValueType.TIMESTAMP_MICROS;
        }
        if (dataType instanceof DecimalType) {
            return ValueType.DECIMAL;
        }
        if (dataType instanceof DateType) {
            return ValueType.DATE;
        }
        if (dataType instanceof BinaryType) {
            return ValueType.BYTES;
        }
        if (SparkAdapterSupport$.MODULE$.sparkAdapter().isTimestampNTZType(dataType)) {
            return ValueType.LOCAL_TIMESTAMP_MICROS;
        }
        throw new IllegalArgumentException("Unsupported data type: " + dataType);
    }

    public static Comparable convertSparkToJava(ValueMetadata valueMetadata, Object value) {
        if (value == null) {
            return null;
        }
        switch (valueMetadata.getValueType()) {
            case V1: {
                return (Comparable)value;
            }
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return (Boolean)value;
            }
            case INT: {
                return (Integer)value;
            }
            case LONG: {
                return (Long)value;
            }
            case FLOAT: {
                return (Float)value;
            }
            case DOUBLE: {
                return (Double)value;
            }
            case STRING: {
                return (String)value;
            }
            case BYTES: {
                return ValueType.castToBytes((Object)value);
            }
            case DECIMAL: {
                return ((Decimal)value).toJavaBigDecimal();
            }
            case DATE: {
                return ValueType.castToDate((Object)value, (ValueMetadata)valueMetadata);
            }
            case TIMESTAMP_MICROS: {
                return ValueType.castToTimestampMicros((Object)value, (ValueMetadata)valueMetadata);
            }
            case LOCAL_TIMESTAMP_MICROS: {
                return ValueType.castToLocalTimestampMicros((Object)value, (ValueMetadata)valueMetadata);
            }
        }
        throw new IllegalStateException("Spark value metadata for expression index should never be " + valueMetadata.getValueType().name());
    }

    public static Object convertJavaTypeToSparkType(Object javaVal, boolean useJava8api) {
        if (!useJava8api) {
            if (javaVal instanceof Instant) {
                return Timestamp.from((Instant)javaVal);
            }
            if (javaVal instanceof LocalDate) {
                return Date.valueOf((LocalDate)javaVal);
            }
        }
        return javaVal;
    }
}

