/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import java.util.Properties;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkMetadataWriterFactory;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadMetadataTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;

public abstract class HoodieSparkTable<T>
extends HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    private volatile boolean isMetadataTableExists = false;

    protected HoodieSparkTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T> HoodieSparkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setTimeGeneratorConfig(config.getTimeGeneratorConfig()).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).setMetaserverConfig((Properties)config.getProps()).build();
        return HoodieSparkTable.create(config, context, metaClient);
    }

    public static <T> HoodieSparkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        HoodieSparkCopyOnWriteTable hoodieSparkTable;
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                hoodieSparkTable = new HoodieSparkCopyOnWriteTable(config, context, metaClient);
                break;
            }
            case MERGE_ON_READ: {
                if (metaClient.isMetadataTable()) {
                    hoodieSparkTable = new HoodieSparkMergeOnReadMetadataTable(config, context, metaClient);
                    break;
                }
                hoodieSparkTable = new HoodieSparkMergeOnReadTable(config, context, metaClient);
                break;
            }
            default: {
                throw new HoodieException("Unsupported table type :" + metaClient.getTableType());
            }
        }
        return hoodieSparkTable;
    }

    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return SparkHoodieIndexFactory.createIndex(config);
    }

    protected Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, boolean streamingWrites, boolean autoDetectAndDeleteMetadataPartitions) {
        block6: {
            if (this.isMetadataTable()) {
                return Option.empty();
            }
            if (this.config.isMetadataTableEnabled()) {
                if (autoDetectAndDeleteMetadataPartitions) {
                    this.deleteMetadataIndexIfNecessary();
                }
                HoodieTableMetadataWriter metadataWriter = streamingWrites ? SparkMetadataWriterFactory.createWithStreamingWrites(this.getContext().getStorageConf(), this.config, failedWritesCleaningPolicy, this.getContext(), (Option<String>)Option.of((Object)triggeringInstantTimestamp)) : SparkMetadataWriterFactory.create(this.getContext().getStorageConf(), this.config, failedWritesCleaningPolicy, this.getContext(), (Option<String>)Option.of((Object)triggeringInstantTimestamp), this.metaClient.getTableConfig());
                try {
                    if (this.isMetadataTableExists || this.metaClient.getStorage().exists(HoodieTableMetadata.getMetadataTableBasePath((StoragePath)this.metaClient.getBasePath()))) {
                        this.isMetadataTableExists = true;
                        return Option.of((Object)metadataWriter);
                    }
                    break block6;
                }
                catch (IOException e) {
                    throw new HoodieMetadataException("Checking existence of metadata table failed", (Exception)e);
                }
            }
            this.maybeDeleteMetadataTable();
        }
        return Option.empty();
    }

    public Runnable getPreExecuteRunnable() {
        TaskContext taskContext = TaskContext.get();
        return () -> TaskContext$.MODULE$.setTaskContext(taskContext);
    }
}

